/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.rebalance;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.rebalance.BrokerAndVolumeIds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BrokerAndVolumeIdsFluent<A extends BrokerAndVolumeIdsFluent<A>>
extends BaseFluent<A> {
    private Integer brokerId;
    private List<Integer> volumeIds;

    public BrokerAndVolumeIdsFluent() {
    }

    public BrokerAndVolumeIdsFluent(BrokerAndVolumeIds instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BrokerAndVolumeIds instance) {
        BrokerAndVolumeIds brokerAndVolumeIds = instance = instance != null ? instance : new BrokerAndVolumeIds();
        if (instance != null) {
            this.withBrokerId(instance.getBrokerId());
            this.withVolumeIds(instance.getVolumeIds());
        }
    }

    public Integer getBrokerId() {
        return this.brokerId;
    }

    public A withBrokerId(Integer brokerId) {
        this.brokerId = brokerId;
        return (A)((Object)this);
    }

    public boolean hasBrokerId() {
        return this.brokerId != null;
    }

    public A addToVolumeIds(int index, Integer item) {
        if (this.volumeIds == null) {
            this.volumeIds = new ArrayList<Integer>();
        }
        this.volumeIds.add(index, item);
        return (A)((Object)this);
    }

    public A setToVolumeIds(int index, Integer item) {
        if (this.volumeIds == null) {
            this.volumeIds = new ArrayList<Integer>();
        }
        this.volumeIds.set(index, item);
        return (A)((Object)this);
    }

    public A addToVolumeIds(Integer ... items) {
        if (this.volumeIds == null) {
            this.volumeIds = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.volumeIds.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeIds(Collection<Integer> items) {
        if (this.volumeIds == null) {
            this.volumeIds = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.volumeIds.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeIds(Integer ... items) {
        if (this.volumeIds == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.volumeIds.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeIds(Collection<Integer> items) {
        if (this.volumeIds == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.volumeIds.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Integer> getVolumeIds() {
        return this.volumeIds;
    }

    public Integer getVolumeId(int index) {
        return this.volumeIds.get(index);
    }

    public Integer getFirstVolumeId() {
        return this.volumeIds.get(0);
    }

    public Integer getLastVolumeId() {
        return this.volumeIds.get(this.volumeIds.size() - 1);
    }

    public Integer getMatchingVolumeId(Predicate<Integer> predicate) {
        for (Integer item : this.volumeIds) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVolumeId(Predicate<Integer> predicate) {
        for (Integer item : this.volumeIds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeIds(List<Integer> volumeIds) {
        if (volumeIds != null) {
            this.volumeIds = new ArrayList<Integer>();
            for (Integer item : volumeIds) {
                this.addToVolumeIds(item);
            }
        } else {
            this.volumeIds = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeIds(Integer ... volumeIds) {
        if (this.volumeIds != null) {
            this.volumeIds.clear();
            this._visitables.remove((Object)"volumeIds");
        }
        if (volumeIds != null) {
            for (Integer item : volumeIds) {
                this.addToVolumeIds(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumeIds() {
        return this.volumeIds != null && !this.volumeIds.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BrokerAndVolumeIdsFluent that = (BrokerAndVolumeIdsFluent)((Object)o);
        if (!Objects.equals(this.brokerId, that.brokerId)) {
            return false;
        }
        return Objects.equals(this.volumeIds, that.volumeIds);
    }

    public int hashCode() {
        return Objects.hash(this.brokerId, this.volumeIds, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.brokerId != null) {
            sb.append("brokerId:");
            sb.append(this.brokerId + ",");
        }
        if (this.volumeIds != null && !this.volumeIds.isEmpty()) {
            sb.append("volumeIds:");
            sb.append(this.volumeIds);
        }
        sb.append("}");
        return sb.toString();
    }
}

