/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.rebalance;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.strimzi.api.kafka.model.common.CustomResourceConditions;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.rebalance.KafkaRebalanceSpec;
import io.strimzi.api.kafka.model.rebalance.KafkaRebalanceState;
import io.strimzi.api.kafka.model.rebalance.KafkaRebalanceStatus;
import io.strimzi.crdgenerator.annotations.Crd;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@JsonDeserialize
@Crd(spec=@Crd.Spec(names=@Crd.Spec.Names(kind="KafkaRebalance", plural="kafkarebalances", shortNames={"kr"}, categories={"strimzi"}), group="kafka.strimzi.io", scope="Namespaced", versions={@Crd.Spec.Version(name="v1beta2", served=true, storage=false), @Crd.Spec.Version(name="v1alpha1", served=true, storage=true)}, subresources=@Crd.Spec.Subresources(status={@Crd.Spec.Subresources.Status}), additionalPrinterColumns={@Crd.Spec.AdditionalPrinterColumn(name="Cluster", description="The name of the Kafka cluster this resource rebalances", jsonPath=".metadata.labels.strimzi\\.io/cluster", type="string"), @Crd.Spec.AdditionalPrinterColumn(name="Template", description="If this rebalance resource is a template", jsonPath=".metadata.annotations.strimzi\\.io/rebalance-template", type="string"), @Crd.Spec.AdditionalPrinterColumn(name="Status", description="Status of the current rebalancing operation", jsonPath=".status.conditions[*].type", type="string")}))
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
@Version(value="v1beta2")
@Group(value="kafka.strimzi.io")
public class KafkaRebalance
extends CustomResource<KafkaRebalanceSpec, KafkaRebalanceStatus>
implements Namespaced,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    public static final String SCOPE = "Namespaced";
    public static final String V1BETA2 = "v1beta2";
    public static final String V1ALPHA1 = "v1alpha1";
    public static final String CONSUMED_VERSION = "v1beta2";
    public static final List<String> VERSIONS = List.of("v1beta2", "v1alpha1");
    public static final String RESOURCE_KIND = "KafkaRebalance";
    public static final String RESOURCE_LIST_KIND = "KafkaRebalanceList";
    public static final String RESOURCE_GROUP = "kafka.strimzi.io";
    public static final String RESOURCE_PLURAL = "kafkarebalances";
    public static final String RESOURCE_SINGULAR = "kafkarebalance";
    public static final String CRD_NAME = "kafkarebalances.kafka.strimzi.io";
    public static final String SHORT_NAME = "kr";
    public static final List<String> RESOURCE_SHORTNAMES = List.of("kr");
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private String kind;

    public KafkaRebalance() {
    }

    public KafkaRebalance(KafkaRebalanceSpec spec, KafkaRebalanceStatus status) {
        this.spec = spec;
        this.status = status;
    }

    @Description(value="The specification of the Kafka rebalance.")
    public KafkaRebalanceSpec getSpec() {
        return (KafkaRebalanceSpec)super.getSpec();
    }

    @Description(value="The status of the Kafka rebalance.")
    public KafkaRebalanceStatus getStatus() {
        return (KafkaRebalanceStatus)super.getStatus();
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public static Predicate<KafkaRebalance> isInState(KafkaRebalanceState state) {
        return CustomResourceConditions.isLatestGenerationAndAnyConditionMatches(state.name(), "True");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaRebalance)) {
            return false;
        }
        KafkaRebalance other = (KafkaRebalance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        if (this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties)) {
            return false;
        }
        String this$apiVersion = this.apiVersion;
        String other$apiVersion = other.apiVersion;
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.kind;
        String other$kind = other.kind;
        return !(this$kind == null ? other$kind != null : !this$kind.equals(other$kind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaRebalance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        String $apiVersion = this.apiVersion;
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.kind;
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaRebalance(super=" + super.toString() + ", additionalProperties=" + this.getAdditionalProperties() + ", apiVersion=" + this.apiVersion + ", kind=" + this.kind + ")";
    }
}

