/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.topic;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.topic.ReplicasChangeState;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"targetReplicas", "state", "message", "sessionId"})
public class ReplicasChangeStatus
implements UnknownPropertyPreserving {
    private Integer targetReplicas;
    private ReplicasChangeState state;
    private String sessionId;
    private String message;
    private Map<String, Object> additionalProperties;

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The target replicas value requested by the user. This may be different from .spec.replicas when a change is ongoing.")
    public Integer getTargetReplicas() {
        return this.targetReplicas;
    }

    public void setTargetReplicas(Integer targetReplicas) {
        this.targetReplicas = targetReplicas;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="Current state of the replicas change operation. This can be `pending`, when the change has been requested, or `ongoing`, when the change has been successfully submitted to Cruise Control.")
    public ReplicasChangeState getState() {
        return this.state;
    }

    public void setState(ReplicasChangeState state) {
        this.state = state;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The session identifier for replicas change requests pertaining to this KafkaTopic resource. This is used by the Topic Operator to track the status of `ongoing` replicas change operations.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="Message for the user related to the replicas change request. This may contain transient error messages that would disappear on periodic reconciliations.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplicasChangeStatus)) {
            return false;
        }
        ReplicasChangeStatus other = (ReplicasChangeStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$targetReplicas = this.getTargetReplicas();
        Integer other$targetReplicas = other.getTargetReplicas();
        if (this$targetReplicas == null ? other$targetReplicas != null : !((Object)this$targetReplicas).equals(other$targetReplicas)) {
            return false;
        }
        ReplicasChangeState this$state = this.getState();
        ReplicasChangeState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplicasChangeStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $targetReplicas = this.getTargetReplicas();
        result = result * 59 + ($targetReplicas == null ? 43 : ((Object)$targetReplicas).hashCode());
        ReplicasChangeState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "ReplicasChangeStatus(super=" + super.toString() + ", targetReplicas=" + this.getTargetReplicas() + ", state=" + this.getState() + ", sessionId=" + this.getSessionId() + ", message=" + this.getMessage() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

