/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.bridge;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeClientSpec;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"enabled", "config"})
public class KafkaBridgeProducerSpec
extends KafkaBridgeClientSpec {
    public static final String FORBIDDEN_PREFIXES = "ssl., bootstrap.servers, sasl., security.";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols";
    private boolean enabled = true;

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="The Kafka producer configuration used for producer instances created by the bridge. Properties with the following prefixes cannot be set: ssl., bootstrap.servers, sasl., security. (with the exception of: ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols).")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @Description(value="Whether the HTTP producer should be enabled or disabled. The default is enabled (`true`).")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaBridgeProducerSpec)) {
            return false;
        }
        KafkaBridgeProducerSpec other = (KafkaBridgeProducerSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isEnabled() == other.isEnabled();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaBridgeProducerSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "KafkaBridgeProducerSpec(super=" + super.toString() + ", enabled=" + this.isEnabled() + ")";
    }
}

