/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.SystemProperty;
import io.strimzi.api.kafka.model.common.SystemPropertyBuilder;
import io.strimzi.api.kafka.model.common.SystemPropertyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class JvmOptionsFluent<A extends JvmOptionsFluent<A>>
extends BaseFluent<A> {
    private String xmx;
    private String xms;
    private boolean gcLoggingEnabled;
    private ArrayList<SystemPropertyBuilder> javaSystemProperties;
    private Map<String, String> xx;

    public JvmOptionsFluent() {
    }

    public JvmOptionsFluent(JvmOptions instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JvmOptions instance) {
        JvmOptions jvmOptions = instance = instance != null ? instance : new JvmOptions();
        if (instance != null) {
            this.withXmx(instance.getXmx());
            this.withXms(instance.getXms());
            this.withGcLoggingEnabled(instance.isGcLoggingEnabled());
            this.withJavaSystemProperties(instance.getJavaSystemProperties());
            this.withXx(instance.getXx());
        }
    }

    public String getXmx() {
        return this.xmx;
    }

    public A withXmx(String xmx) {
        this.xmx = xmx;
        return (A)((Object)this);
    }

    public boolean hasXmx() {
        return this.xmx != null;
    }

    public String getXms() {
        return this.xms;
    }

    public A withXms(String xms) {
        this.xms = xms;
        return (A)((Object)this);
    }

    public boolean hasXms() {
        return this.xms != null;
    }

    public boolean isGcLoggingEnabled() {
        return this.gcLoggingEnabled;
    }

    public A withGcLoggingEnabled(boolean gcLoggingEnabled) {
        this.gcLoggingEnabled = gcLoggingEnabled;
        return (A)((Object)this);
    }

    public boolean hasGcLoggingEnabled() {
        return true;
    }

    public A addToJavaSystemProperties(int index, SystemProperty item) {
        if (this.javaSystemProperties == null) {
            this.javaSystemProperties = new ArrayList();
        }
        SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
        if (index < 0 || index >= this.javaSystemProperties.size()) {
            this._visitables.get((Object)"javaSystemProperties").add(builder);
            this.javaSystemProperties.add(builder);
        } else {
            this._visitables.get((Object)"javaSystemProperties").add(index, builder);
            this.javaSystemProperties.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToJavaSystemProperties(int index, SystemProperty item) {
        if (this.javaSystemProperties == null) {
            this.javaSystemProperties = new ArrayList();
        }
        SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
        if (index < 0 || index >= this.javaSystemProperties.size()) {
            this._visitables.get((Object)"javaSystemProperties").add(builder);
            this.javaSystemProperties.add(builder);
        } else {
            this._visitables.get((Object)"javaSystemProperties").set(index, builder);
            this.javaSystemProperties.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToJavaSystemProperties(SystemProperty ... items) {
        if (this.javaSystemProperties == null) {
            this.javaSystemProperties = new ArrayList();
        }
        for (SystemProperty item : items) {
            SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
            this._visitables.get((Object)"javaSystemProperties").add(builder);
            this.javaSystemProperties.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToJavaSystemProperties(Collection<SystemProperty> items) {
        if (this.javaSystemProperties == null) {
            this.javaSystemProperties = new ArrayList();
        }
        for (SystemProperty item : items) {
            SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
            this._visitables.get((Object)"javaSystemProperties").add(builder);
            this.javaSystemProperties.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromJavaSystemProperties(SystemProperty ... items) {
        if (this.javaSystemProperties == null) {
            return (A)((Object)this);
        }
        for (SystemProperty item : items) {
            SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
            this._visitables.get((Object)"javaSystemProperties").remove((Object)builder);
            this.javaSystemProperties.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromJavaSystemProperties(Collection<SystemProperty> items) {
        if (this.javaSystemProperties == null) {
            return (A)((Object)this);
        }
        for (SystemProperty item : items) {
            SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
            this._visitables.get((Object)"javaSystemProperties").remove((Object)builder);
            this.javaSystemProperties.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromJavaSystemProperties(Predicate<SystemPropertyBuilder> predicate) {
        if (this.javaSystemProperties == null) {
            return (A)((Object)this);
        }
        Iterator<SystemPropertyBuilder> each = this.javaSystemProperties.iterator();
        List visitables = this._visitables.get((Object)"javaSystemProperties");
        while (each.hasNext()) {
            SystemPropertyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SystemProperty> buildJavaSystemProperties() {
        return this.javaSystemProperties != null ? JvmOptionsFluent.build(this.javaSystemProperties) : null;
    }

    public SystemProperty buildJavaSystemProperty(int index) {
        return this.javaSystemProperties.get(index).build();
    }

    public SystemProperty buildFirstJavaSystemProperty() {
        return this.javaSystemProperties.get(0).build();
    }

    public SystemProperty buildLastJavaSystemProperty() {
        return this.javaSystemProperties.get(this.javaSystemProperties.size() - 1).build();
    }

    public SystemProperty buildMatchingJavaSystemProperty(Predicate<SystemPropertyBuilder> predicate) {
        for (SystemPropertyBuilder item : this.javaSystemProperties) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingJavaSystemProperty(Predicate<SystemPropertyBuilder> predicate) {
        for (SystemPropertyBuilder item : this.javaSystemProperties) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withJavaSystemProperties(List<SystemProperty> javaSystemProperties) {
        if (this.javaSystemProperties != null) {
            this._visitables.get((Object)"javaSystemProperties").clear();
        }
        if (javaSystemProperties != null) {
            this.javaSystemProperties = new ArrayList();
            for (SystemProperty item : javaSystemProperties) {
                this.addToJavaSystemProperties(item);
            }
        } else {
            this.javaSystemProperties = null;
        }
        return (A)((Object)this);
    }

    public A withJavaSystemProperties(SystemProperty ... javaSystemProperties) {
        if (this.javaSystemProperties != null) {
            this.javaSystemProperties.clear();
            this._visitables.remove((Object)"javaSystemProperties");
        }
        if (javaSystemProperties != null) {
            for (SystemProperty item : javaSystemProperties) {
                this.addToJavaSystemProperties(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasJavaSystemProperties() {
        return this.javaSystemProperties != null && !this.javaSystemProperties.isEmpty();
    }

    public JavaSystemPropertiesNested<A> addNewJavaSystemProperty() {
        return new JavaSystemPropertiesNested(-1, null);
    }

    public JavaSystemPropertiesNested<A> addNewJavaSystemPropertyLike(SystemProperty item) {
        return new JavaSystemPropertiesNested(-1, item);
    }

    public JavaSystemPropertiesNested<A> setNewJavaSystemPropertyLike(int index, SystemProperty item) {
        return new JavaSystemPropertiesNested(index, item);
    }

    public JavaSystemPropertiesNested<A> editJavaSystemProperty(int index) {
        if (this.javaSystemProperties.size() <= index) {
            throw new RuntimeException("Can't edit javaSystemProperties. Index exceeds size.");
        }
        return this.setNewJavaSystemPropertyLike(index, this.buildJavaSystemProperty(index));
    }

    public JavaSystemPropertiesNested<A> editFirstJavaSystemProperty() {
        if (this.javaSystemProperties.size() == 0) {
            throw new RuntimeException("Can't edit first javaSystemProperties. The list is empty.");
        }
        return this.setNewJavaSystemPropertyLike(0, this.buildJavaSystemProperty(0));
    }

    public JavaSystemPropertiesNested<A> editLastJavaSystemProperty() {
        int index = this.javaSystemProperties.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last javaSystemProperties. The list is empty.");
        }
        return this.setNewJavaSystemPropertyLike(index, this.buildJavaSystemProperty(index));
    }

    public JavaSystemPropertiesNested<A> editMatchingJavaSystemProperty(Predicate<SystemPropertyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.javaSystemProperties.size(); ++i) {
            if (!predicate.test(this.javaSystemProperties.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching javaSystemProperties. No match found.");
        }
        return this.setNewJavaSystemPropertyLike(index, this.buildJavaSystemProperty(index));
    }

    public A addToXx(String key, String value) {
        if (this.xx == null && key != null && value != null) {
            this.xx = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.xx.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToXx(Map<String, String> map) {
        if (this.xx == null && map != null) {
            this.xx = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.xx.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromXx(String key) {
        if (this.xx == null) {
            return (A)((Object)this);
        }
        if (key != null && this.xx != null) {
            this.xx.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromXx(Map<String, String> map) {
        if (this.xx == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.xx == null) continue;
                this.xx.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getXx() {
        return this.xx;
    }

    public <K, V> A withXx(Map<String, String> xx) {
        this.xx = xx == null ? null : new LinkedHashMap<String, String>(xx);
        return (A)((Object)this);
    }

    public boolean hasXx() {
        return this.xx != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JvmOptionsFluent that = (JvmOptionsFluent)((Object)o);
        if (!Objects.equals(this.xmx, that.xmx)) {
            return false;
        }
        if (!Objects.equals(this.xms, that.xms)) {
            return false;
        }
        if (this.gcLoggingEnabled != that.gcLoggingEnabled) {
            return false;
        }
        if (!Objects.equals(this.javaSystemProperties, that.javaSystemProperties)) {
            return false;
        }
        return Objects.equals(this.xx, that.xx);
    }

    public int hashCode() {
        return Objects.hash(this.xmx, this.xms, this.gcLoggingEnabled, this.javaSystemProperties, this.xx, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.xmx != null) {
            sb.append("xmx:");
            sb.append(this.xmx + ",");
        }
        if (this.xms != null) {
            sb.append("xms:");
            sb.append(this.xms + ",");
        }
        sb.append("gcLoggingEnabled:");
        sb.append(this.gcLoggingEnabled + ",");
        if (this.javaSystemProperties != null && !this.javaSystemProperties.isEmpty()) {
            sb.append("javaSystemProperties:");
            sb.append(String.valueOf(this.javaSystemProperties) + ",");
        }
        if (this.xx != null && !this.xx.isEmpty()) {
            sb.append("xx:");
            sb.append(this.xx);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withGcLoggingEnabled() {
        return this.withGcLoggingEnabled(true);
    }

    public class JavaSystemPropertiesNested<N>
    extends SystemPropertyFluent<JavaSystemPropertiesNested<N>>
    implements Nested<N> {
        SystemPropertyBuilder builder;
        int index;

        JavaSystemPropertiesNested(int index, SystemProperty item) {
            this.index = index;
            this.builder = new SystemPropertyBuilder(this, item);
        }

        public N and() {
            return (N)JvmOptionsFluent.this.setToJavaSystemProperties(this.index, this.builder.build());
        }

        public N endJavaSystemProperty() {
            return this.and();
        }
    }
}

