/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplate;
import io.strimzi.api.kafka.model.common.template.IpFamily;
import io.strimzi.api.kafka.model.common.template.IpFamilyPolicy;
import io.strimzi.api.kafka.model.common.template.MetadataTemplate;
import io.strimzi.api.kafka.model.common.template.MetadataTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.MetadataTemplateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class InternalServiceTemplateFluent<A extends InternalServiceTemplateFluent<A>>
extends BaseFluent<A> {
    private MetadataTemplateBuilder metadata;
    private IpFamilyPolicy ipFamilyPolicy;
    private List<IpFamily> ipFamilies;

    public InternalServiceTemplateFluent() {
    }

    public InternalServiceTemplateFluent(InternalServiceTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(InternalServiceTemplate instance) {
        InternalServiceTemplate internalServiceTemplate = instance = instance != null ? instance : new InternalServiceTemplate();
        if (instance != null) {
            this.withMetadata(instance.getMetadata());
            this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
            this.withIpFamilies(instance.getIpFamilies());
        }
    }

    public MetadataTemplate buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(MetadataTemplate metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new MetadataTemplateBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove((Object)this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new MetadataTemplateBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public IpFamilyPolicy getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    public A withIpFamilyPolicy(IpFamilyPolicy ipFamilyPolicy) {
        this.ipFamilyPolicy = ipFamilyPolicy;
        return (A)((Object)this);
    }

    public boolean hasIpFamilyPolicy() {
        return this.ipFamilyPolicy != null;
    }

    public A addToIpFamilies(int index, IpFamily item) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        this.ipFamilies.add(index, item);
        return (A)((Object)this);
    }

    public A setToIpFamilies(int index, IpFamily item) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        this.ipFamilies.set(index, item);
        return (A)((Object)this);
    }

    public A addToIpFamilies(IpFamily ... items) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        for (IpFamily item : items) {
            this.ipFamilies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpFamilies(Collection<IpFamily> items) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        for (IpFamily item : items) {
            this.ipFamilies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpFamilies(IpFamily ... items) {
        if (this.ipFamilies == null) {
            return (A)((Object)this);
        }
        for (IpFamily item : items) {
            this.ipFamilies.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpFamilies(Collection<IpFamily> items) {
        if (this.ipFamilies == null) {
            return (A)((Object)this);
        }
        for (IpFamily item : items) {
            this.ipFamilies.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public List<IpFamily> getIpFamilies() {
        return this.ipFamilies;
    }

    public IpFamily getIpFamily(int index) {
        return this.ipFamilies.get(index);
    }

    public IpFamily getFirstIpFamily() {
        return this.ipFamilies.get(0);
    }

    public IpFamily getLastIpFamily() {
        return this.ipFamilies.get(this.ipFamilies.size() - 1);
    }

    public IpFamily getMatchingIpFamily(Predicate<IpFamily> predicate) {
        for (IpFamily item : this.ipFamilies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIpFamily(Predicate<IpFamily> predicate) {
        for (IpFamily item : this.ipFamilies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIpFamilies(List<IpFamily> ipFamilies) {
        if (ipFamilies != null) {
            this.ipFamilies = new ArrayList<IpFamily>();
            for (IpFamily item : ipFamilies) {
                this.addToIpFamilies(item);
            }
        } else {
            this.ipFamilies = null;
        }
        return (A)((Object)this);
    }

    public A withIpFamilies(IpFamily ... ipFamilies) {
        if (this.ipFamilies != null) {
            this.ipFamilies.clear();
            this._visitables.remove((Object)"ipFamilies");
        }
        if (ipFamilies != null) {
            for (IpFamily item : ipFamilies) {
                this.addToIpFamilies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIpFamilies() {
        return this.ipFamilies != null && !this.ipFamilies.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InternalServiceTemplateFluent that = (InternalServiceTemplateFluent)((Object)o);
        if (!Objects.equals((Object)this.metadata, (Object)that.metadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.ipFamilyPolicy, (Object)that.ipFamilyPolicy)) {
            return false;
        }
        return Objects.equals(this.ipFamilies, that.ipFamilies);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata, this.ipFamilyPolicy, this.ipFamilies, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf((Object)this.metadata) + ",");
        }
        if (this.ipFamilyPolicy != null) {
            sb.append("ipFamilyPolicy:");
            sb.append(String.valueOf((Object)this.ipFamilyPolicy) + ",");
        }
        if (this.ipFamilies != null && !this.ipFamilies.isEmpty()) {
            sb.append("ipFamilies:");
            sb.append(this.ipFamilies);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends MetadataTemplateFluent<MetadataNested<N>>
    implements Nested<N> {
        MetadataTemplateBuilder builder;

        MetadataNested(MetadataTemplate item) {
            this.builder = new MetadataTemplateBuilder(this, item);
        }

        public N and() {
            return (N)InternalServiceTemplateFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

