/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

public class KafkaConnectResources {
    protected KafkaConnectResources() {
    }

    public static String componentName(String clusterName) {
        return clusterName + "-connect";
    }

    public static String serviceAccountName(String clusterName) {
        return KafkaConnectResources.componentName(clusterName);
    }

    public static String serviceName(String clusterName) {
        return clusterName + "-connect-api";
    }

    public static String jmxSecretName(String clusterName) {
        return clusterName + "-kafka-connect-jmx";
    }

    public static String configMapName(String clusterName) {
        return KafkaConnectResources.componentName(clusterName) + "-config";
    }

    public static String configStorageTopicOffsets(String clusterName) {
        return KafkaConnectResources.componentName(clusterName) + "-offsets";
    }

    public static String configStorageTopicStatus(String clusterName) {
        return KafkaConnectResources.componentName(clusterName) + "-status";
    }

    public static String qualifiedServiceName(String clusterName, String namespace) {
        return KafkaConnectResources.serviceName(clusterName) + "." + namespace + ".svc";
    }

    public static String url(String clusterName, String namespace, int port) {
        return "http://" + KafkaConnectResources.qualifiedServiceName(clusterName, namespace) + ":" + port;
    }

    public static String initContainerClusterRoleBindingName(String clusterName, String namespace) {
        return "strimzi-" + namespace + "-" + KafkaConnectResources.componentName(clusterName) + "-init";
    }

    public static String dockerFileConfigMapName(String clusterName) {
        return KafkaConnectResources.componentName(clusterName) + "-dockerfile";
    }

    public static String buildPodName(String clusterName) {
        return KafkaConnectResources.componentName(clusterName) + "-build";
    }

    public static String buildServiceAccountName(String clusterName) {
        return KafkaConnectResources.componentName(clusterName) + "-build";
    }

    public static String buildConfigName(String clusterName) {
        return KafkaConnectResources.componentName(clusterName) + "-build";
    }

    public static String buildName(String clusterName, Long buildVersion) {
        return KafkaConnectResources.buildConfigName(clusterName) + "-" + buildVersion;
    }

    public String toString() {
        return "KafkaConnectResources()";
    }
}

