/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.ClientTls;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.connect.AbstractKafkaConnectSpec;
import io.strimzi.api.kafka.model.connect.build.Build;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.util.HashMap;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "replicas", "image", "bootstrapServers", "tls", "authentication", "config", "resources", "livenessProbe", "readinessProbe", "jvmOptions", "jmxOptions", "logging", "clientRackInitImage", "rack", "metricsConfig", "tracing", "template", "externalConfiguration", "build"})
public class KafkaConnectSpec
extends AbstractKafkaConnectSpec {
    public static final String FORBIDDEN_PREFIXES = "ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers, consumer.interceptor.classes, producer.interceptor.classes";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols";
    private Map<String, Object> config = new HashMap<String, Object>(0);
    private String bootstrapServers;
    private ClientTls tls;
    private KafkaClientAuthentication authentication;
    private Build build;

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="The Kafka Connect configuration. Properties with the following prefixes cannot be set: ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers, consumer.interceptor.classes, producer.interceptor.classes (with the exception of: ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols).")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="Bootstrap servers to connect to. This should be given as a comma separated list of _<hostname>_:_<port>_ pairs.")
    @JsonProperty(required=true)
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Description(value="TLS configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ClientTls getTls() {
        return this.tls;
    }

    public void setTls(ClientTls tls) {
        this.tls = tls;
    }

    @Description(value="Authentication configuration for Kafka Connect")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaClientAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(KafkaClientAuthentication authentication) {
        this.authentication = authentication;
    }

    @Description(value="Configures how the Connect container image should be built. Optional.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Build getBuild() {
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConnectSpec)) {
            return false;
        }
        KafkaConnectSpec other = (KafkaConnectSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$config = this.config;
        Map<String, Object> other$config = other.config;
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        String this$bootstrapServers = this.bootstrapServers;
        String other$bootstrapServers = other.bootstrapServers;
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        ClientTls this$tls = this.tls;
        ClientTls other$tls = other.tls;
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        KafkaClientAuthentication this$authentication = this.authentication;
        KafkaClientAuthentication other$authentication = other.authentication;
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        Build this$build = this.build;
        Build other$build = other.build;
        return !(this$build == null ? other$build != null : !((Object)this$build).equals(other$build));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaConnectSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $config = this.config;
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        String $bootstrapServers = this.bootstrapServers;
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        ClientTls $tls = this.tls;
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        KafkaClientAuthentication $authentication = this.authentication;
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        Build $build = this.build;
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaConnectSpec(super=" + super.toString() + ", config=" + String.valueOf(this.getConfig()) + ", bootstrapServers=" + this.getBootstrapServers() + ", tls=" + String.valueOf(this.getTls()) + ", authentication=" + String.valueOf(this.getAuthentication()) + ", build=" + String.valueOf(this.getBuild()) + ")";
    }
}

