/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connector;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.ConnectorState;
import io.strimzi.api.kafka.model.common.SpecFluent;
import io.strimzi.api.kafka.model.connector.AbstractConnectorSpec;
import io.strimzi.api.kafka.model.connector.AlterOffsets;
import io.strimzi.api.kafka.model.connector.AlterOffsetsBuilder;
import io.strimzi.api.kafka.model.connector.AlterOffsetsFluent;
import io.strimzi.api.kafka.model.connector.AutoRestart;
import io.strimzi.api.kafka.model.connector.AutoRestartBuilder;
import io.strimzi.api.kafka.model.connector.AutoRestartFluent;
import io.strimzi.api.kafka.model.connector.ListOffsets;
import io.strimzi.api.kafka.model.connector.ListOffsetsBuilder;
import io.strimzi.api.kafka.model.connector.ListOffsetsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AbstractConnectorSpecFluent<A extends AbstractConnectorSpecFluent<A>>
extends SpecFluent<A> {
    private Integer tasksMax;
    private Boolean pause;
    private Map<String, Object> config;
    private ConnectorState state;
    private AutoRestartBuilder autoRestart;
    private ListOffsetsBuilder listOffsets;
    private AlterOffsetsBuilder alterOffsets;

    public AbstractConnectorSpecFluent() {
    }

    public AbstractConnectorSpecFluent(AbstractConnectorSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AbstractConnectorSpec instance) {
        if (instance != null) {
            this.withTasksMax(instance.getTasksMax());
            this.withPause(instance.getPause());
            this.withConfig(instance.getConfig());
            this.withState(instance.getState());
            this.withAutoRestart(instance.getAutoRestart());
            this.withListOffsets(instance.getListOffsets());
            this.withAlterOffsets(instance.getAlterOffsets());
        }
    }

    public Integer getTasksMax() {
        return this.tasksMax;
    }

    public A withTasksMax(Integer tasksMax) {
        this.tasksMax = tasksMax;
        return (A)((Object)this);
    }

    public boolean hasTasksMax() {
        return this.tasksMax != null;
    }

    public Boolean getPause() {
        return this.pause;
    }

    public A withPause(Boolean pause) {
        this.pause = pause;
        return (A)((Object)this);
    }

    public boolean hasPause() {
        return this.pause != null;
    }

    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public ConnectorState getState() {
        return this.state;
    }

    public A withState(ConnectorState state) {
        this.state = state;
        return (A)((Object)this);
    }

    public boolean hasState() {
        return this.state != null;
    }

    public AutoRestart buildAutoRestart() {
        return this.autoRestart != null ? this.autoRestart.build() : null;
    }

    public A withAutoRestart(AutoRestart autoRestart) {
        this._visitables.remove((Object)"autoRestart");
        if (autoRestart != null) {
            this.autoRestart = new AutoRestartBuilder(autoRestart);
            this._visitables.get((Object)"autoRestart").add(this.autoRestart);
        } else {
            this.autoRestart = null;
            this._visitables.get((Object)"autoRestart").remove((Object)this.autoRestart);
        }
        return (A)((Object)this);
    }

    public boolean hasAutoRestart() {
        return this.autoRestart != null;
    }

    public AutoRestartNested<A> withNewAutoRestart() {
        return new AutoRestartNested(null);
    }

    public AutoRestartNested<A> withNewAutoRestartLike(AutoRestart item) {
        return new AutoRestartNested(item);
    }

    public AutoRestartNested<A> editAutoRestart() {
        return this.withNewAutoRestartLike(Optional.ofNullable(this.buildAutoRestart()).orElse(null));
    }

    public AutoRestartNested<A> editOrNewAutoRestart() {
        return this.withNewAutoRestartLike(Optional.ofNullable(this.buildAutoRestart()).orElse(new AutoRestartBuilder().build()));
    }

    public AutoRestartNested<A> editOrNewAutoRestartLike(AutoRestart item) {
        return this.withNewAutoRestartLike(Optional.ofNullable(this.buildAutoRestart()).orElse(item));
    }

    public ListOffsets buildListOffsets() {
        return this.listOffsets != null ? this.listOffsets.build() : null;
    }

    public A withListOffsets(ListOffsets listOffsets) {
        this._visitables.remove((Object)"listOffsets");
        if (listOffsets != null) {
            this.listOffsets = new ListOffsetsBuilder(listOffsets);
            this._visitables.get((Object)"listOffsets").add(this.listOffsets);
        } else {
            this.listOffsets = null;
            this._visitables.get((Object)"listOffsets").remove((Object)this.listOffsets);
        }
        return (A)((Object)this);
    }

    public boolean hasListOffsets() {
        return this.listOffsets != null;
    }

    public ListOffsetsNested<A> withNewListOffsets() {
        return new ListOffsetsNested(null);
    }

    public ListOffsetsNested<A> withNewListOffsetsLike(ListOffsets item) {
        return new ListOffsetsNested(item);
    }

    public ListOffsetsNested<A> editListOffsets() {
        return this.withNewListOffsetsLike(Optional.ofNullable(this.buildListOffsets()).orElse(null));
    }

    public ListOffsetsNested<A> editOrNewListOffsets() {
        return this.withNewListOffsetsLike(Optional.ofNullable(this.buildListOffsets()).orElse(new ListOffsetsBuilder().build()));
    }

    public ListOffsetsNested<A> editOrNewListOffsetsLike(ListOffsets item) {
        return this.withNewListOffsetsLike(Optional.ofNullable(this.buildListOffsets()).orElse(item));
    }

    public AlterOffsets buildAlterOffsets() {
        return this.alterOffsets != null ? this.alterOffsets.build() : null;
    }

    public A withAlterOffsets(AlterOffsets alterOffsets) {
        this._visitables.remove((Object)"alterOffsets");
        if (alterOffsets != null) {
            this.alterOffsets = new AlterOffsetsBuilder(alterOffsets);
            this._visitables.get((Object)"alterOffsets").add(this.alterOffsets);
        } else {
            this.alterOffsets = null;
            this._visitables.get((Object)"alterOffsets").remove((Object)this.alterOffsets);
        }
        return (A)((Object)this);
    }

    public boolean hasAlterOffsets() {
        return this.alterOffsets != null;
    }

    public AlterOffsetsNested<A> withNewAlterOffsets() {
        return new AlterOffsetsNested(null);
    }

    public AlterOffsetsNested<A> withNewAlterOffsetsLike(AlterOffsets item) {
        return new AlterOffsetsNested(item);
    }

    public AlterOffsetsNested<A> editAlterOffsets() {
        return this.withNewAlterOffsetsLike(Optional.ofNullable(this.buildAlterOffsets()).orElse(null));
    }

    public AlterOffsetsNested<A> editOrNewAlterOffsets() {
        return this.withNewAlterOffsetsLike(Optional.ofNullable(this.buildAlterOffsets()).orElse(new AlterOffsetsBuilder().build()));
    }

    public AlterOffsetsNested<A> editOrNewAlterOffsetsLike(AlterOffsets item) {
        return this.withNewAlterOffsetsLike(Optional.ofNullable(this.buildAlterOffsets()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractConnectorSpecFluent that = (AbstractConnectorSpecFluent)((Object)o);
        if (!Objects.equals(this.tasksMax, that.tasksMax)) {
            return false;
        }
        if (!Objects.equals(this.pause, that.pause)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals((Object)this.state, (Object)that.state)) {
            return false;
        }
        if (!Objects.equals((Object)this.autoRestart, (Object)that.autoRestart)) {
            return false;
        }
        if (!Objects.equals((Object)this.listOffsets, (Object)that.listOffsets)) {
            return false;
        }
        return Objects.equals((Object)this.alterOffsets, (Object)that.alterOffsets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.tasksMax, this.pause, this.config, this.state, this.autoRestart, this.listOffsets, this.alterOffsets, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tasksMax != null) {
            sb.append("tasksMax:");
            sb.append(this.tasksMax + ",");
        }
        if (this.pause != null) {
            sb.append("pause:");
            sb.append(this.pause + ",");
        }
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(String.valueOf(this.config) + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(String.valueOf((Object)this.state) + ",");
        }
        if (this.autoRestart != null) {
            sb.append("autoRestart:");
            sb.append(String.valueOf((Object)this.autoRestart) + ",");
        }
        if (this.listOffsets != null) {
            sb.append("listOffsets:");
            sb.append(String.valueOf((Object)this.listOffsets) + ",");
        }
        if (this.alterOffsets != null) {
            sb.append("alterOffsets:");
            sb.append((Object)this.alterOffsets);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withPause() {
        return this.withPause(true);
    }

    public class AutoRestartNested<N>
    extends AutoRestartFluent<AutoRestartNested<N>>
    implements Nested<N> {
        AutoRestartBuilder builder;

        AutoRestartNested(AutoRestart item) {
            this.builder = new AutoRestartBuilder(this, item);
        }

        public N and() {
            return (N)AbstractConnectorSpecFluent.this.withAutoRestart(this.builder.build());
        }

        public N endAutoRestart() {
            return this.and();
        }
    }

    public class ListOffsetsNested<N>
    extends ListOffsetsFluent<ListOffsetsNested<N>>
    implements Nested<N> {
        ListOffsetsBuilder builder;

        ListOffsetsNested(ListOffsets item) {
            this.builder = new ListOffsetsBuilder(this, item);
        }

        public N and() {
            return (N)AbstractConnectorSpecFluent.this.withListOffsets(this.builder.build());
        }

        public N endListOffsets() {
            return this.and();
        }
    }

    public class AlterOffsetsNested<N>
    extends AlterOffsetsFluent<AlterOffsetsNested<N>>
    implements Nested<N> {
        AlterOffsetsBuilder builder;

        AlterOffsetsNested(AlterOffsets item) {
            this.builder = new AlterOffsetsBuilder(this, item);
        }

        public N and() {
            return (N)AbstractConnectorSpecFluent.this.withAlterOffsets(this.builder.build());
        }

        public N endAlterOffsets() {
            return this.and();
        }
    }
}

