/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceState;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatusBrokers;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"state", "lastTransitionTime", "modes"})
public class KafkaAutoRebalanceStatus
implements UnknownPropertyPreserving {
    private KafkaAutoRebalanceState state;
    private String lastTransitionTime;
    private List<KafkaAutoRebalanceStatusBrokers> modes;
    private Map<String, Object> additionalProperties;

    @Description(value="The current state of an auto-rebalancing operation. Possible values are: \n\n* `Idle` as the initial state when an auto-rebalancing is requested or as final state when it completes or fails.\n* `RebalanceOnScaleDown` if an auto-rebalance related to a scale-down operation is running.\n* `RebalanceOnScaleUp` if an auto-rebalance related to a scale-up operation is running.")
    public KafkaAutoRebalanceState getState() {
        return this.state;
    }

    public void setState(KafkaAutoRebalanceState state) {
        this.state = state;
    }

    @Description(value="The timestamp of the latest auto-rebalancing state update")
    public String getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(String lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    @Description(value="List of modes where an auto-rebalancing operation is either running or queued. \nEach mode entry (`add-brokers` or `remove-brokers`) includes one of the following: \n\n* Broker IDs for a current auto-rebalance. \n* Broker IDs for a queued auto-rebalance (if a previous rebalance is still in progress).")
    public List<KafkaAutoRebalanceStatusBrokers> getModes() {
        return this.modes;
    }

    public void setModes(List<KafkaAutoRebalanceStatusBrokers> modes) {
        this.modes = modes;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaAutoRebalanceStatus)) {
            return false;
        }
        KafkaAutoRebalanceStatus other = (KafkaAutoRebalanceStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KafkaAutoRebalanceState this$state = this.getState();
        KafkaAutoRebalanceState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$lastTransitionTime = this.getLastTransitionTime();
        String other$lastTransitionTime = other.getLastTransitionTime();
        if (this$lastTransitionTime == null ? other$lastTransitionTime != null : !this$lastTransitionTime.equals(other$lastTransitionTime)) {
            return false;
        }
        List<KafkaAutoRebalanceStatusBrokers> this$modes = this.getModes();
        List<KafkaAutoRebalanceStatusBrokers> other$modes = other.getModes();
        if (this$modes == null ? other$modes != null : !((Object)this$modes).equals(other$modes)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaAutoRebalanceStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KafkaAutoRebalanceState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $lastTransitionTime = this.getLastTransitionTime();
        result = result * 59 + ($lastTransitionTime == null ? 43 : $lastTransitionTime.hashCode());
        List<KafkaAutoRebalanceStatusBrokers> $modes = this.getModes();
        result = result * 59 + ($modes == null ? 43 : ((Object)$modes).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaAutoRebalanceStatus(state=" + String.valueOf((Object)this.getState()) + ", lastTransitionTime=" + this.getLastTransitionTime() + ", modes=" + String.valueOf(this.getModes()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }
}

