/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.CertSecretSource;
import io.strimzi.api.kafka.model.common.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.common.CertSecretSourceFluent;
import io.strimzi.api.kafka.model.common.GenericSecretSource;
import io.strimzi.api.kafka.model.common.GenericSecretSourceBuilder;
import io.strimzi.api.kafka.model.common.GenericSecretSourceFluent;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationFluent;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationOAuth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaListenerAuthenticationOAuthFluent<A extends KafkaListenerAuthenticationOAuthFluent<A>>
extends KafkaListenerAuthenticationFluent<A> {
    private String clientId;
    private GenericSecretSourceBuilder clientSecret;
    private String validIssuerUri;
    private boolean checkIssuer;
    private boolean checkAudience;
    private String jwksEndpointUri;
    private Integer jwksRefreshSeconds;
    private Integer jwksMinRefreshPauseSeconds;
    private Integer jwksExpirySeconds;
    private boolean jwksIgnoreKeyUse;
    private String introspectionEndpointUri;
    private String serverBearerTokenLocation;
    private String userNameClaim;
    private String userNamePrefix;
    private String fallbackUserNameClaim;
    private String fallbackUserNamePrefix;
    private String groupsClaim;
    private String groupsClaimDelimiter;
    private String userInfoEndpointUri;
    private boolean checkAccessTokenType;
    private String validTokenType;
    private boolean accessTokenIsJwt;
    private ArrayList<CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private Boolean enableECDSA;
    private Integer maxSecondsWithoutReauthentication;
    private boolean enablePlain;
    private String tokenEndpointUri;
    private boolean enableOauthBearer;
    private String customClaimCheck;
    private Integer connectTimeoutSeconds;
    private Integer readTimeoutSeconds;
    private Integer httpRetries;
    private Integer httpRetryPauseMs;
    private String clientScope;
    private String clientAudience;
    private boolean enableMetrics;
    private boolean failFast;
    private boolean includeAcceptHeader;

    public KafkaListenerAuthenticationOAuthFluent() {
    }

    public KafkaListenerAuthenticationOAuthFluent(KafkaListenerAuthenticationOAuth instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaListenerAuthenticationOAuth instance) {
        KafkaListenerAuthenticationOAuth kafkaListenerAuthenticationOAuth = instance = instance != null ? instance : new KafkaListenerAuthenticationOAuth();
        if (instance != null) {
            this.withClientId(instance.getClientId());
            this.withClientSecret(instance.getClientSecret());
            this.withValidIssuerUri(instance.getValidIssuerUri());
            this.withCheckIssuer(instance.isCheckIssuer());
            this.withCheckAudience(instance.isCheckAudience());
            this.withJwksEndpointUri(instance.getJwksEndpointUri());
            this.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());
            this.withJwksMinRefreshPauseSeconds(instance.getJwksMinRefreshPauseSeconds());
            this.withJwksExpirySeconds(instance.getJwksExpirySeconds());
            this.withJwksIgnoreKeyUse(instance.getJwksIgnoreKeyUse());
            this.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());
            this.withServerBearerTokenLocation(instance.getServerBearerTokenLocation());
            this.withUserNameClaim(instance.getUserNameClaim());
            this.withUserNamePrefix(instance.getUserNamePrefix());
            this.withFallbackUserNameClaim(instance.getFallbackUserNameClaim());
            this.withFallbackUserNamePrefix(instance.getFallbackUserNamePrefix());
            this.withGroupsClaim(instance.getGroupsClaim());
            this.withGroupsClaimDelimiter(instance.getGroupsClaimDelimiter());
            this.withUserInfoEndpointUri(instance.getUserInfoEndpointUri());
            this.withCheckAccessTokenType(instance.isCheckAccessTokenType());
            this.withValidTokenType(instance.getValidTokenType());
            this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
            this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
            this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
            this.withEnableECDSA(instance.getEnableECDSA());
            this.withMaxSecondsWithoutReauthentication(instance.getMaxSecondsWithoutReauthentication());
            this.withEnablePlain(instance.isEnablePlain());
            this.withTokenEndpointUri(instance.getTokenEndpointUri());
            this.withEnableOauthBearer(instance.isEnableOauthBearer());
            this.withCustomClaimCheck(instance.getCustomClaimCheck());
            this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
            this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
            this.withHttpRetries(instance.getHttpRetries());
            this.withHttpRetryPauseMs(instance.getHttpRetryPauseMs());
            this.withClientScope(instance.getClientScope());
            this.withClientAudience(instance.getClientAudience());
            this.withEnableMetrics(instance.isEnableMetrics());
            this.withFailFast(instance.getFailFast());
            this.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public A withClientId(String clientId) {
        this.clientId = clientId;
        return (A)((Object)this);
    }

    public boolean hasClientId() {
        return this.clientId != null;
    }

    public GenericSecretSource buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    public A withClientSecret(GenericSecretSource clientSecret) {
        this._visitables.remove((Object)"clientSecret");
        if (clientSecret != null) {
            this.clientSecret = new GenericSecretSourceBuilder(clientSecret);
            this._visitables.get((Object)"clientSecret").add(this.clientSecret);
        } else {
            this.clientSecret = null;
            this._visitables.get((Object)"clientSecret").remove((Object)this.clientSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNested(null);
    }

    public ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item) {
        return new ClientSecretNested(item);
    }

    public ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(null));
    }

    public ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(new GenericSecretSourceBuilder().build()));
    }

    public ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item) {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(item));
    }

    public String getValidIssuerUri() {
        return this.validIssuerUri;
    }

    public A withValidIssuerUri(String validIssuerUri) {
        this.validIssuerUri = validIssuerUri;
        return (A)((Object)this);
    }

    public boolean hasValidIssuerUri() {
        return this.validIssuerUri != null;
    }

    public boolean isCheckIssuer() {
        return this.checkIssuer;
    }

    public A withCheckIssuer(boolean checkIssuer) {
        this.checkIssuer = checkIssuer;
        return (A)((Object)this);
    }

    public boolean hasCheckIssuer() {
        return true;
    }

    public boolean isCheckAudience() {
        return this.checkAudience;
    }

    public A withCheckAudience(boolean checkAudience) {
        this.checkAudience = checkAudience;
        return (A)((Object)this);
    }

    public boolean hasCheckAudience() {
        return true;
    }

    public String getJwksEndpointUri() {
        return this.jwksEndpointUri;
    }

    public A withJwksEndpointUri(String jwksEndpointUri) {
        this.jwksEndpointUri = jwksEndpointUri;
        return (A)((Object)this);
    }

    public boolean hasJwksEndpointUri() {
        return this.jwksEndpointUri != null;
    }

    public Integer getJwksRefreshSeconds() {
        return this.jwksRefreshSeconds;
    }

    public A withJwksRefreshSeconds(Integer jwksRefreshSeconds) {
        this.jwksRefreshSeconds = jwksRefreshSeconds;
        return (A)((Object)this);
    }

    public boolean hasJwksRefreshSeconds() {
        return this.jwksRefreshSeconds != null;
    }

    public Integer getJwksMinRefreshPauseSeconds() {
        return this.jwksMinRefreshPauseSeconds;
    }

    public A withJwksMinRefreshPauseSeconds(Integer jwksMinRefreshPauseSeconds) {
        this.jwksMinRefreshPauseSeconds = jwksMinRefreshPauseSeconds;
        return (A)((Object)this);
    }

    public boolean hasJwksMinRefreshPauseSeconds() {
        return this.jwksMinRefreshPauseSeconds != null;
    }

    public Integer getJwksExpirySeconds() {
        return this.jwksExpirySeconds;
    }

    public A withJwksExpirySeconds(Integer jwksExpirySeconds) {
        this.jwksExpirySeconds = jwksExpirySeconds;
        return (A)((Object)this);
    }

    public boolean hasJwksExpirySeconds() {
        return this.jwksExpirySeconds != null;
    }

    public boolean isJwksIgnoreKeyUse() {
        return this.jwksIgnoreKeyUse;
    }

    public A withJwksIgnoreKeyUse(boolean jwksIgnoreKeyUse) {
        this.jwksIgnoreKeyUse = jwksIgnoreKeyUse;
        return (A)((Object)this);
    }

    public boolean hasJwksIgnoreKeyUse() {
        return true;
    }

    public String getIntrospectionEndpointUri() {
        return this.introspectionEndpointUri;
    }

    public A withIntrospectionEndpointUri(String introspectionEndpointUri) {
        this.introspectionEndpointUri = introspectionEndpointUri;
        return (A)((Object)this);
    }

    public boolean hasIntrospectionEndpointUri() {
        return this.introspectionEndpointUri != null;
    }

    public String getServerBearerTokenLocation() {
        return this.serverBearerTokenLocation;
    }

    public A withServerBearerTokenLocation(String serverBearerTokenLocation) {
        this.serverBearerTokenLocation = serverBearerTokenLocation;
        return (A)((Object)this);
    }

    public boolean hasServerBearerTokenLocation() {
        return this.serverBearerTokenLocation != null;
    }

    public String getUserNameClaim() {
        return this.userNameClaim;
    }

    public A withUserNameClaim(String userNameClaim) {
        this.userNameClaim = userNameClaim;
        return (A)((Object)this);
    }

    public boolean hasUserNameClaim() {
        return this.userNameClaim != null;
    }

    public String getUserNamePrefix() {
        return this.userNamePrefix;
    }

    public A withUserNamePrefix(String userNamePrefix) {
        this.userNamePrefix = userNamePrefix;
        return (A)((Object)this);
    }

    public boolean hasUserNamePrefix() {
        return this.userNamePrefix != null;
    }

    public String getFallbackUserNameClaim() {
        return this.fallbackUserNameClaim;
    }

    public A withFallbackUserNameClaim(String fallbackUserNameClaim) {
        this.fallbackUserNameClaim = fallbackUserNameClaim;
        return (A)((Object)this);
    }

    public boolean hasFallbackUserNameClaim() {
        return this.fallbackUserNameClaim != null;
    }

    public String getFallbackUserNamePrefix() {
        return this.fallbackUserNamePrefix;
    }

    public A withFallbackUserNamePrefix(String fallbackUserNamePrefix) {
        this.fallbackUserNamePrefix = fallbackUserNamePrefix;
        return (A)((Object)this);
    }

    public boolean hasFallbackUserNamePrefix() {
        return this.fallbackUserNamePrefix != null;
    }

    public String getGroupsClaim() {
        return this.groupsClaim;
    }

    public A withGroupsClaim(String groupsClaim) {
        this.groupsClaim = groupsClaim;
        return (A)((Object)this);
    }

    public boolean hasGroupsClaim() {
        return this.groupsClaim != null;
    }

    public String getGroupsClaimDelimiter() {
        return this.groupsClaimDelimiter;
    }

    public A withGroupsClaimDelimiter(String groupsClaimDelimiter) {
        this.groupsClaimDelimiter = groupsClaimDelimiter;
        return (A)((Object)this);
    }

    public boolean hasGroupsClaimDelimiter() {
        return this.groupsClaimDelimiter != null;
    }

    public String getUserInfoEndpointUri() {
        return this.userInfoEndpointUri;
    }

    public A withUserInfoEndpointUri(String userInfoEndpointUri) {
        this.userInfoEndpointUri = userInfoEndpointUri;
        return (A)((Object)this);
    }

    public boolean hasUserInfoEndpointUri() {
        return this.userInfoEndpointUri != null;
    }

    public boolean isCheckAccessTokenType() {
        return this.checkAccessTokenType;
    }

    public A withCheckAccessTokenType(boolean checkAccessTokenType) {
        this.checkAccessTokenType = checkAccessTokenType;
        return (A)((Object)this);
    }

    public boolean hasCheckAccessTokenType() {
        return true;
    }

    public String getValidTokenType() {
        return this.validTokenType;
    }

    public A withValidTokenType(String validTokenType) {
        this.validTokenType = validTokenType;
        return (A)((Object)this);
    }

    public boolean hasValidTokenType() {
        return this.validTokenType != null;
    }

    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public A withAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt = accessTokenIsJwt;
        return (A)((Object)this);
    }

    public boolean hasAccessTokenIsJwt() {
        return true;
    }

    public A addToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").add(index, builder);
            this.tlsTrustedCertificates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").set(index, builder);
            this.tlsTrustedCertificates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove((Object)builder);
            this.tlsTrustedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove((Object)builder);
            this.tlsTrustedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        Iterator<CertSecretSourceBuilder> each = this.tlsTrustedCertificates.iterator();
        List visitables = this._visitables.get((Object)"tlsTrustedCertificates");
        while (each.hasNext()) {
            CertSecretSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CertSecretSource> buildTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null ? KafkaListenerAuthenticationOAuthFluent.build(this.tlsTrustedCertificates) : null;
    }

    public CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    public CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    public CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(this.tlsTrustedCertificates.size() - 1).build();
    }

    public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this._visitables.get((Object)"tlsTrustedCertificates").clear();
        }
        if (tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates = new ArrayList();
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        } else {
            this.tlsTrustedCertificates = null;
        }
        return (A)((Object)this);
    }

    public A withTlsTrustedCertificates(CertSecretSource ... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates.clear();
            this._visitables.remove((Object)"tlsTrustedCertificates");
        }
        if (tlsTrustedCertificates != null) {
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty();
    }

    public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new TlsTrustedCertificatesNested(-1, null);
    }

    public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
        return new TlsTrustedCertificatesNested(-1, item);
    }

    public TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index, CertSecretSource item) {
        return new TlsTrustedCertificatesNested(index, item);
    }

    public TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (this.tlsTrustedCertificates.size() <= index) {
            throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (this.tlsTrustedCertificates.size() == 0) {
            throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(0, this.buildTlsTrustedCertificate(0));
    }

    public TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = this.tlsTrustedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tlsTrustedCertificates.size(); ++i) {
            if (!predicate.test(this.tlsTrustedCertificates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
        return (A)((Object)this);
    }

    public boolean hasDisableTlsHostnameVerification() {
        return true;
    }

    public Boolean getEnableECDSA() {
        return this.enableECDSA;
    }

    public A withEnableECDSA(Boolean enableECDSA) {
        this.enableECDSA = enableECDSA;
        return (A)((Object)this);
    }

    public boolean hasEnableECDSA() {
        return this.enableECDSA != null;
    }

    public Integer getMaxSecondsWithoutReauthentication() {
        return this.maxSecondsWithoutReauthentication;
    }

    public A withMaxSecondsWithoutReauthentication(Integer maxSecondsWithoutReauthentication) {
        this.maxSecondsWithoutReauthentication = maxSecondsWithoutReauthentication;
        return (A)((Object)this);
    }

    public boolean hasMaxSecondsWithoutReauthentication() {
        return this.maxSecondsWithoutReauthentication != null;
    }

    public boolean isEnablePlain() {
        return this.enablePlain;
    }

    public A withEnablePlain(boolean enablePlain) {
        this.enablePlain = enablePlain;
        return (A)((Object)this);
    }

    public boolean hasEnablePlain() {
        return true;
    }

    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public A withTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri = tokenEndpointUri;
        return (A)((Object)this);
    }

    public boolean hasTokenEndpointUri() {
        return this.tokenEndpointUri != null;
    }

    public boolean isEnableOauthBearer() {
        return this.enableOauthBearer;
    }

    public A withEnableOauthBearer(boolean enableOauthBearer) {
        this.enableOauthBearer = enableOauthBearer;
        return (A)((Object)this);
    }

    public boolean hasEnableOauthBearer() {
        return true;
    }

    public String getCustomClaimCheck() {
        return this.customClaimCheck;
    }

    public A withCustomClaimCheck(String customClaimCheck) {
        this.customClaimCheck = customClaimCheck;
        return (A)((Object)this);
    }

    public boolean hasCustomClaimCheck() {
        return this.customClaimCheck != null;
    }

    public Integer getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public A withConnectTimeoutSeconds(Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds != null;
    }

    public Integer getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public A withReadTimeoutSeconds(Integer readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasReadTimeoutSeconds() {
        return this.readTimeoutSeconds != null;
    }

    public Integer getHttpRetries() {
        return this.httpRetries;
    }

    public A withHttpRetries(Integer httpRetries) {
        this.httpRetries = httpRetries;
        return (A)((Object)this);
    }

    public boolean hasHttpRetries() {
        return this.httpRetries != null;
    }

    public Integer getHttpRetryPauseMs() {
        return this.httpRetryPauseMs;
    }

    public A withHttpRetryPauseMs(Integer httpRetryPauseMs) {
        this.httpRetryPauseMs = httpRetryPauseMs;
        return (A)((Object)this);
    }

    public boolean hasHttpRetryPauseMs() {
        return this.httpRetryPauseMs != null;
    }

    public String getClientScope() {
        return this.clientScope;
    }

    public A withClientScope(String clientScope) {
        this.clientScope = clientScope;
        return (A)((Object)this);
    }

    public boolean hasClientScope() {
        return this.clientScope != null;
    }

    public String getClientAudience() {
        return this.clientAudience;
    }

    public A withClientAudience(String clientAudience) {
        this.clientAudience = clientAudience;
        return (A)((Object)this);
    }

    public boolean hasClientAudience() {
        return this.clientAudience != null;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public A withEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return (A)((Object)this);
    }

    public boolean hasEnableMetrics() {
        return true;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public A withFailFast(boolean failFast) {
        this.failFast = failFast;
        return (A)((Object)this);
    }

    public boolean hasFailFast() {
        return true;
    }

    public boolean isIncludeAcceptHeader() {
        return this.includeAcceptHeader;
    }

    public A withIncludeAcceptHeader(boolean includeAcceptHeader) {
        this.includeAcceptHeader = includeAcceptHeader;
        return (A)((Object)this);
    }

    public boolean hasIncludeAcceptHeader() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaListenerAuthenticationOAuthFluent that = (KafkaListenerAuthenticationOAuthFluent)((Object)o);
        if (!Objects.equals(this.clientId, that.clientId)) {
            return false;
        }
        if (!Objects.equals((Object)this.clientSecret, (Object)that.clientSecret)) {
            return false;
        }
        if (!Objects.equals(this.validIssuerUri, that.validIssuerUri)) {
            return false;
        }
        if (this.checkIssuer != that.checkIssuer) {
            return false;
        }
        if (this.checkAudience != that.checkAudience) {
            return false;
        }
        if (!Objects.equals(this.jwksEndpointUri, that.jwksEndpointUri)) {
            return false;
        }
        if (!Objects.equals(this.jwksRefreshSeconds, that.jwksRefreshSeconds)) {
            return false;
        }
        if (!Objects.equals(this.jwksMinRefreshPauseSeconds, that.jwksMinRefreshPauseSeconds)) {
            return false;
        }
        if (!Objects.equals(this.jwksExpirySeconds, that.jwksExpirySeconds)) {
            return false;
        }
        if (this.jwksIgnoreKeyUse != that.jwksIgnoreKeyUse) {
            return false;
        }
        if (!Objects.equals(this.introspectionEndpointUri, that.introspectionEndpointUri)) {
            return false;
        }
        if (!Objects.equals(this.serverBearerTokenLocation, that.serverBearerTokenLocation)) {
            return false;
        }
        if (!Objects.equals(this.userNameClaim, that.userNameClaim)) {
            return false;
        }
        if (!Objects.equals(this.userNamePrefix, that.userNamePrefix)) {
            return false;
        }
        if (!Objects.equals(this.fallbackUserNameClaim, that.fallbackUserNameClaim)) {
            return false;
        }
        if (!Objects.equals(this.fallbackUserNamePrefix, that.fallbackUserNamePrefix)) {
            return false;
        }
        if (!Objects.equals(this.groupsClaim, that.groupsClaim)) {
            return false;
        }
        if (!Objects.equals(this.groupsClaimDelimiter, that.groupsClaimDelimiter)) {
            return false;
        }
        if (!Objects.equals(this.userInfoEndpointUri, that.userInfoEndpointUri)) {
            return false;
        }
        if (this.checkAccessTokenType != that.checkAccessTokenType) {
            return false;
        }
        if (!Objects.equals(this.validTokenType, that.validTokenType)) {
            return false;
        }
        if (this.accessTokenIsJwt != that.accessTokenIsJwt) {
            return false;
        }
        if (!Objects.equals(this.tlsTrustedCertificates, that.tlsTrustedCertificates)) {
            return false;
        }
        if (this.disableTlsHostnameVerification != that.disableTlsHostnameVerification) {
            return false;
        }
        if (!Objects.equals(this.enableECDSA, that.enableECDSA)) {
            return false;
        }
        if (!Objects.equals(this.maxSecondsWithoutReauthentication, that.maxSecondsWithoutReauthentication)) {
            return false;
        }
        if (this.enablePlain != that.enablePlain) {
            return false;
        }
        if (!Objects.equals(this.tokenEndpointUri, that.tokenEndpointUri)) {
            return false;
        }
        if (this.enableOauthBearer != that.enableOauthBearer) {
            return false;
        }
        if (!Objects.equals(this.customClaimCheck, that.customClaimCheck)) {
            return false;
        }
        if (!Objects.equals(this.connectTimeoutSeconds, that.connectTimeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.readTimeoutSeconds, that.readTimeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.httpRetries, that.httpRetries)) {
            return false;
        }
        if (!Objects.equals(this.httpRetryPauseMs, that.httpRetryPauseMs)) {
            return false;
        }
        if (!Objects.equals(this.clientScope, that.clientScope)) {
            return false;
        }
        if (!Objects.equals(this.clientAudience, that.clientAudience)) {
            return false;
        }
        if (this.enableMetrics != that.enableMetrics) {
            return false;
        }
        if (this.failFast != that.failFast) {
            return false;
        }
        return this.includeAcceptHeader == that.includeAcceptHeader;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.clientSecret, this.validIssuerUri, this.checkIssuer, this.checkAudience, this.jwksEndpointUri, this.jwksRefreshSeconds, this.jwksMinRefreshPauseSeconds, this.jwksExpirySeconds, this.jwksIgnoreKeyUse, this.introspectionEndpointUri, this.serverBearerTokenLocation, this.userNameClaim, this.userNamePrefix, this.fallbackUserNameClaim, this.fallbackUserNamePrefix, this.groupsClaim, this.groupsClaimDelimiter, this.userInfoEndpointUri, this.checkAccessTokenType, this.validTokenType, this.accessTokenIsJwt, this.tlsTrustedCertificates, this.disableTlsHostnameVerification, this.enableECDSA, this.maxSecondsWithoutReauthentication, this.enablePlain, this.tokenEndpointUri, this.enableOauthBearer, this.customClaimCheck, this.connectTimeoutSeconds, this.readTimeoutSeconds, this.httpRetries, this.httpRetryPauseMs, this.clientScope, this.clientAudience, this.enableMetrics, this.failFast, this.includeAcceptHeader, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientId != null) {
            sb.append("clientId:");
            sb.append(this.clientId + ",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append(String.valueOf((Object)this.clientSecret) + ",");
        }
        if (this.validIssuerUri != null) {
            sb.append("validIssuerUri:");
            sb.append(this.validIssuerUri + ",");
        }
        sb.append("checkIssuer:");
        sb.append(this.checkIssuer + ",");
        sb.append("checkAudience:");
        sb.append(this.checkAudience + ",");
        if (this.jwksEndpointUri != null) {
            sb.append("jwksEndpointUri:");
            sb.append(this.jwksEndpointUri + ",");
        }
        if (this.jwksRefreshSeconds != null) {
            sb.append("jwksRefreshSeconds:");
            sb.append(this.jwksRefreshSeconds + ",");
        }
        if (this.jwksMinRefreshPauseSeconds != null) {
            sb.append("jwksMinRefreshPauseSeconds:");
            sb.append(this.jwksMinRefreshPauseSeconds + ",");
        }
        if (this.jwksExpirySeconds != null) {
            sb.append("jwksExpirySeconds:");
            sb.append(this.jwksExpirySeconds + ",");
        }
        sb.append("jwksIgnoreKeyUse:");
        sb.append(this.jwksIgnoreKeyUse + ",");
        if (this.introspectionEndpointUri != null) {
            sb.append("introspectionEndpointUri:");
            sb.append(this.introspectionEndpointUri + ",");
        }
        if (this.serverBearerTokenLocation != null) {
            sb.append("serverBearerTokenLocation:");
            sb.append(this.serverBearerTokenLocation + ",");
        }
        if (this.userNameClaim != null) {
            sb.append("userNameClaim:");
            sb.append(this.userNameClaim + ",");
        }
        if (this.userNamePrefix != null) {
            sb.append("userNamePrefix:");
            sb.append(this.userNamePrefix + ",");
        }
        if (this.fallbackUserNameClaim != null) {
            sb.append("fallbackUserNameClaim:");
            sb.append(this.fallbackUserNameClaim + ",");
        }
        if (this.fallbackUserNamePrefix != null) {
            sb.append("fallbackUserNamePrefix:");
            sb.append(this.fallbackUserNamePrefix + ",");
        }
        if (this.groupsClaim != null) {
            sb.append("groupsClaim:");
            sb.append(this.groupsClaim + ",");
        }
        if (this.groupsClaimDelimiter != null) {
            sb.append("groupsClaimDelimiter:");
            sb.append(this.groupsClaimDelimiter + ",");
        }
        if (this.userInfoEndpointUri != null) {
            sb.append("userInfoEndpointUri:");
            sb.append(this.userInfoEndpointUri + ",");
        }
        sb.append("checkAccessTokenType:");
        sb.append(this.checkAccessTokenType + ",");
        if (this.validTokenType != null) {
            sb.append("validTokenType:");
            sb.append(this.validTokenType + ",");
        }
        sb.append("accessTokenIsJwt:");
        sb.append(this.accessTokenIsJwt + ",");
        if (this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty()) {
            sb.append("tlsTrustedCertificates:");
            sb.append(String.valueOf(this.tlsTrustedCertificates) + ",");
        }
        sb.append("disableTlsHostnameVerification:");
        sb.append(this.disableTlsHostnameVerification + ",");
        if (this.enableECDSA != null) {
            sb.append("enableECDSA:");
            sb.append(this.enableECDSA + ",");
        }
        if (this.maxSecondsWithoutReauthentication != null) {
            sb.append("maxSecondsWithoutReauthentication:");
            sb.append(this.maxSecondsWithoutReauthentication + ",");
        }
        sb.append("enablePlain:");
        sb.append(this.enablePlain + ",");
        if (this.tokenEndpointUri != null) {
            sb.append("tokenEndpointUri:");
            sb.append(this.tokenEndpointUri + ",");
        }
        sb.append("enableOauthBearer:");
        sb.append(this.enableOauthBearer + ",");
        if (this.customClaimCheck != null) {
            sb.append("customClaimCheck:");
            sb.append(this.customClaimCheck + ",");
        }
        if (this.connectTimeoutSeconds != null) {
            sb.append("connectTimeoutSeconds:");
            sb.append(this.connectTimeoutSeconds + ",");
        }
        if (this.readTimeoutSeconds != null) {
            sb.append("readTimeoutSeconds:");
            sb.append(this.readTimeoutSeconds + ",");
        }
        if (this.httpRetries != null) {
            sb.append("httpRetries:");
            sb.append(this.httpRetries + ",");
        }
        if (this.httpRetryPauseMs != null) {
            sb.append("httpRetryPauseMs:");
            sb.append(this.httpRetryPauseMs + ",");
        }
        if (this.clientScope != null) {
            sb.append("clientScope:");
            sb.append(this.clientScope + ",");
        }
        if (this.clientAudience != null) {
            sb.append("clientAudience:");
            sb.append(this.clientAudience + ",");
        }
        sb.append("enableMetrics:");
        sb.append(this.enableMetrics + ",");
        sb.append("failFast:");
        sb.append(this.failFast + ",");
        sb.append("includeAcceptHeader:");
        sb.append(this.includeAcceptHeader);
        sb.append("}");
        return sb.toString();
    }

    public A withCheckIssuer() {
        return this.withCheckIssuer(true);
    }

    public A withCheckAudience() {
        return this.withCheckAudience(true);
    }

    public A withJwksIgnoreKeyUse() {
        return this.withJwksIgnoreKeyUse(true);
    }

    public A withCheckAccessTokenType() {
        return this.withCheckAccessTokenType(true);
    }

    public A withAccessTokenIsJwt() {
        return this.withAccessTokenIsJwt(true);
    }

    public A withDisableTlsHostnameVerification() {
        return this.withDisableTlsHostnameVerification(true);
    }

    public A withEnableECDSA() {
        return this.withEnableECDSA(true);
    }

    public A withEnablePlain() {
        return this.withEnablePlain(true);
    }

    public A withEnableOauthBearer() {
        return this.withEnableOauthBearer(true);
    }

    public A withEnableMetrics() {
        return this.withEnableMetrics(true);
    }

    public A withFailFast() {
        return this.withFailFast(true);
    }

    public A withIncludeAcceptHeader() {
        return this.withIncludeAcceptHeader(true);
    }

    public class ClientSecretNested<N>
    extends GenericSecretSourceFluent<ClientSecretNested<N>>
    implements Nested<N> {
        GenericSecretSourceBuilder builder;

        ClientSecretNested(GenericSecretSource item) {
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaListenerAuthenticationOAuthFluent.this.withClientSecret(this.builder.build());
        }

        public N endClientSecret() {
            return this.and();
        }
    }

    public class TlsTrustedCertificatesNested<N>
    extends CertSecretSourceFluent<TlsTrustedCertificatesNested<N>>
    implements Nested<N> {
        CertSecretSourceBuilder builder;
        int index;

        TlsTrustedCertificatesNested(int index, CertSecretSource item) {
            this.index = index;
            this.builder = new CertSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaListenerAuthenticationOAuthFluent.this.setToTlsTrustedCertificates(this.index, this.builder.build());
        }

        public N endTlsTrustedCertificate() {
            return this.and();
        }
    }
}

