/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.nodepool;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolSpec;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolStatus;
import io.strimzi.crdgenerator.annotations.Crd;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize
@Crd(spec=@Crd.Spec(names=@Crd.Spec.Names(kind="KafkaNodePool", plural="kafkanodepools", shortNames={"knp"}, categories={"strimzi"}), group="kafka.strimzi.io", scope="Namespaced", versions={@Crd.Spec.Version(name="v1beta2", served=true, storage=true)}, subresources=@Crd.Spec.Subresources(status={@Crd.Spec.Subresources.Status}, scale={@Crd.Spec.Subresources.Scale(specReplicasPath=".spec.replicas", statusReplicasPath=".status.replicas", labelSelectorPath=".status.labelSelector")}), additionalPrinterColumns={@Crd.Spec.AdditionalPrinterColumn(name="Desired replicas", description="The desired number of replicas", jsonPath=".spec.replicas", type="integer"), @Crd.Spec.AdditionalPrinterColumn(name="Roles", description="Roles of the nodes in the pool", jsonPath=".status.roles", type="string"), @Crd.Spec.AdditionalPrinterColumn(name="NodeIds", description="Node IDs used by Kafka nodes in this pool", jsonPath=".status.nodeIds", type="string")}))
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
@Version(value="v1beta2")
@Group(value="kafka.strimzi.io")
public class KafkaNodePool
extends CustomResource<KafkaNodePoolSpec, KafkaNodePoolStatus>
implements Namespaced,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    public static final String SCOPE = "Namespaced";
    public static final String V1BETA2 = "v1beta2";
    public static final List<String> VERSIONS = List.of("v1beta2");
    public static final String RESOURCE_KIND = "KafkaNodePool";
    public static final String RESOURCE_LIST_KIND = "KafkaNodePoolList";
    public static final String RESOURCE_GROUP = "kafka.strimzi.io";
    public static final String RESOURCE_PLURAL = "kafkanodepools";
    public static final String RESOURCE_SINGULAR = "kafkanodepool";
    public static final String CRD_NAME = "kafkanodepools.kafka.strimzi.io";
    public static final String SHORT_NAME = "knp";
    public static final String SPEC_REPLICAS_PATH = ".spec.replicas";
    public static final String STATUS_REPLICAS_PATH = ".status.replicas";
    public static final String LABEL_SELECTOR_PATH = ".status.labelSelector";
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private String kind;

    public KafkaNodePool() {
    }

    public KafkaNodePool(KafkaNodePoolSpec spec, KafkaNodePoolStatus status) {
        this.spec = spec;
        this.status = status;
    }

    @Description(value="The specification of the KafkaNodePool.")
    public KafkaNodePoolSpec getSpec() {
        return (KafkaNodePoolSpec)super.getSpec();
    }

    @Description(value="The status of the KafkaNodePool.")
    public KafkaNodePoolStatus getStatus() {
        return (KafkaNodePoolStatus)super.getStatus();
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaNodePool)) {
            return false;
        }
        KafkaNodePool other = (KafkaNodePool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        if (this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties)) {
            return false;
        }
        String this$apiVersion = this.apiVersion;
        String other$apiVersion = other.apiVersion;
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.kind;
        String other$kind = other.kind;
        return !(this$kind == null ? other$kind != null : !this$kind.equals(other$kind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaNodePool;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        String $apiVersion = this.apiVersion;
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.kind;
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaNodePool(super=" + super.toString() + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ", apiVersion=" + this.apiVersion + ", kind=" + this.kind + ")";
    }
}

