/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.podset;

import io.fabric8.kubernetes.api.model.LabelSelector;
import io.strimzi.api.kafka.model.common.SpecFluent;
import io.strimzi.api.kafka.model.podset.StrimziPodSetSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StrimziPodSetSpecFluent<A extends StrimziPodSetSpecFluent<A>>
extends SpecFluent<A> {
    private LabelSelector selector;
    private List<Map<String, Object>> pods;

    public StrimziPodSetSpecFluent() {
    }

    public StrimziPodSetSpecFluent(StrimziPodSetSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StrimziPodSetSpec instance) {
        StrimziPodSetSpec strimziPodSetSpec = instance = instance != null ? instance : new StrimziPodSetSpec();
        if (instance != null) {
            this.withSelector(instance.getSelector());
            this.withPods(instance.getPods());
        }
    }

    public LabelSelector getSelector() {
        return this.selector;
    }

    public A withSelector(LabelSelector selector) {
        this.selector = selector;
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public A addToPods(int index, Map<String, Object> item) {
        if (this.pods == null) {
            this.pods = new ArrayList<Map<String, Object>>();
        }
        this.pods.add(index, item);
        return (A)((Object)this);
    }

    public A setToPods(int index, Map<String, Object> item) {
        if (this.pods == null) {
            this.pods = new ArrayList<Map<String, Object>>();
        }
        this.pods.set(index, item);
        return (A)((Object)this);
    }

    public A addToPods(Map<String, Object> ... items) {
        if (this.pods == null) {
            this.pods = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> item : items) {
            this.pods.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPods(Collection<Map<String, Object>> items) {
        if (this.pods == null) {
            this.pods = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> item : items) {
            this.pods.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPods(Map<String, Object> ... items) {
        if (this.pods == null) {
            return (A)((Object)this);
        }
        for (Map<String, Object> item : items) {
            this.pods.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPods(Collection<Map<String, Object>> items) {
        if (this.pods == null) {
            return (A)((Object)this);
        }
        for (Map<String, Object> item : items) {
            this.pods.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Map<String, Object>> getPods() {
        return this.pods;
    }

    public Map<String, Object> getPod(int index) {
        return this.pods.get(index);
    }

    public Map<String, Object> getFirstPod() {
        return this.pods.get(0);
    }

    public Map<String, Object> getLastPod() {
        return this.pods.get(this.pods.size() - 1);
    }

    public Map<String, Object> getMatchingPod(Predicate<Map<String, Object>> predicate) {
        for (Map<String, Object> item : this.pods) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPod(Predicate<Map<String, Object>> predicate) {
        for (Map<String, Object> item : this.pods) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public <K, V> A withPods(List<Map<String, Object>> pods) {
        if (pods != null) {
            this.pods = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> item : pods) {
                this.addToPods(item);
            }
        } else {
            this.pods = null;
        }
        return (A)((Object)this);
    }

    public A withPods(Map<String, Object> ... pods) {
        if (this.pods != null) {
            this.pods.clear();
            this._visitables.remove((Object)"pods");
        }
        if (pods != null) {
            for (Map<String, Object> item : pods) {
                this.addToPods(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPods() {
        return this.pods != null && !this.pods.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StrimziPodSetSpecFluent that = (StrimziPodSetSpecFluent)((Object)o);
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        return Objects.equals(this.pods, that.pods);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.selector, this.pods, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(String.valueOf(this.selector) + ",");
        }
        if (this.pods != null && !this.pods.isEmpty()) {
            sb.append("pods:");
            sb.append(this.pods);
        }
        sb.append("}");
        return sb.toString();
    }
}

