/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.zookeeper;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.common.ExternalLogging;
import io.strimzi.api.kafka.model.common.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.common.InlineLogging;
import io.strimzi.api.kafka.model.common.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.common.InlineLoggingFluent;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.common.JvmOptionsFluent;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptions;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptionsBuilder;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptionsFluent;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetrics;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsFluent;
import io.strimzi.api.kafka.model.common.metrics.MetricsConfig;
import io.strimzi.api.kafka.model.kafka.EphemeralStorage;
import io.strimzi.api.kafka.model.kafka.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.kafka.EphemeralStorageFluent;
import io.strimzi.api.kafka.model.kafka.PersistentClaimStorage;
import io.strimzi.api.kafka.model.kafka.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.kafka.PersistentClaimStorageFluent;
import io.strimzi.api.kafka.model.kafka.SingleVolumeStorage;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterSpec;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterTemplate;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterTemplateBuilder;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterTemplateFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ZookeeperClusterSpecFluent<A extends ZookeeperClusterSpecFluent<A>>
extends BaseFluent<A> {
    private VisitableBuilder<? extends SingleVolumeStorage, ?> storage;
    private Map<String, Object> config;
    private VisitableBuilder<? extends Logging, ?> logging;
    private int replicas;
    private String image;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private KafkaJmxOptionsBuilder jmxOptions;
    private VisitableBuilder<? extends MetricsConfig, ?> metricsConfig;
    private ZookeeperClusterTemplateBuilder template;

    public ZookeeperClusterSpecFluent() {
    }

    public ZookeeperClusterSpecFluent(ZookeeperClusterSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ZookeeperClusterSpec instance) {
        ZookeeperClusterSpec zookeeperClusterSpec = instance = instance != null ? instance : new ZookeeperClusterSpec();
        if (instance != null) {
            this.withStorage(instance.getStorage());
            this.withConfig(instance.getConfig());
            this.withLogging(instance.getLogging());
            this.withReplicas(instance.getReplicas());
            this.withImage(instance.getImage());
            this.withResources(instance.getResources());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withJvmOptions(instance.getJvmOptions());
            this.withJmxOptions(instance.getJmxOptions());
            this.withMetricsConfig(instance.getMetricsConfig());
            this.withTemplate(instance.getTemplate());
        }
    }

    public SingleVolumeStorage buildStorage() {
        return this.storage != null ? (SingleVolumeStorage)this.storage.build() : null;
    }

    public A withStorage(SingleVolumeStorage storage) {
        if (storage == null) {
            this.storage = null;
            this._visitables.remove((Object)"storage");
            return (A)((Object)this);
        }
        VisitableBuilder builder = ZookeeperClusterSpecFluent.builder(storage);
        this._visitables.get((Object)"storage").clear();
        this._visitables.get((Object)"storage").add(builder);
        this.storage = builder;
        return (A)((Object)this);
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public EphemeralStorageNested<A> withNewEphemeralStorage() {
        return new EphemeralStorageNested(null);
    }

    public EphemeralStorageNested<A> withNewEphemeralStorageLike(EphemeralStorage item) {
        return new EphemeralStorageNested(item);
    }

    public PersistentClaimStorageNested<A> withNewPersistentClaimStorage() {
        return new PersistentClaimStorageNested(null);
    }

    public PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(PersistentClaimStorage item) {
        return new PersistentClaimStorageNested(item);
    }

    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    public A withLogging(Logging logging) {
        if (logging == null) {
            this.logging = null;
            this._visitables.remove((Object)"logging");
            return (A)((Object)this);
        }
        VisitableBuilder builder = ZookeeperClusterSpecFluent.builder(logging);
        this._visitables.get((Object)"logging").clear();
        this._visitables.get((Object)"logging").add(builder);
        this.logging = builder;
        return (A)((Object)this);
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNested(null);
    }

    public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNested(item);
    }

    public ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNested(null);
    }

    public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNested(item);
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return true;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove((Object)"livenessProbe");
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove((Object)"readinessProbe");
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.remove((Object)"jvmOptions");
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        } else {
            this.jvmOptions = null;
            this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNested(null);
    }

    public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNested(item);
    }

    public JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(null));
    }

    public JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
    }

    public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(item));
    }

    public KafkaJmxOptions buildJmxOptions() {
        return this.jmxOptions != null ? this.jmxOptions.build() : null;
    }

    public A withJmxOptions(KafkaJmxOptions jmxOptions) {
        this._visitables.remove((Object)"jmxOptions");
        if (jmxOptions != null) {
            this.jmxOptions = new KafkaJmxOptionsBuilder(jmxOptions);
            this._visitables.get((Object)"jmxOptions").add(this.jmxOptions);
        } else {
            this.jmxOptions = null;
            this._visitables.get((Object)"jmxOptions").remove((Object)this.jmxOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJmxOptions() {
        return this.jmxOptions != null;
    }

    public JmxOptionsNested<A> withNewJmxOptions() {
        return new JmxOptionsNested(null);
    }

    public JmxOptionsNested<A> withNewJmxOptionsLike(KafkaJmxOptions item) {
        return new JmxOptionsNested(item);
    }

    public JmxOptionsNested<A> editJmxOptions() {
        return this.withNewJmxOptionsLike(Optional.ofNullable(this.buildJmxOptions()).orElse(null));
    }

    public JmxOptionsNested<A> editOrNewJmxOptions() {
        return this.withNewJmxOptionsLike(Optional.ofNullable(this.buildJmxOptions()).orElse(new KafkaJmxOptionsBuilder().build()));
    }

    public JmxOptionsNested<A> editOrNewJmxOptionsLike(KafkaJmxOptions item) {
        return this.withNewJmxOptionsLike(Optional.ofNullable(this.buildJmxOptions()).orElse(item));
    }

    public MetricsConfig buildMetricsConfig() {
        return this.metricsConfig != null ? (MetricsConfig)this.metricsConfig.build() : null;
    }

    public A withMetricsConfig(MetricsConfig metricsConfig) {
        if (metricsConfig == null) {
            this.metricsConfig = null;
            this._visitables.remove((Object)"metricsConfig");
            return (A)((Object)this);
        }
        VisitableBuilder builder = ZookeeperClusterSpecFluent.builder(metricsConfig);
        this._visitables.get((Object)"metricsConfig").clear();
        this._visitables.get((Object)"metricsConfig").add(builder);
        this.metricsConfig = builder;
        return (A)((Object)this);
    }

    public boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new JmxPrometheusExporterMetricsConfigNested(null);
    }

    public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
        return new JmxPrometheusExporterMetricsConfigNested(item);
    }

    public ZookeeperClusterTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(ZookeeperClusterTemplate template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new ZookeeperClusterTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(ZookeeperClusterTemplate item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new ZookeeperClusterTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(ZookeeperClusterTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ZookeeperClusterSpecFluent that = (ZookeeperClusterSpecFluent)((Object)o);
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.jvmOptions, (Object)that.jvmOptions)) {
            return false;
        }
        if (!Objects.equals((Object)this.jmxOptions, (Object)that.jmxOptions)) {
            return false;
        }
        if (!Objects.equals(this.metricsConfig, that.metricsConfig)) {
            return false;
        }
        return Objects.equals((Object)this.template, (Object)that.template);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.storage, this.config, this.logging, this.replicas, this.image, this.resources, this.livenessProbe, this.readinessProbe, this.jvmOptions, this.jmxOptions, this.metricsConfig, this.template, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(String.valueOf(this.storage) + ",");
        }
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(String.valueOf(this.config) + ",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(String.valueOf(this.logging) + ",");
        }
        sb.append("replicas:");
        sb.append(this.replicas + ",");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(String.valueOf(this.resources) + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(String.valueOf((Object)this.livenessProbe) + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(String.valueOf((Object)this.readinessProbe) + ",");
        }
        if (this.jvmOptions != null) {
            sb.append("jvmOptions:");
            sb.append(String.valueOf((Object)this.jvmOptions) + ",");
        }
        if (this.jmxOptions != null) {
            sb.append("jmxOptions:");
            sb.append(String.valueOf((Object)this.jmxOptions) + ",");
        }
        if (this.metricsConfig != null) {
            sb.append("metricsConfig:");
            sb.append(String.valueOf(this.metricsConfig) + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append((Object)this.template);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.kafka.EphemeralStorage": {
                return new EphemeralStorageBuilder((EphemeralStorage)item);
            }
            case "io.strimzi.api.kafka.model.kafka.PersistentClaimStorage": {
                return new PersistentClaimStorageBuilder((PersistentClaimStorage)item);
            }
            case "io.strimzi.api.kafka.model.common.InlineLogging": {
                return new InlineLoggingBuilder((InlineLogging)item);
            }
            case "io.strimzi.api.kafka.model.common.ExternalLogging": {
                return new ExternalLoggingBuilder((ExternalLogging)item);
            }
            case "io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetrics": {
                return new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics)item);
            }
        }
        return ZookeeperClusterSpecFluent.builderOf((Object)item);
    }

    public class EphemeralStorageNested<N>
    extends EphemeralStorageFluent<EphemeralStorageNested<N>>
    implements Nested<N> {
        EphemeralStorageBuilder builder;

        EphemeralStorageNested(EphemeralStorage item) {
            this.builder = new EphemeralStorageBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterSpecFluent.this.withStorage(this.builder.build());
        }

        public N endEphemeralStorage() {
            return this.and();
        }
    }

    public class PersistentClaimStorageNested<N>
    extends PersistentClaimStorageFluent<PersistentClaimStorageNested<N>>
    implements Nested<N> {
        PersistentClaimStorageBuilder builder;

        PersistentClaimStorageNested(PersistentClaimStorage item) {
            this.builder = new PersistentClaimStorageBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterSpecFluent.this.withStorage(this.builder.build());
        }

        public N endPersistentClaimStorage() {
            return this.and();
        }
    }

    public class InlineLoggingNested<N>
    extends InlineLoggingFluent<InlineLoggingNested<N>>
    implements Nested<N> {
        InlineLoggingBuilder builder;

        InlineLoggingNested(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterSpecFluent.this.withLogging(this.builder.build());
        }

        public N endInlineLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingNested<N>
    extends ExternalLoggingFluent<ExternalLoggingNested<N>>
    implements Nested<N> {
        ExternalLoggingBuilder builder;

        ExternalLoggingNested(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterSpecFluent.this.withLogging(this.builder.build());
        }

        public N endExternalLogging() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterSpecFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterSpecFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class JvmOptionsNested<N>
    extends JvmOptionsFluent<JvmOptionsNested<N>>
    implements Nested<N> {
        JvmOptionsBuilder builder;

        JvmOptionsNested(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterSpecFluent.this.withJvmOptions(this.builder.build());
        }

        public N endJvmOptions() {
            return this.and();
        }
    }

    public class JmxOptionsNested<N>
    extends KafkaJmxOptionsFluent<JmxOptionsNested<N>>
    implements Nested<N> {
        KafkaJmxOptionsBuilder builder;

        JmxOptionsNested(KafkaJmxOptions item) {
            this.builder = new KafkaJmxOptionsBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterSpecFluent.this.withJmxOptions(this.builder.build());
        }

        public N endJmxOptions() {
            return this.and();
        }
    }

    public class JmxPrometheusExporterMetricsConfigNested<N>
    extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsConfigNested<N>>
    implements Nested<N> {
        JmxPrometheusExporterMetricsBuilder builder;

        JmxPrometheusExporterMetricsConfigNested(JmxPrometheusExporterMetrics item) {
            this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterSpecFluent.this.withMetricsConfig(this.builder.build());
        }

        public N endJmxPrometheusExporterMetricsConfig() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends ZookeeperClusterTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        ZookeeperClusterTemplateBuilder builder;

        TemplateNested(ZookeeperClusterTemplate item) {
            this.builder = new ZookeeperClusterTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

