/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.strimzi.api.kafka.model.EntityTopicOperatorSpec;
import io.strimzi.api.kafka.model.EntityUserOperatorSpec;
import io.strimzi.api.kafka.model.Sidecar;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"topicOperator", "userOperator", "affinity", "tolerations", "tlsSidecar"})
public class EntityOperatorSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_TLS_SIDECAR_IMAGE = System.getenv().getOrDefault("STRIMZI_DEFAULT_TLS_SIDECAR_ENTITY_OPERATOR_IMAGE", "strimzi/entity-operator-stunnel:latest");
    public static final int DEFAULT_REPLICAS = 1;
    public static final int DEFAULT_ZOOKEEPER_PORT = 2181;
    private EntityTopicOperatorSpec topicOperator;
    private EntityUserOperatorSpec userOperator;
    private Affinity affinity;
    private List<Toleration> tolerations;
    private Sidecar tlsSidecar;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Configuration of the Topic Operator")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public EntityTopicOperatorSpec getTopicOperator() {
        return this.topicOperator;
    }

    public void setTopicOperator(EntityTopicOperatorSpec topicOperator) {
        this.topicOperator = topicOperator;
    }

    @Description(value="Configuration of the User Operator")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public EntityUserOperatorSpec getUserOperator() {
        return this.userOperator;
    }

    public void setUserOperator(EntityUserOperatorSpec userOperator) {
        this.userOperator = userOperator;
    }

    @Description(value="Pod affinity rules.")
    @KubeLink(group="core", version="v1", kind="affinity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Affinity getAffinity() {
        return this.affinity;
    }

    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    @Description(value="Pod's tolerations.")
    @KubeLink(group="core", version="v1", kind="tolerations")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    @Description(value="TLS sidecar configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Sidecar getTlsSidecar() {
        return this.tlsSidecar;
    }

    public void setTlsSidecar(Sidecar tlsSidecar) {
        this.tlsSidecar = tlsSidecar;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

