/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.EntityOperatorSpec;
import io.strimzi.api.kafka.model.EntityOperatorSpecFluent;
import io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl;

public class EntityOperatorSpecBuilder
extends EntityOperatorSpecFluentImpl<EntityOperatorSpecBuilder>
implements VisitableBuilder<EntityOperatorSpec, EntityOperatorSpecBuilder> {
    EntityOperatorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public EntityOperatorSpecBuilder() {
        this(true);
    }

    public EntityOperatorSpecBuilder(Boolean validationEnabled) {
        this(new EntityOperatorSpec(), validationEnabled);
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EntityOperatorSpec(), validationEnabled);
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent, EntityOperatorSpec instance) {
        this(fluent, instance, true);
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent, EntityOperatorSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTopicOperator(instance.getTopicOperator());
        fluent.withUserOperator(instance.getUserOperator());
        fluent.withAffinity(instance.getAffinity());
        fluent.withTolerations(instance.getTolerations());
        fluent.withTlsSidecar(instance.getTlsSidecar());
        this.validationEnabled = validationEnabled;
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpec instance) {
        this(instance, (Boolean)true);
    }

    public EntityOperatorSpecBuilder(EntityOperatorSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTopicOperator(instance.getTopicOperator());
        this.withUserOperator(instance.getUserOperator());
        this.withAffinity(instance.getAffinity());
        this.withTolerations(instance.getTolerations());
        this.withTlsSidecar(instance.getTlsSidecar());
        this.validationEnabled = validationEnabled;
    }

    public EntityOperatorSpec build() {
        EntityOperatorSpec buildable = new EntityOperatorSpec();
        buildable.setTopicOperator(this.fluent.getTopicOperator());
        buildable.setUserOperator(this.fluent.getUserOperator());
        buildable.setAffinity(this.fluent.getAffinity());
        buildable.setTolerations(this.fluent.getTolerations());
        buildable.setTlsSidecar(this.fluent.getTlsSidecar());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityOperatorSpecBuilder that = (EntityOperatorSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

