/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaSpec;
import io.strimzi.api.kafka.model.KafkaSpecFluent;
import io.strimzi.api.kafka.model.KafkaSpecFluentImpl;

public class KafkaSpecBuilder
extends KafkaSpecFluentImpl<KafkaSpecBuilder>
implements VisitableBuilder<KafkaSpec, KafkaSpecBuilder> {
    KafkaSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaSpecBuilder() {
        this(true);
    }

    public KafkaSpecBuilder(Boolean validationEnabled) {
        this(new KafkaSpec(), validationEnabled);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaSpec(), validationEnabled);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent, KafkaSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent, KafkaSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withKafka(instance.getKafka());
        fluent.withZookeeper(instance.getZookeeper());
        fluent.withTopicOperator(instance.getTopicOperator());
        fluent.withEntityOperator(instance.getEntityOperator());
        this.validationEnabled = validationEnabled;
    }

    public KafkaSpecBuilder(KafkaSpec instance) {
        this(instance, (Boolean)true);
    }

    public KafkaSpecBuilder(KafkaSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withKafka(instance.getKafka());
        this.withZookeeper(instance.getZookeeper());
        this.withTopicOperator(instance.getTopicOperator());
        this.withEntityOperator(instance.getEntityOperator());
        this.validationEnabled = validationEnabled;
    }

    public KafkaSpec build() {
        KafkaSpec buildable = new KafkaSpec();
        buildable.setKafka(this.fluent.getKafka());
        buildable.setZookeeper(this.fluent.getZookeeper());
        buildable.setTopicOperator(this.fluent.getTopicOperator());
        buildable.setEntityOperator(this.fluent.getEntityOperator());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaSpecBuilder that = (KafkaSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

