/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.Resources;
import io.strimzi.api.kafka.model.ResourcesBuilder;
import io.strimzi.api.kafka.model.ResourcesFluentImpl;
import io.strimzi.api.kafka.model.Sidecar;
import io.strimzi.api.kafka.model.SidecarFluent;

public class SidecarFluentImpl<A extends SidecarFluent<A>>
extends BaseFluent<A>
implements SidecarFluent<A> {
    private String image;
    private ResourcesBuilder resources;

    public SidecarFluentImpl() {
    }

    public SidecarFluentImpl(Sidecar instance) {
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public Resources getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(Resources resources) {
        this._visitables.remove(this.resources);
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public SidecarFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public SidecarFluent.ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public SidecarFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public SidecarFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourcesBuilder().build());
    }

    @Override
    public SidecarFluent.ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SidecarFluentImpl that = (SidecarFluentImpl)o;
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        return !(this.resources != null ? !this.resources.equals(that.resources) : that.resources != null);
    }

    public class ResourcesNestedImpl<N>
    extends ResourcesFluentImpl<SidecarFluent.ResourcesNested<N>>
    implements SidecarFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourcesBuilder builder;

        ResourcesNestedImpl(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourcesBuilder(this);
        }

        @Override
        public N and() {
            return (N)SidecarFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }
}

