/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.annotations;

import io.strimzi.api.annotations.VersionRange;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KubeVersion
implements Comparable<KubeVersion> {
    public static final KubeVersion V1_16 = new KubeVersion(1, 16);
    public static final VersionRange<KubeVersion> V1_16_PLUS = KubeVersion.parseRange("1.16+");
    private final short major;
    private final short minor;

    private KubeVersion(short major, short minor) {
        this.major = major;
        this.minor = minor;
    }

    public static KubeVersion parse(String version) {
        Pattern pattern = Pattern.compile("([0-9]+).([0-9]+)");
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid kube version");
        }
        return new KubeVersion(Short.parseShort(matcher.group(1)), Short.parseShort(matcher.group(2)));
    }

    public static VersionRange<KubeVersion> parseRange(String range) {
        return VersionRange.parse(range, KubeVersion::parse);
    }

    @Override
    public int compareTo(KubeVersion o) {
        int cmp = Short.compare(this.major, o.major);
        if (cmp == 0) {
            cmp = Short.compare(this.minor, o.minor);
        }
        return cmp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubeVersion that = (KubeVersion)o;
        return this.major == that.major && this.minor == that.minor;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }

    public String toString() {
        return this.major + "." + this.minor;
    }
}

