/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.policy.AllowedCSIDriver;
import io.fabric8.kubernetes.api.model.policy.AllowedCSIDriverBuilder;
import io.fabric8.kubernetes.api.model.policy.AllowedCSIDriverFluentImpl;
import io.fabric8.kubernetes.api.model.policy.AllowedFlexVolume;
import io.fabric8.kubernetes.api.model.policy.AllowedFlexVolumeBuilder;
import io.fabric8.kubernetes.api.model.policy.AllowedFlexVolumeFluentImpl;
import io.fabric8.kubernetes.api.model.policy.AllowedHostPath;
import io.fabric8.kubernetes.api.model.policy.AllowedHostPathBuilder;
import io.fabric8.kubernetes.api.model.policy.AllowedHostPathFluentImpl;
import io.fabric8.kubernetes.api.model.policy.FSGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.FSGroupStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.FSGroupStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.policy.HostPortRange;
import io.fabric8.kubernetes.api.model.policy.HostPortRangeBuilder;
import io.fabric8.kubernetes.api.model.policy.HostPortRangeFluentImpl;
import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicySpec;
import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicySpecFluent;
import io.fabric8.kubernetes.api.model.policy.RunAsGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.RunAsGroupStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.RunAsGroupStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.policy.RunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.RunAsUserStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.RunAsUserStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.policy.RuntimeClassStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.RuntimeClassStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.RuntimeClassStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.policy.SELinuxStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.SELinuxStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.SELinuxStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.policy.SupplementalGroupsStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.SupplementalGroupsStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.SupplementalGroupsStrategyOptionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PodSecurityPolicySpecFluentImpl<A extends PodSecurityPolicySpecFluent<A>>
extends BaseFluent<A>
implements PodSecurityPolicySpecFluent<A> {
    private Boolean allowPrivilegeEscalation;
    private List<AllowedCSIDriverBuilder> allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();
    private List<String> allowedCapabilities = new ArrayList<String>();
    private List<AllowedFlexVolumeBuilder> allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
    private List<AllowedHostPathBuilder> allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();
    private List<String> allowedProcMountTypes = new ArrayList<String>();
    private List<String> allowedUnsafeSysctls = new ArrayList<String>();
    private List<String> defaultAddCapabilities = new ArrayList<String>();
    private Boolean defaultAllowPrivilegeEscalation;
    private List<String> forbiddenSysctls = new ArrayList<String>();
    private FSGroupStrategyOptionsBuilder fsGroup;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private List<HostPortRangeBuilder> hostPorts = new ArrayList<HostPortRangeBuilder>();
    private Boolean privileged;
    private Boolean readOnlyRootFilesystem;
    private List<String> requiredDropCapabilities = new ArrayList<String>();
    private RunAsGroupStrategyOptionsBuilder runAsGroup;
    private RunAsUserStrategyOptionsBuilder runAsUser;
    private RuntimeClassStrategyOptionsBuilder runtimeClass;
    private SELinuxStrategyOptionsBuilder seLinux;
    private SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
    private List<String> volumes = new ArrayList<String>();

    public PodSecurityPolicySpecFluentImpl() {
    }

    public PodSecurityPolicySpecFluentImpl(PodSecurityPolicySpec instance) {
        this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers());
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
        this.withAllowedHostPaths(instance.getAllowedHostPaths());
        this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes());
        this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());
        this.withForbiddenSysctls(instance.getForbiddenSysctls());
        this.withFsGroup(instance.getFsGroup());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostPorts(instance.getHostPorts());
        this.withPrivileged(instance.getPrivileged());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsUser(instance.getRunAsUser());
        this.withRuntimeClass(instance.getRuntimeClass());
        this.withSeLinux(instance.getSeLinux());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    @Override
    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    @Override
    public A withNewAllowPrivilegeEscalation(String arg1) {
        return this.withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    @Override
    public A withNewAllowPrivilegeEscalation(boolean arg1) {
        return this.withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    @Override
    public A addToAllowedCSIDrivers(int index, AllowedCSIDriver item) {
        if (this.allowedCSIDrivers == null) {
            this.allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();
        }
        AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
        this._visitables.get("allowedCSIDrivers").add(index >= 0 ? index : this._visitables.get("allowedCSIDrivers").size(), builder);
        this.allowedCSIDrivers.add(index >= 0 ? index : this.allowedCSIDrivers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAllowedCSIDrivers(int index, AllowedCSIDriver item) {
        if (this.allowedCSIDrivers == null) {
            this.allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();
        }
        AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
        if (index < 0 || index >= this._visitables.get("allowedCSIDrivers").size()) {
            this._visitables.get("allowedCSIDrivers").add(builder);
        } else {
            this._visitables.get("allowedCSIDrivers").set(index, builder);
        }
        if (index < 0 || index >= this.allowedCSIDrivers.size()) {
            this.allowedCSIDrivers.add(builder);
        } else {
            this.allowedCSIDrivers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAllowedCSIDrivers(AllowedCSIDriver ... items) {
        if (this.allowedCSIDrivers == null) {
            this.allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();
        }
        for (AllowedCSIDriver item : items) {
            AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
            this._visitables.get("allowedCSIDrivers").add(builder);
            this.allowedCSIDrivers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedCSIDrivers(Collection<AllowedCSIDriver> items) {
        if (this.allowedCSIDrivers == null) {
            this.allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();
        }
        for (AllowedCSIDriver item : items) {
            AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
            this._visitables.get("allowedCSIDrivers").add(builder);
            this.allowedCSIDrivers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedCSIDrivers(AllowedCSIDriver ... items) {
        for (AllowedCSIDriver item : items) {
            AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
            this._visitables.get("allowedCSIDrivers").remove(builder);
            if (this.allowedCSIDrivers == null) continue;
            this.allowedCSIDrivers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedCSIDrivers(Collection<AllowedCSIDriver> items) {
        for (AllowedCSIDriver item : items) {
            AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
            this._visitables.get("allowedCSIDrivers").remove(builder);
            if (this.allowedCSIDrivers == null) continue;
            this.allowedCSIDrivers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAllowedCSIDrivers(Predicate<AllowedCSIDriverBuilder> predicate) {
        if (this.allowedCSIDrivers == null) {
            return (A)this;
        }
        Iterator<AllowedCSIDriverBuilder> each = this.allowedCSIDrivers.iterator();
        Object visitables = this._visitables.get("allowedCSIDrivers");
        while (each.hasNext()) {
            AllowedCSIDriverBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AllowedCSIDriver> getAllowedCSIDrivers() {
        return PodSecurityPolicySpecFluentImpl.build(this.allowedCSIDrivers);
    }

    @Override
    public List<AllowedCSIDriver> buildAllowedCSIDrivers() {
        return PodSecurityPolicySpecFluentImpl.build(this.allowedCSIDrivers);
    }

    @Override
    public AllowedCSIDriver buildAllowedCSIDriver(int index) {
        return this.allowedCSIDrivers.get(index).build();
    }

    @Override
    public AllowedCSIDriver buildFirstAllowedCSIDriver() {
        return this.allowedCSIDrivers.get(0).build();
    }

    @Override
    public AllowedCSIDriver buildLastAllowedCSIDriver() {
        return this.allowedCSIDrivers.get(this.allowedCSIDrivers.size() - 1).build();
    }

    @Override
    public AllowedCSIDriver buildMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate) {
        for (AllowedCSIDriverBuilder item : this.allowedCSIDrivers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate) {
        for (AllowedCSIDriverBuilder item : this.allowedCSIDrivers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedCSIDrivers(List<AllowedCSIDriver> allowedCSIDrivers) {
        if (this.allowedCSIDrivers != null) {
            this._visitables.get("allowedCSIDrivers").removeAll(this.allowedCSIDrivers);
        }
        if (allowedCSIDrivers != null) {
            this.allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();
            for (AllowedCSIDriver item : allowedCSIDrivers) {
                this.addToAllowedCSIDrivers(item);
            }
        } else {
            this.allowedCSIDrivers = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedCSIDrivers(AllowedCSIDriver ... allowedCSIDrivers) {
        if (this.allowedCSIDrivers != null) {
            this.allowedCSIDrivers.clear();
        }
        if (allowedCSIDrivers != null) {
            for (AllowedCSIDriver item : allowedCSIDrivers) {
                this.addToAllowedCSIDrivers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedCSIDrivers() {
        return this.allowedCSIDrivers != null && !this.allowedCSIDrivers.isEmpty();
    }

    @Override
    public A addNewAllowedCSIDriver(String name) {
        return this.addToAllowedCSIDrivers(new AllowedCSIDriver(name));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> addNewAllowedCSIDriver() {
        return new AllowedCSIDriversNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> addNewAllowedCSIDriverLike(AllowedCSIDriver item) {
        return new AllowedCSIDriversNestedImpl(-1, item);
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> setNewAllowedCSIDriverLike(int index, AllowedCSIDriver item) {
        return new AllowedCSIDriversNestedImpl(index, item);
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editAllowedCSIDriver(int index) {
        if (this.allowedCSIDrivers.size() <= index) {
            throw new RuntimeException("Can't edit allowedCSIDrivers. Index exceeds size.");
        }
        return this.setNewAllowedCSIDriverLike(index, this.buildAllowedCSIDriver(index));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editFirstAllowedCSIDriver() {
        if (this.allowedCSIDrivers.size() == 0) {
            throw new RuntimeException("Can't edit first allowedCSIDrivers. The list is empty.");
        }
        return this.setNewAllowedCSIDriverLike(0, this.buildAllowedCSIDriver(0));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editLastAllowedCSIDriver() {
        int index = this.allowedCSIDrivers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedCSIDrivers. The list is empty.");
        }
        return this.setNewAllowedCSIDriverLike(index, this.buildAllowedCSIDriver(index));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedCSIDrivers.size(); ++i) {
            if (!predicate.test(this.allowedCSIDrivers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedCSIDrivers. No match found.");
        }
        return this.setNewAllowedCSIDriverLike(index, this.buildAllowedCSIDriver(index));
    }

    @Override
    public A addToAllowedCapabilities(int index, String item) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        this.allowedCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedCapabilities(int index, String item) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        this.allowedCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedCapabilities(String ... items) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedCapabilities(Collection<String> items) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedCapabilities(String ... items) {
        for (String item : items) {
            if (this.allowedCapabilities == null) continue;
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedCapabilities(Collection<String> items) {
        for (String item : items) {
            if (this.allowedCapabilities == null) continue;
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    @Override
    public String getAllowedCapability(int index) {
        return this.allowedCapabilities.get(index);
    }

    @Override
    public String getFirstAllowedCapability() {
        return this.allowedCapabilities.get(0);
    }

    @Override
    public String getLastAllowedCapability() {
        return this.allowedCapabilities.get(this.allowedCapabilities.size() - 1);
    }

    @Override
    public String getMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedCapabilities(List<String> allowedCapabilities) {
        if (this.allowedCapabilities != null) {
            this._visitables.get("allowedCapabilities").removeAll(this.allowedCapabilities);
        }
        if (allowedCapabilities != null) {
            this.allowedCapabilities = new ArrayList<String>();
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        } else {
            this.allowedCapabilities = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedCapabilities(String ... allowedCapabilities) {
        if (this.allowedCapabilities != null) {
            this.allowedCapabilities.clear();
        }
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedCapabilities() {
        return this.allowedCapabilities != null && !this.allowedCapabilities.isEmpty();
    }

    @Override
    public A addNewAllowedCapability(StringBuilder arg1) {
        return this.addToAllowedCapabilities(new String(arg1));
    }

    @Override
    public A addNewAllowedCapability(int[] arg1, int arg2, int arg3) {
        return this.addToAllowedCapabilities(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAllowedCapability(char[] arg1) {
        return this.addToAllowedCapabilities(new String(arg1));
    }

    @Override
    public A addNewAllowedCapability(StringBuffer arg1) {
        return this.addToAllowedCapabilities(new String(arg1));
    }

    @Override
    public A addNewAllowedCapability(byte[] arg1, int arg2) {
        return this.addToAllowedCapabilities(new String(arg1, arg2));
    }

    @Override
    public A addNewAllowedCapability(byte[] arg1) {
        return this.addToAllowedCapabilities(new String(arg1));
    }

    @Override
    public A addNewAllowedCapability(char[] arg1, int arg2, int arg3) {
        return this.addToAllowedCapabilities(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAllowedCapability(byte[] arg1, int arg2, int arg3) {
        return this.addToAllowedCapabilities(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAllowedCapability(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToAllowedCapabilities(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewAllowedCapability(String arg1) {
        return this.addToAllowedCapabilities(new String(arg1));
    }

    @Override
    public A addToAllowedFlexVolumes(int index, AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
        }
        AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
        this._visitables.get("allowedFlexVolumes").add(index >= 0 ? index : this._visitables.get("allowedFlexVolumes").size(), builder);
        this.allowedFlexVolumes.add(index >= 0 ? index : this.allowedFlexVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAllowedFlexVolumes(int index, AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
        }
        AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get("allowedFlexVolumes").size()) {
            this._visitables.get("allowedFlexVolumes").add(builder);
        } else {
            this._visitables.get("allowedFlexVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.allowedFlexVolumes.size()) {
            this.allowedFlexVolumes.add(builder);
        } else {
            this.allowedFlexVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAllowedFlexVolumes(AllowedFlexVolume ... items) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedFlexVolumes(AllowedFlexVolume ... items) {
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").remove(builder);
            if (this.allowedFlexVolumes == null) continue;
            this.allowedFlexVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").remove(builder);
            if (this.allowedFlexVolumes == null) continue;
            this.allowedFlexVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAllowedFlexVolumes(Predicate<AllowedFlexVolumeBuilder> predicate) {
        if (this.allowedFlexVolumes == null) {
            return (A)this;
        }
        Iterator<AllowedFlexVolumeBuilder> each = this.allowedFlexVolumes.iterator();
        Object visitables = this._visitables.get("allowedFlexVolumes");
        while (each.hasNext()) {
            AllowedFlexVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AllowedFlexVolume> getAllowedFlexVolumes() {
        return PodSecurityPolicySpecFluentImpl.build(this.allowedFlexVolumes);
    }

    @Override
    public List<AllowedFlexVolume> buildAllowedFlexVolumes() {
        return PodSecurityPolicySpecFluentImpl.build(this.allowedFlexVolumes);
    }

    @Override
    public AllowedFlexVolume buildAllowedFlexVolume(int index) {
        return this.allowedFlexVolumes.get(index).build();
    }

    @Override
    public AllowedFlexVolume buildFirstAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(0).build();
    }

    @Override
    public AllowedFlexVolume buildLastAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(this.allowedFlexVolumes.size() - 1).build();
    }

    @Override
    public AllowedFlexVolume buildMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        for (AllowedFlexVolumeBuilder item : this.allowedFlexVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        for (AllowedFlexVolumeBuilder item : this.allowedFlexVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedFlexVolumes(List<AllowedFlexVolume> allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) {
            this._visitables.get("allowedFlexVolumes").removeAll(this.allowedFlexVolumes);
        }
        if (allowedFlexVolumes != null) {
            this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
            for (AllowedFlexVolume item : allowedFlexVolumes) {
                this.addToAllowedFlexVolumes(item);
            }
        } else {
            this.allowedFlexVolumes = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedFlexVolumes(AllowedFlexVolume ... allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) {
            this.allowedFlexVolumes.clear();
        }
        if (allowedFlexVolumes != null) {
            for (AllowedFlexVolume item : allowedFlexVolumes) {
                this.addToAllowedFlexVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedFlexVolumes() {
        return this.allowedFlexVolumes != null && !this.allowedFlexVolumes.isEmpty();
    }

    @Override
    public A addNewAllowedFlexVolume(String driver) {
        return this.addToAllowedFlexVolumes(new AllowedFlexVolume(driver));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume() {
        return new AllowedFlexVolumesNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(AllowedFlexVolume item) {
        return new AllowedFlexVolumesNestedImpl(-1, item);
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(int index, AllowedFlexVolume item) {
        return new AllowedFlexVolumesNestedImpl(index, item);
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(int index) {
        if (this.allowedFlexVolumes.size() <= index) {
            throw new RuntimeException("Can't edit allowedFlexVolumes. Index exceeds size.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume() {
        if (this.allowedFlexVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first allowedFlexVolumes. The list is empty.");
        }
        return this.setNewAllowedFlexVolumeLike(0, this.buildAllowedFlexVolume(0));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume() {
        int index = this.allowedFlexVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedFlexVolumes. The list is empty.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedFlexVolumes.size(); ++i) {
            if (!predicate.test(this.allowedFlexVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedFlexVolumes. No match found.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    @Override
    public A addToAllowedHostPaths(int index, AllowedHostPath item) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();
        }
        AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
        this._visitables.get("allowedHostPaths").add(index >= 0 ? index : this._visitables.get("allowedHostPaths").size(), builder);
        this.allowedHostPaths.add(index >= 0 ? index : this.allowedHostPaths.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAllowedHostPaths(int index, AllowedHostPath item) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();
        }
        AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
        if (index < 0 || index >= this._visitables.get("allowedHostPaths").size()) {
            this._visitables.get("allowedHostPaths").add(builder);
        } else {
            this._visitables.get("allowedHostPaths").set(index, builder);
        }
        if (index < 0 || index >= this.allowedHostPaths.size()) {
            this.allowedHostPaths.add(builder);
        } else {
            this.allowedHostPaths.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAllowedHostPaths(AllowedHostPath ... items) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();
        }
        for (AllowedHostPath item : items) {
            AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
            this._visitables.get("allowedHostPaths").add(builder);
            this.allowedHostPaths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedHostPaths(Collection<AllowedHostPath> items) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();
        }
        for (AllowedHostPath item : items) {
            AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
            this._visitables.get("allowedHostPaths").add(builder);
            this.allowedHostPaths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedHostPaths(AllowedHostPath ... items) {
        for (AllowedHostPath item : items) {
            AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
            this._visitables.get("allowedHostPaths").remove(builder);
            if (this.allowedHostPaths == null) continue;
            this.allowedHostPaths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedHostPaths(Collection<AllowedHostPath> items) {
        for (AllowedHostPath item : items) {
            AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
            this._visitables.get("allowedHostPaths").remove(builder);
            if (this.allowedHostPaths == null) continue;
            this.allowedHostPaths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAllowedHostPaths(Predicate<AllowedHostPathBuilder> predicate) {
        if (this.allowedHostPaths == null) {
            return (A)this;
        }
        Iterator<AllowedHostPathBuilder> each = this.allowedHostPaths.iterator();
        Object visitables = this._visitables.get("allowedHostPaths");
        while (each.hasNext()) {
            AllowedHostPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AllowedHostPath> getAllowedHostPaths() {
        return PodSecurityPolicySpecFluentImpl.build(this.allowedHostPaths);
    }

    @Override
    public List<AllowedHostPath> buildAllowedHostPaths() {
        return PodSecurityPolicySpecFluentImpl.build(this.allowedHostPaths);
    }

    @Override
    public AllowedHostPath buildAllowedHostPath(int index) {
        return this.allowedHostPaths.get(index).build();
    }

    @Override
    public AllowedHostPath buildFirstAllowedHostPath() {
        return this.allowedHostPaths.get(0).build();
    }

    @Override
    public AllowedHostPath buildLastAllowedHostPath() {
        return this.allowedHostPaths.get(this.allowedHostPaths.size() - 1).build();
    }

    @Override
    public AllowedHostPath buildMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate) {
        for (AllowedHostPathBuilder item : this.allowedHostPaths) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate) {
        for (AllowedHostPathBuilder item : this.allowedHostPaths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedHostPaths(List<AllowedHostPath> allowedHostPaths) {
        if (this.allowedHostPaths != null) {
            this._visitables.get("allowedHostPaths").removeAll(this.allowedHostPaths);
        }
        if (allowedHostPaths != null) {
            this.allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();
            for (AllowedHostPath item : allowedHostPaths) {
                this.addToAllowedHostPaths(item);
            }
        } else {
            this.allowedHostPaths = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedHostPaths(AllowedHostPath ... allowedHostPaths) {
        if (this.allowedHostPaths != null) {
            this.allowedHostPaths.clear();
        }
        if (allowedHostPaths != null) {
            for (AllowedHostPath item : allowedHostPaths) {
                this.addToAllowedHostPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedHostPaths() {
        return this.allowedHostPaths != null && !this.allowedHostPaths.isEmpty();
    }

    @Override
    public A addNewAllowedHostPath(String pathPrefix, Boolean readOnly) {
        return this.addToAllowedHostPaths(new AllowedHostPath(pathPrefix, readOnly));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPath() {
        return new AllowedHostPathsNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPathLike(AllowedHostPath item) {
        return new AllowedHostPathsNestedImpl(-1, item);
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> setNewAllowedHostPathLike(int index, AllowedHostPath item) {
        return new AllowedHostPathsNestedImpl(index, item);
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editAllowedHostPath(int index) {
        if (this.allowedHostPaths.size() <= index) {
            throw new RuntimeException("Can't edit allowedHostPaths. Index exceeds size.");
        }
        return this.setNewAllowedHostPathLike(index, this.buildAllowedHostPath(index));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editFirstAllowedHostPath() {
        if (this.allowedHostPaths.size() == 0) {
            throw new RuntimeException("Can't edit first allowedHostPaths. The list is empty.");
        }
        return this.setNewAllowedHostPathLike(0, this.buildAllowedHostPath(0));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editLastAllowedHostPath() {
        int index = this.allowedHostPaths.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedHostPaths. The list is empty.");
        }
        return this.setNewAllowedHostPathLike(index, this.buildAllowedHostPath(index));
    }

    @Override
    public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedHostPaths.size(); ++i) {
            if (!predicate.test(this.allowedHostPaths.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedHostPaths. No match found.");
        }
        return this.setNewAllowedHostPathLike(index, this.buildAllowedHostPath(index));
    }

    @Override
    public A addToAllowedProcMountTypes(int index, String item) {
        if (this.allowedProcMountTypes == null) {
            this.allowedProcMountTypes = new ArrayList<String>();
        }
        this.allowedProcMountTypes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedProcMountTypes(int index, String item) {
        if (this.allowedProcMountTypes == null) {
            this.allowedProcMountTypes = new ArrayList<String>();
        }
        this.allowedProcMountTypes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedProcMountTypes(String ... items) {
        if (this.allowedProcMountTypes == null) {
            this.allowedProcMountTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedProcMountTypes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedProcMountTypes(Collection<String> items) {
        if (this.allowedProcMountTypes == null) {
            this.allowedProcMountTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedProcMountTypes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedProcMountTypes(String ... items) {
        for (String item : items) {
            if (this.allowedProcMountTypes == null) continue;
            this.allowedProcMountTypes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedProcMountTypes(Collection<String> items) {
        for (String item : items) {
            if (this.allowedProcMountTypes == null) continue;
            this.allowedProcMountTypes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedProcMountTypes() {
        return this.allowedProcMountTypes;
    }

    @Override
    public String getAllowedProcMountType(int index) {
        return this.allowedProcMountTypes.get(index);
    }

    @Override
    public String getFirstAllowedProcMountType() {
        return this.allowedProcMountTypes.get(0);
    }

    @Override
    public String getLastAllowedProcMountType() {
        return this.allowedProcMountTypes.get(this.allowedProcMountTypes.size() - 1);
    }

    @Override
    public String getMatchingAllowedProcMountType(Predicate<String> predicate) {
        for (String item : this.allowedProcMountTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedProcMountType(Predicate<String> predicate) {
        for (String item : this.allowedProcMountTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedProcMountTypes(List<String> allowedProcMountTypes) {
        if (this.allowedProcMountTypes != null) {
            this._visitables.get("allowedProcMountTypes").removeAll(this.allowedProcMountTypes);
        }
        if (allowedProcMountTypes != null) {
            this.allowedProcMountTypes = new ArrayList<String>();
            for (String item : allowedProcMountTypes) {
                this.addToAllowedProcMountTypes(item);
            }
        } else {
            this.allowedProcMountTypes = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedProcMountTypes(String ... allowedProcMountTypes) {
        if (this.allowedProcMountTypes != null) {
            this.allowedProcMountTypes.clear();
        }
        if (allowedProcMountTypes != null) {
            for (String item : allowedProcMountTypes) {
                this.addToAllowedProcMountTypes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedProcMountTypes() {
        return this.allowedProcMountTypes != null && !this.allowedProcMountTypes.isEmpty();
    }

    @Override
    public A addNewAllowedProcMountType(StringBuilder arg1) {
        return this.addToAllowedProcMountTypes(new String(arg1));
    }

    @Override
    public A addNewAllowedProcMountType(int[] arg1, int arg2, int arg3) {
        return this.addToAllowedProcMountTypes(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAllowedProcMountType(char[] arg1) {
        return this.addToAllowedProcMountTypes(new String(arg1));
    }

    @Override
    public A addNewAllowedProcMountType(StringBuffer arg1) {
        return this.addToAllowedProcMountTypes(new String(arg1));
    }

    @Override
    public A addNewAllowedProcMountType(byte[] arg1, int arg2) {
        return this.addToAllowedProcMountTypes(new String(arg1, arg2));
    }

    @Override
    public A addNewAllowedProcMountType(byte[] arg1) {
        return this.addToAllowedProcMountTypes(new String(arg1));
    }

    @Override
    public A addNewAllowedProcMountType(char[] arg1, int arg2, int arg3) {
        return this.addToAllowedProcMountTypes(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAllowedProcMountType(byte[] arg1, int arg2, int arg3) {
        return this.addToAllowedProcMountTypes(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAllowedProcMountType(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToAllowedProcMountTypes(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewAllowedProcMountType(String arg1) {
        return this.addToAllowedProcMountTypes(new String(arg1));
    }

    @Override
    public A addToAllowedUnsafeSysctls(int index, String item) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        this.allowedUnsafeSysctls.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedUnsafeSysctls(int index, String item) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        this.allowedUnsafeSysctls.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedUnsafeSysctls(String ... items) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedUnsafeSysctls(Collection<String> items) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedUnsafeSysctls(String ... items) {
        for (String item : items) {
            if (this.allowedUnsafeSysctls == null) continue;
            this.allowedUnsafeSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedUnsafeSysctls(Collection<String> items) {
        for (String item : items) {
            if (this.allowedUnsafeSysctls == null) continue;
            this.allowedUnsafeSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls;
    }

    @Override
    public String getAllowedUnsafeSysctl(int index) {
        return this.allowedUnsafeSysctls.get(index);
    }

    @Override
    public String getFirstAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(0);
    }

    @Override
    public String getLastAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(this.allowedUnsafeSysctls.size() - 1);
    }

    @Override
    public String getMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
        for (String item : this.allowedUnsafeSysctls) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
        for (String item : this.allowedUnsafeSysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls) {
        if (this.allowedUnsafeSysctls != null) {
            this._visitables.get("allowedUnsafeSysctls").removeAll(this.allowedUnsafeSysctls);
        }
        if (allowedUnsafeSysctls != null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
            for (String item : allowedUnsafeSysctls) {
                this.addToAllowedUnsafeSysctls(item);
            }
        } else {
            this.allowedUnsafeSysctls = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedUnsafeSysctls(String ... allowedUnsafeSysctls) {
        if (this.allowedUnsafeSysctls != null) {
            this.allowedUnsafeSysctls.clear();
        }
        if (allowedUnsafeSysctls != null) {
            for (String item : allowedUnsafeSysctls) {
                this.addToAllowedUnsafeSysctls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls != null && !this.allowedUnsafeSysctls.isEmpty();
    }

    @Override
    public A addNewAllowedUnsafeSysctl(StringBuilder arg1) {
        return this.addToAllowedUnsafeSysctls(new String(arg1));
    }

    @Override
    public A addNewAllowedUnsafeSysctl(int[] arg1, int arg2, int arg3) {
        return this.addToAllowedUnsafeSysctls(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAllowedUnsafeSysctl(char[] arg1) {
        return this.addToAllowedUnsafeSysctls(new String(arg1));
    }

    @Override
    public A addNewAllowedUnsafeSysctl(StringBuffer arg1) {
        return this.addToAllowedUnsafeSysctls(new String(arg1));
    }

    @Override
    public A addNewAllowedUnsafeSysctl(byte[] arg1, int arg2) {
        return this.addToAllowedUnsafeSysctls(new String(arg1, arg2));
    }

    @Override
    public A addNewAllowedUnsafeSysctl(byte[] arg1) {
        return this.addToAllowedUnsafeSysctls(new String(arg1));
    }

    @Override
    public A addNewAllowedUnsafeSysctl(char[] arg1, int arg2, int arg3) {
        return this.addToAllowedUnsafeSysctls(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAllowedUnsafeSysctl(byte[] arg1, int arg2, int arg3) {
        return this.addToAllowedUnsafeSysctls(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewAllowedUnsafeSysctl(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToAllowedUnsafeSysctls(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewAllowedUnsafeSysctl(String arg1) {
        return this.addToAllowedUnsafeSysctls(new String(arg1));
    }

    @Override
    public A addToDefaultAddCapabilities(int index, String item) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        this.defaultAddCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDefaultAddCapabilities(int index, String item) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        this.defaultAddCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDefaultAddCapabilities(String ... items) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDefaultAddCapabilities(Collection<String> items) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            if (this.defaultAddCapabilities == null) continue;
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDefaultAddCapabilities(Collection<String> items) {
        for (String item : items) {
            if (this.defaultAddCapabilities == null) continue;
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    @Override
    public String getDefaultAddCapability(int index) {
        return this.defaultAddCapabilities.get(index);
    }

    @Override
    public String getFirstDefaultAddCapability() {
        return this.defaultAddCapabilities.get(0);
    }

    @Override
    public String getLastDefaultAddCapability() {
        return this.defaultAddCapabilities.get(this.defaultAddCapabilities.size() - 1);
    }

    @Override
    public String getMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        if (this.defaultAddCapabilities != null) {
            this._visitables.get("defaultAddCapabilities").removeAll(this.defaultAddCapabilities);
        }
        if (defaultAddCapabilities != null) {
            this.defaultAddCapabilities = new ArrayList<String>();
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        } else {
            this.defaultAddCapabilities = null;
        }
        return (A)this;
    }

    @Override
    public A withDefaultAddCapabilities(String ... defaultAddCapabilities) {
        if (this.defaultAddCapabilities != null) {
            this.defaultAddCapabilities.clear();
        }
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultAddCapabilities() {
        return this.defaultAddCapabilities != null && !this.defaultAddCapabilities.isEmpty();
    }

    @Override
    public A addNewDefaultAddCapability(StringBuilder arg1) {
        return this.addToDefaultAddCapabilities(new String(arg1));
    }

    @Override
    public A addNewDefaultAddCapability(int[] arg1, int arg2, int arg3) {
        return this.addToDefaultAddCapabilities(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewDefaultAddCapability(char[] arg1) {
        return this.addToDefaultAddCapabilities(new String(arg1));
    }

    @Override
    public A addNewDefaultAddCapability(StringBuffer arg1) {
        return this.addToDefaultAddCapabilities(new String(arg1));
    }

    @Override
    public A addNewDefaultAddCapability(byte[] arg1, int arg2) {
        return this.addToDefaultAddCapabilities(new String(arg1, arg2));
    }

    @Override
    public A addNewDefaultAddCapability(byte[] arg1) {
        return this.addToDefaultAddCapabilities(new String(arg1));
    }

    @Override
    public A addNewDefaultAddCapability(char[] arg1, int arg2, int arg3) {
        return this.addToDefaultAddCapabilities(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewDefaultAddCapability(byte[] arg1, int arg2, int arg3) {
        return this.addToDefaultAddCapabilities(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewDefaultAddCapability(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToDefaultAddCapabilities(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewDefaultAddCapability(String arg1) {
        return this.addToDefaultAddCapabilities(new String(arg1));
    }

    @Override
    public Boolean getDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation;
    }

    @Override
    public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation) {
        this.defaultAllowPrivilegeEscalation = defaultAllowPrivilegeEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation != null;
    }

    @Override
    public A withNewDefaultAllowPrivilegeEscalation(String arg1) {
        return this.withDefaultAllowPrivilegeEscalation(new Boolean(arg1));
    }

    @Override
    public A withNewDefaultAllowPrivilegeEscalation(boolean arg1) {
        return this.withDefaultAllowPrivilegeEscalation(new Boolean(arg1));
    }

    @Override
    public A addToForbiddenSysctls(int index, String item) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        this.forbiddenSysctls.add(index, item);
        return (A)this;
    }

    @Override
    public A setToForbiddenSysctls(int index, String item) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        this.forbiddenSysctls.set(index, item);
        return (A)this;
    }

    @Override
    public A addToForbiddenSysctls(String ... items) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.forbiddenSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToForbiddenSysctls(Collection<String> items) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.forbiddenSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromForbiddenSysctls(String ... items) {
        for (String item : items) {
            if (this.forbiddenSysctls == null) continue;
            this.forbiddenSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromForbiddenSysctls(Collection<String> items) {
        for (String item : items) {
            if (this.forbiddenSysctls == null) continue;
            this.forbiddenSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getForbiddenSysctls() {
        return this.forbiddenSysctls;
    }

    @Override
    public String getForbiddenSysctl(int index) {
        return this.forbiddenSysctls.get(index);
    }

    @Override
    public String getFirstForbiddenSysctl() {
        return this.forbiddenSysctls.get(0);
    }

    @Override
    public String getLastForbiddenSysctl() {
        return this.forbiddenSysctls.get(this.forbiddenSysctls.size() - 1);
    }

    @Override
    public String getMatchingForbiddenSysctl(Predicate<String> predicate) {
        for (String item : this.forbiddenSysctls) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingForbiddenSysctl(Predicate<String> predicate) {
        for (String item : this.forbiddenSysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withForbiddenSysctls(List<String> forbiddenSysctls) {
        if (this.forbiddenSysctls != null) {
            this._visitables.get("forbiddenSysctls").removeAll(this.forbiddenSysctls);
        }
        if (forbiddenSysctls != null) {
            this.forbiddenSysctls = new ArrayList<String>();
            for (String item : forbiddenSysctls) {
                this.addToForbiddenSysctls(item);
            }
        } else {
            this.forbiddenSysctls = null;
        }
        return (A)this;
    }

    @Override
    public A withForbiddenSysctls(String ... forbiddenSysctls) {
        if (this.forbiddenSysctls != null) {
            this.forbiddenSysctls.clear();
        }
        if (forbiddenSysctls != null) {
            for (String item : forbiddenSysctls) {
                this.addToForbiddenSysctls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasForbiddenSysctls() {
        return this.forbiddenSysctls != null && !this.forbiddenSysctls.isEmpty();
    }

    @Override
    public A addNewForbiddenSysctl(StringBuilder arg1) {
        return this.addToForbiddenSysctls(new String(arg1));
    }

    @Override
    public A addNewForbiddenSysctl(int[] arg1, int arg2, int arg3) {
        return this.addToForbiddenSysctls(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewForbiddenSysctl(char[] arg1) {
        return this.addToForbiddenSysctls(new String(arg1));
    }

    @Override
    public A addNewForbiddenSysctl(StringBuffer arg1) {
        return this.addToForbiddenSysctls(new String(arg1));
    }

    @Override
    public A addNewForbiddenSysctl(byte[] arg1, int arg2) {
        return this.addToForbiddenSysctls(new String(arg1, arg2));
    }

    @Override
    public A addNewForbiddenSysctl(byte[] arg1) {
        return this.addToForbiddenSysctls(new String(arg1));
    }

    @Override
    public A addNewForbiddenSysctl(char[] arg1, int arg2, int arg3) {
        return this.addToForbiddenSysctls(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewForbiddenSysctl(byte[] arg1, int arg2, int arg3) {
        return this.addToForbiddenSysctls(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewForbiddenSysctl(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToForbiddenSysctls(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewForbiddenSysctl(String arg1) {
        return this.addToForbiddenSysctls(new String(arg1));
    }

    @Override
    @Deprecated
    public FSGroupStrategyOptions getFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    @Override
    public FSGroupStrategyOptions buildFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    @Override
    public A withFsGroup(FSGroupStrategyOptions fsGroup) {
        this._visitables.get("fsGroup").remove(this.fsGroup);
        if (fsGroup != null) {
            this.fsGroup = new FSGroupStrategyOptionsBuilder(fsGroup);
            this._visitables.get("fsGroup").add(this.fsGroup);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    @Override
    public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup() {
        return new FsGroupNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item) {
        return new FsGroupNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup());
    }

    @Override
    public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup() != null ? this.getFsGroup() : new FSGroupStrategyOptionsBuilder().build());
    }

    @Override
    public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item) {
        return this.withNewFsGroupLike(this.getFsGroup() != null ? this.getFsGroup() : item);
    }

    @Override
    public Boolean getHostIPC() {
        return this.hostIPC;
    }

    @Override
    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    @Override
    public Boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    @Override
    public A withNewHostIPC(String arg1) {
        return this.withHostIPC(new Boolean(arg1));
    }

    @Override
    public A withNewHostIPC(boolean arg1) {
        return this.withHostIPC(new Boolean(arg1));
    }

    @Override
    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    @Override
    public A withNewHostNetwork(String arg1) {
        return this.withHostNetwork(new Boolean(arg1));
    }

    @Override
    public A withNewHostNetwork(boolean arg1) {
        return this.withHostNetwork(new Boolean(arg1));
    }

    @Override
    public Boolean getHostPID() {
        return this.hostPID;
    }

    @Override
    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    @Override
    public Boolean hasHostPID() {
        return this.hostPID != null;
    }

    @Override
    public A withNewHostPID(String arg1) {
        return this.withHostPID(new Boolean(arg1));
    }

    @Override
    public A withNewHostPID(boolean arg1) {
        return this.withHostPID(new Boolean(arg1));
    }

    @Override
    public A addToHostPorts(int index, HostPortRange item) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList<HostPortRangeBuilder>();
        }
        HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
        this._visitables.get("hostPorts").add(index >= 0 ? index : this._visitables.get("hostPorts").size(), builder);
        this.hostPorts.add(index >= 0 ? index : this.hostPorts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHostPorts(int index, HostPortRange item) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList<HostPortRangeBuilder>();
        }
        HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
        if (index < 0 || index >= this._visitables.get("hostPorts").size()) {
            this._visitables.get("hostPorts").add(builder);
        } else {
            this._visitables.get("hostPorts").set(index, builder);
        }
        if (index < 0 || index >= this.hostPorts.size()) {
            this.hostPorts.add(builder);
        } else {
            this.hostPorts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHostPorts(HostPortRange ... items) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList<HostPortRangeBuilder>();
        }
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.get("hostPorts").add(builder);
            this.hostPorts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostPorts(Collection<HostPortRange> items) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList<HostPortRangeBuilder>();
        }
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.get("hostPorts").add(builder);
            this.hostPorts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostPorts(HostPortRange ... items) {
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.get("hostPorts").remove(builder);
            if (this.hostPorts == null) continue;
            this.hostPorts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostPorts(Collection<HostPortRange> items) {
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.get("hostPorts").remove(builder);
            if (this.hostPorts == null) continue;
            this.hostPorts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHostPorts(Predicate<HostPortRangeBuilder> predicate) {
        if (this.hostPorts == null) {
            return (A)this;
        }
        Iterator<HostPortRangeBuilder> each = this.hostPorts.iterator();
        Object visitables = this._visitables.get("hostPorts");
        while (each.hasNext()) {
            HostPortRangeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HostPortRange> getHostPorts() {
        return PodSecurityPolicySpecFluentImpl.build(this.hostPorts);
    }

    @Override
    public List<HostPortRange> buildHostPorts() {
        return PodSecurityPolicySpecFluentImpl.build(this.hostPorts);
    }

    @Override
    public HostPortRange buildHostPort(int index) {
        return this.hostPorts.get(index).build();
    }

    @Override
    public HostPortRange buildFirstHostPort() {
        return this.hostPorts.get(0).build();
    }

    @Override
    public HostPortRange buildLastHostPort() {
        return this.hostPorts.get(this.hostPorts.size() - 1).build();
    }

    @Override
    public HostPortRange buildMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
        for (HostPortRangeBuilder item : this.hostPorts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
        for (HostPortRangeBuilder item : this.hostPorts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostPorts(List<HostPortRange> hostPorts) {
        if (this.hostPorts != null) {
            this._visitables.get("hostPorts").removeAll(this.hostPorts);
        }
        if (hostPorts != null) {
            this.hostPorts = new ArrayList<HostPortRangeBuilder>();
            for (HostPortRange item : hostPorts) {
                this.addToHostPorts(item);
            }
        } else {
            this.hostPorts = null;
        }
        return (A)this;
    }

    @Override
    public A withHostPorts(HostPortRange ... hostPorts) {
        if (this.hostPorts != null) {
            this.hostPorts.clear();
        }
        if (hostPorts != null) {
            for (HostPortRange item : hostPorts) {
                this.addToHostPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostPorts() {
        return this.hostPorts != null && !this.hostPorts.isEmpty();
    }

    @Override
    public A addNewHostPort(Integer max, Integer min) {
        return this.addToHostPorts(new HostPortRange(max, min));
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort() {
        return new HostPortsNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(HostPortRange item) {
        return new HostPortsNestedImpl(-1, item);
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(int index, HostPortRange item) {
        return new HostPortsNestedImpl(index, item);
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(int index) {
        if (this.hostPorts.size() <= index) {
            throw new RuntimeException("Can't edit hostPorts. Index exceeds size.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort() {
        if (this.hostPorts.size() == 0) {
            throw new RuntimeException("Can't edit first hostPorts. The list is empty.");
        }
        return this.setNewHostPortLike(0, this.buildHostPort(0));
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort() {
        int index = this.hostPorts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostPorts. The list is empty.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostPorts.size(); ++i) {
            if (!predicate.test(this.hostPorts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostPorts. No match found.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    @Override
    public Boolean getPrivileged() {
        return this.privileged;
    }

    @Override
    public A withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (A)this;
    }

    @Override
    public Boolean hasPrivileged() {
        return this.privileged != null;
    }

    @Override
    public A withNewPrivileged(String arg1) {
        return this.withPrivileged(new Boolean(arg1));
    }

    @Override
    public A withNewPrivileged(boolean arg1) {
        return this.withPrivileged(new Boolean(arg1));
    }

    @Override
    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    @Override
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    @Override
    public A withNewReadOnlyRootFilesystem(String arg1) {
        return this.withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnlyRootFilesystem(boolean arg1) {
        return this.withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    @Override
    public A addToRequiredDropCapabilities(int index, String item) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        this.requiredDropCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRequiredDropCapabilities(int index, String item) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        this.requiredDropCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRequiredDropCapabilities(String ... items) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRequiredDropCapabilities(Collection<String> items) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            if (this.requiredDropCapabilities == null) continue;
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRequiredDropCapabilities(Collection<String> items) {
        for (String item : items) {
            if (this.requiredDropCapabilities == null) continue;
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    @Override
    public String getRequiredDropCapability(int index) {
        return this.requiredDropCapabilities.get(index);
    }

    @Override
    public String getFirstRequiredDropCapability() {
        return this.requiredDropCapabilities.get(0);
    }

    @Override
    public String getLastRequiredDropCapability() {
        return this.requiredDropCapabilities.get(this.requiredDropCapabilities.size() - 1);
    }

    @Override
    public String getMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        if (this.requiredDropCapabilities != null) {
            this._visitables.get("requiredDropCapabilities").removeAll(this.requiredDropCapabilities);
        }
        if (requiredDropCapabilities != null) {
            this.requiredDropCapabilities = new ArrayList<String>();
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        } else {
            this.requiredDropCapabilities = null;
        }
        return (A)this;
    }

    @Override
    public A withRequiredDropCapabilities(String ... requiredDropCapabilities) {
        if (this.requiredDropCapabilities != null) {
            this.requiredDropCapabilities.clear();
        }
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequiredDropCapabilities() {
        return this.requiredDropCapabilities != null && !this.requiredDropCapabilities.isEmpty();
    }

    @Override
    public A addNewRequiredDropCapability(StringBuilder arg1) {
        return this.addToRequiredDropCapabilities(new String(arg1));
    }

    @Override
    public A addNewRequiredDropCapability(int[] arg1, int arg2, int arg3) {
        return this.addToRequiredDropCapabilities(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewRequiredDropCapability(char[] arg1) {
        return this.addToRequiredDropCapabilities(new String(arg1));
    }

    @Override
    public A addNewRequiredDropCapability(StringBuffer arg1) {
        return this.addToRequiredDropCapabilities(new String(arg1));
    }

    @Override
    public A addNewRequiredDropCapability(byte[] arg1, int arg2) {
        return this.addToRequiredDropCapabilities(new String(arg1, arg2));
    }

    @Override
    public A addNewRequiredDropCapability(byte[] arg1) {
        return this.addToRequiredDropCapabilities(new String(arg1));
    }

    @Override
    public A addNewRequiredDropCapability(char[] arg1, int arg2, int arg3) {
        return this.addToRequiredDropCapabilities(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewRequiredDropCapability(byte[] arg1, int arg2, int arg3) {
        return this.addToRequiredDropCapabilities(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewRequiredDropCapability(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToRequiredDropCapabilities(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewRequiredDropCapability(String arg1) {
        return this.addToRequiredDropCapabilities(new String(arg1));
    }

    @Override
    @Deprecated
    public RunAsGroupStrategyOptions getRunAsGroup() {
        return this.runAsGroup != null ? this.runAsGroup.build() : null;
    }

    @Override
    public RunAsGroupStrategyOptions buildRunAsGroup() {
        return this.runAsGroup != null ? this.runAsGroup.build() : null;
    }

    @Override
    public A withRunAsGroup(RunAsGroupStrategyOptions runAsGroup) {
        this._visitables.get("runAsGroup").remove(this.runAsGroup);
        if (runAsGroup != null) {
            this.runAsGroup = new RunAsGroupStrategyOptionsBuilder(runAsGroup);
            this._visitables.get("runAsGroup").add(this.runAsGroup);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroup() {
        return new RunAsGroupNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroupLike(RunAsGroupStrategyOptions item) {
        return new RunAsGroupNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsGroupNested<A> editRunAsGroup() {
        return this.withNewRunAsGroupLike(this.getRunAsGroup());
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroup() {
        return this.withNewRunAsGroupLike(this.getRunAsGroup() != null ? this.getRunAsGroup() : new RunAsGroupStrategyOptionsBuilder().build());
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroupLike(RunAsGroupStrategyOptions item) {
        return this.withNewRunAsGroupLike(this.getRunAsGroup() != null ? this.getRunAsGroup() : item);
    }

    @Override
    @Deprecated
    public RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    @Override
    public RunAsUserStrategyOptions buildRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    @Override
    public A withRunAsUser(RunAsUserStrategyOptions runAsUser) {
        this._visitables.get("runAsUser").remove(this.runAsUser);
        if (runAsUser != null) {
            this.runAsUser = new RunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.get("runAsUser").add(this.runAsUser);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser() {
        return new RunAsUserNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return new RunAsUserNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser());
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser() != null ? this.getRunAsUser() : new RunAsUserStrategyOptionsBuilder().build());
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return this.withNewRunAsUserLike(this.getRunAsUser() != null ? this.getRunAsUser() : item);
    }

    @Override
    @Deprecated
    public RuntimeClassStrategyOptions getRuntimeClass() {
        return this.runtimeClass != null ? this.runtimeClass.build() : null;
    }

    @Override
    public RuntimeClassStrategyOptions buildRuntimeClass() {
        return this.runtimeClass != null ? this.runtimeClass.build() : null;
    }

    @Override
    public A withRuntimeClass(RuntimeClassStrategyOptions runtimeClass) {
        this._visitables.get("runtimeClass").remove(this.runtimeClass);
        if (runtimeClass != null) {
            this.runtimeClass = new RuntimeClassStrategyOptionsBuilder(runtimeClass);
            this._visitables.get("runtimeClass").add(this.runtimeClass);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeClass() {
        return this.runtimeClass != null;
    }

    @Override
    public PodSecurityPolicySpecFluent.RuntimeClassNested<A> withNewRuntimeClass() {
        return new RuntimeClassNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.RuntimeClassNested<A> withNewRuntimeClassLike(RuntimeClassStrategyOptions item) {
        return new RuntimeClassNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySpecFluent.RuntimeClassNested<A> editRuntimeClass() {
        return this.withNewRuntimeClassLike(this.getRuntimeClass());
    }

    @Override
    public PodSecurityPolicySpecFluent.RuntimeClassNested<A> editOrNewRuntimeClass() {
        return this.withNewRuntimeClassLike(this.getRuntimeClass() != null ? this.getRuntimeClass() : new RuntimeClassStrategyOptionsBuilder().build());
    }

    @Override
    public PodSecurityPolicySpecFluent.RuntimeClassNested<A> editOrNewRuntimeClassLike(RuntimeClassStrategyOptions item) {
        return this.withNewRuntimeClassLike(this.getRuntimeClass() != null ? this.getRuntimeClass() : item);
    }

    @Override
    @Deprecated
    public SELinuxStrategyOptions getSeLinux() {
        return this.seLinux != null ? this.seLinux.build() : null;
    }

    @Override
    public SELinuxStrategyOptions buildSeLinux() {
        return this.seLinux != null ? this.seLinux.build() : null;
    }

    @Override
    public A withSeLinux(SELinuxStrategyOptions seLinux) {
        this._visitables.get("seLinux").remove(this.seLinux);
        if (seLinux != null) {
            this.seLinux = new SELinuxStrategyOptionsBuilder(seLinux);
            this._visitables.get("seLinux").add(this.seLinux);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinux() {
        return this.seLinux != null;
    }

    @Override
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux() {
        return new SeLinuxNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(SELinuxStrategyOptions item) {
        return new SeLinuxNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux() {
        return this.withNewSeLinuxLike(this.getSeLinux());
    }

    @Override
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux() {
        return this.withNewSeLinuxLike(this.getSeLinux() != null ? this.getSeLinux() : new SELinuxStrategyOptionsBuilder().build());
    }

    @Override
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(SELinuxStrategyOptions item) {
        return this.withNewSeLinuxLike(this.getSeLinux() != null ? this.getSeLinux() : item);
    }

    @Override
    @Deprecated
    public SupplementalGroupsStrategyOptions getSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    @Override
    public SupplementalGroupsStrategyOptions buildSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    @Override
    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
        this._visitables.get("supplementalGroups").remove(this.supplementalGroups);
        if (supplementalGroups != null) {
            this.supplementalGroups = new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups);
            this._visitables.get("supplementalGroups").add(this.supplementalGroups);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSupplementalGroups() {
        return this.supplementalGroups != null;
    }

    @Override
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups() {
        return new SupplementalGroupsNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return new SupplementalGroupsNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups());
    }

    @Override
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups() != null ? this.getSupplementalGroups() : new SupplementalGroupsStrategyOptionsBuilder().build());
    }

    @Override
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups() != null ? this.getSupplementalGroups() : item);
    }

    @Override
    public A addToVolumes(int index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(String ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<String> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(String ... items) {
        for (String item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<String> items) {
        for (String item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Override
    public String getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public String getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public String getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public String getMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<String> volumes) {
        if (this.volumes != null) {
            this._visitables.get("volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<String>();
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(String ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public A addNewVolume(StringBuilder arg1) {
        return this.addToVolumes(new String(arg1));
    }

    @Override
    public A addNewVolume(int[] arg1, int arg2, int arg3) {
        return this.addToVolumes(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewVolume(char[] arg1) {
        return this.addToVolumes(new String(arg1));
    }

    @Override
    public A addNewVolume(StringBuffer arg1) {
        return this.addToVolumes(new String(arg1));
    }

    @Override
    public A addNewVolume(byte[] arg1, int arg2) {
        return this.addToVolumes(new String(arg1, arg2));
    }

    @Override
    public A addNewVolume(byte[] arg1) {
        return this.addToVolumes(new String(arg1));
    }

    @Override
    public A addNewVolume(char[] arg1, int arg2, int arg3) {
        return this.addToVolumes(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewVolume(byte[] arg1, int arg2, int arg3) {
        return this.addToVolumes(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewVolume(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToVolumes(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewVolume(String arg1) {
        return this.addToVolumes(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSecurityPolicySpecFluentImpl that = (PodSecurityPolicySpecFluentImpl)o;
        if (this.allowPrivilegeEscalation != null ? !this.allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) : that.allowPrivilegeEscalation != null) {
            return false;
        }
        if (this.allowedCSIDrivers != null ? !this.allowedCSIDrivers.equals(that.allowedCSIDrivers) : that.allowedCSIDrivers != null) {
            return false;
        }
        if (this.allowedCapabilities != null ? !this.allowedCapabilities.equals(that.allowedCapabilities) : that.allowedCapabilities != null) {
            return false;
        }
        if (this.allowedFlexVolumes != null ? !this.allowedFlexVolumes.equals(that.allowedFlexVolumes) : that.allowedFlexVolumes != null) {
            return false;
        }
        if (this.allowedHostPaths != null ? !this.allowedHostPaths.equals(that.allowedHostPaths) : that.allowedHostPaths != null) {
            return false;
        }
        if (this.allowedProcMountTypes != null ? !this.allowedProcMountTypes.equals(that.allowedProcMountTypes) : that.allowedProcMountTypes != null) {
            return false;
        }
        if (this.allowedUnsafeSysctls != null ? !this.allowedUnsafeSysctls.equals(that.allowedUnsafeSysctls) : that.allowedUnsafeSysctls != null) {
            return false;
        }
        if (this.defaultAddCapabilities != null ? !this.defaultAddCapabilities.equals(that.defaultAddCapabilities) : that.defaultAddCapabilities != null) {
            return false;
        }
        if (this.defaultAllowPrivilegeEscalation != null ? !this.defaultAllowPrivilegeEscalation.equals(that.defaultAllowPrivilegeEscalation) : that.defaultAllowPrivilegeEscalation != null) {
            return false;
        }
        if (this.forbiddenSysctls != null ? !this.forbiddenSysctls.equals(that.forbiddenSysctls) : that.forbiddenSysctls != null) {
            return false;
        }
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.hostIPC != null ? !this.hostIPC.equals(that.hostIPC) : that.hostIPC != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.hostPID != null ? !this.hostPID.equals(that.hostPID) : that.hostPID != null) {
            return false;
        }
        if (this.hostPorts != null ? !this.hostPorts.equals(that.hostPorts) : that.hostPorts != null) {
            return false;
        }
        if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) {
            return false;
        }
        if (this.readOnlyRootFilesystem != null ? !this.readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) : that.readOnlyRootFilesystem != null) {
            return false;
        }
        if (this.requiredDropCapabilities != null ? !this.requiredDropCapabilities.equals(that.requiredDropCapabilities) : that.requiredDropCapabilities != null) {
            return false;
        }
        if (this.runAsGroup != null ? !this.runAsGroup.equals(that.runAsGroup) : that.runAsGroup != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.runtimeClass != null ? !this.runtimeClass.equals(that.runtimeClass) : that.runtimeClass != null) {
            return false;
        }
        if (this.seLinux != null ? !this.seLinux.equals(that.seLinux) : that.seLinux != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public int hashCode() {
        return Objects.hash(this.allowPrivilegeEscalation, this.allowedCSIDrivers, this.allowedCapabilities, this.allowedFlexVolumes, this.allowedHostPaths, this.allowedProcMountTypes, this.allowedUnsafeSysctls, this.defaultAddCapabilities, this.defaultAllowPrivilegeEscalation, this.forbiddenSysctls, this.fsGroup, this.hostIPC, this.hostNetwork, this.hostPID, this.hostPorts, this.privileged, this.readOnlyRootFilesystem, this.requiredDropCapabilities, this.runAsGroup, this.runAsUser, this.runtimeClass, this.seLinux, this.supplementalGroups, this.volumes, super.hashCode());
    }

    public class SupplementalGroupsNestedImpl<N>
    extends SupplementalGroupsStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>>
    implements PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>,
    Nested<N> {
        private final SupplementalGroupsStrategyOptionsBuilder builder;

        SupplementalGroupsNestedImpl(SupplementalGroupsStrategyOptions item) {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
        }

        SupplementalGroupsNestedImpl() {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.withSupplementalGroups(this.builder.build());
        }

        @Override
        public N endSupplementalGroups() {
            return this.and();
        }
    }

    public class SeLinuxNestedImpl<N>
    extends SELinuxStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.SeLinuxNested<N>>
    implements PodSecurityPolicySpecFluent.SeLinuxNested<N>,
    Nested<N> {
        private final SELinuxStrategyOptionsBuilder builder;

        SeLinuxNestedImpl(SELinuxStrategyOptions item) {
            this.builder = new SELinuxStrategyOptionsBuilder(this, item);
        }

        SeLinuxNestedImpl() {
            this.builder = new SELinuxStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.withSeLinux(this.builder.build());
        }

        @Override
        public N endSeLinux() {
            return this.and();
        }
    }

    public class RuntimeClassNestedImpl<N>
    extends RuntimeClassStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.RuntimeClassNested<N>>
    implements PodSecurityPolicySpecFluent.RuntimeClassNested<N>,
    Nested<N> {
        private final RuntimeClassStrategyOptionsBuilder builder;

        RuntimeClassNestedImpl(RuntimeClassStrategyOptions item) {
            this.builder = new RuntimeClassStrategyOptionsBuilder(this, item);
        }

        RuntimeClassNestedImpl() {
            this.builder = new RuntimeClassStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.withRuntimeClass(this.builder.build());
        }

        @Override
        public N endRuntimeClass() {
            return this.and();
        }
    }

    public class RunAsUserNestedImpl<N>
    extends RunAsUserStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.RunAsUserNested<N>>
    implements PodSecurityPolicySpecFluent.RunAsUserNested<N>,
    Nested<N> {
        private final RunAsUserStrategyOptionsBuilder builder;

        RunAsUserNestedImpl(RunAsUserStrategyOptions item) {
            this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }

        RunAsUserNestedImpl() {
            this.builder = new RunAsUserStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.withRunAsUser(this.builder.build());
        }

        @Override
        public N endRunAsUser() {
            return this.and();
        }
    }

    public class RunAsGroupNestedImpl<N>
    extends RunAsGroupStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.RunAsGroupNested<N>>
    implements PodSecurityPolicySpecFluent.RunAsGroupNested<N>,
    Nested<N> {
        private final RunAsGroupStrategyOptionsBuilder builder;

        RunAsGroupNestedImpl(RunAsGroupStrategyOptions item) {
            this.builder = new RunAsGroupStrategyOptionsBuilder(this, item);
        }

        RunAsGroupNestedImpl() {
            this.builder = new RunAsGroupStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.withRunAsGroup(this.builder.build());
        }

        @Override
        public N endRunAsGroup() {
            return this.and();
        }
    }

    public class HostPortsNestedImpl<N>
    extends HostPortRangeFluentImpl<PodSecurityPolicySpecFluent.HostPortsNested<N>>
    implements PodSecurityPolicySpecFluent.HostPortsNested<N>,
    Nested<N> {
        private final HostPortRangeBuilder builder;
        private final int index;

        HostPortsNestedImpl(int index, HostPortRange item) {
            this.index = index;
            this.builder = new HostPortRangeBuilder(this, item);
        }

        HostPortsNestedImpl() {
            this.index = -1;
            this.builder = new HostPortRangeBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.setToHostPorts(this.index, this.builder.build());
        }

        @Override
        public N endHostPort() {
            return this.and();
        }
    }

    public class FsGroupNestedImpl<N>
    extends FSGroupStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.FsGroupNested<N>>
    implements PodSecurityPolicySpecFluent.FsGroupNested<N>,
    Nested<N> {
        private final FSGroupStrategyOptionsBuilder builder;

        FsGroupNestedImpl(FSGroupStrategyOptions item) {
            this.builder = new FSGroupStrategyOptionsBuilder(this, item);
        }

        FsGroupNestedImpl() {
            this.builder = new FSGroupStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.withFsGroup(this.builder.build());
        }

        @Override
        public N endFsGroup() {
            return this.and();
        }
    }

    public class AllowedHostPathsNestedImpl<N>
    extends AllowedHostPathFluentImpl<PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>>
    implements PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>,
    Nested<N> {
        private final AllowedHostPathBuilder builder;
        private final int index;

        AllowedHostPathsNestedImpl(int index, AllowedHostPath item) {
            this.index = index;
            this.builder = new AllowedHostPathBuilder(this, item);
        }

        AllowedHostPathsNestedImpl() {
            this.index = -1;
            this.builder = new AllowedHostPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.setToAllowedHostPaths(this.index, this.builder.build());
        }

        @Override
        public N endAllowedHostPath() {
            return this.and();
        }
    }

    public class AllowedFlexVolumesNestedImpl<N>
    extends AllowedFlexVolumeFluentImpl<PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>>
    implements PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>,
    Nested<N> {
        private final AllowedFlexVolumeBuilder builder;
        private final int index;

        AllowedFlexVolumesNestedImpl(int index, AllowedFlexVolume item) {
            this.index = index;
            this.builder = new AllowedFlexVolumeBuilder(this, item);
        }

        AllowedFlexVolumesNestedImpl() {
            this.index = -1;
            this.builder = new AllowedFlexVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.setToAllowedFlexVolumes(this.index, this.builder.build());
        }

        @Override
        public N endAllowedFlexVolume() {
            return this.and();
        }
    }

    public class AllowedCSIDriversNestedImpl<N>
    extends AllowedCSIDriverFluentImpl<PodSecurityPolicySpecFluent.AllowedCSIDriversNested<N>>
    implements PodSecurityPolicySpecFluent.AllowedCSIDriversNested<N>,
    Nested<N> {
        private final AllowedCSIDriverBuilder builder;
        private final int index;

        AllowedCSIDriversNestedImpl(int index, AllowedCSIDriver item) {
            this.index = index;
            this.builder = new AllowedCSIDriverBuilder(this, item);
        }

        AllowedCSIDriversNestedImpl() {
            this.index = -1;
            this.builder = new AllowedCSIDriverBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.setToAllowedCSIDrivers(this.index, this.builder.build());
        }

        @Override
        public N endAllowedCSIDriver() {
            return this.and();
        }
    }
}

