/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.annotations;

import io.strimzi.api.annotations.VersionRange;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiVersion
implements Comparable<ApiVersion> {
    public static final Pattern PATTERN = Pattern.compile("v([0-9]+)((alpha|beta)([0-9]+))?");
    public static final ApiVersion V1ALPHA1 = ApiVersion.parse("v1alpha1");
    public static final ApiVersion V1BETA1 = ApiVersion.parse("v1beta1");
    public static final ApiVersion V1BETA2 = ApiVersion.parse("v1beta2");
    public static final ApiVersion V1 = ApiVersion.parse("v1");
    public static final VersionRange<ApiVersion> V1BETA2_PLUS = ApiVersion.parseRange("v1beta2+");
    public static final VersionRange<ApiVersion> V1BETA1_PLUS = ApiVersion.parseRange("v1beta1+");
    private final short major;
    private final Stability stability;
    private final short minor;

    public ApiVersion(short major, Stability stability, short minor) {
        if (major < 0 || minor < 0) {
            throw new RuntimeException();
        }
        this.major = major;
        this.stability = stability;
        this.minor = minor;
    }

    private static Matcher matcher(String apiVersion) {
        return PATTERN.matcher(apiVersion);
    }

    public static boolean isVersion(String apiVersion) {
        return ApiVersion.matcher(apiVersion).matches();
    }

    public static ApiVersion parse(String apiVersion) {
        short minor;
        Stability stability;
        Matcher matcher = ApiVersion.matcher(apiVersion);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version " + apiVersion);
        }
        short major = Short.parseShort(matcher.group(1));
        String alphaBeta = matcher.group(3);
        if (matcher.groupCount() > 1 && alphaBeta != null) {
            if ("alpha".equals(alphaBeta)) {
                stability = Stability.ALPHA;
            } else if ("beta".equals(alphaBeta)) {
                stability = Stability.BETA;
            } else {
                throw new IllegalStateException(alphaBeta);
            }
            minor = Short.parseShort(matcher.group(4));
        } else {
            stability = Stability.STABLE;
            minor = 0;
        }
        return new ApiVersion(major, stability, minor);
    }

    public static VersionRange<ApiVersion> parseRange(String s) {
        return VersionRange.parse(s, new VersionRange.VersionParser<ApiVersion>(){

            @Override
            public ApiVersion parse(String version) throws IllegalArgumentException {
                return ApiVersion.parse(version);
            }

            @Override
            public boolean isValid(String version) {
                return ApiVersion.isVersion(version);
            }
        });
    }

    @Override
    public int compareTo(ApiVersion o) {
        int cmp = Integer.compare(this.major, o.major);
        if (cmp == 0) {
            cmp = this.stability.compareTo(o.stability);
        }
        if (cmp == 0) {
            cmp = Integer.compare(this.minor, o.minor);
        }
        return cmp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiVersion that = (ApiVersion)o;
        return this.major == that.major && this.stability == that.stability && this.minor == that.minor;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.major, this.stability, this.minor});
    }

    public String toString() {
        return "v" + this.major + (this.stability == Stability.ALPHA ? "alpha" : (this.stability == Stability.BETA ? "beta" : "")) + (this.stability == Stability.STABLE ? "" : Integer.toString(this.minor));
    }

    static enum Stability {
        ALPHA,
        BETA,
        STABLE;

    }
}

