/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.crdgenerator;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.CustomResource;
import io.strimzi.api.annotations.ApiVersion;
import io.strimzi.api.annotations.KubeVersion;
import io.strimzi.api.annotations.VersionRange;
import io.strimzi.crdgenerator.PropertyType;
import io.strimzi.crdgenerator.annotations.Alternative;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

class Property
implements AnnotatedElement {
    private final String name;
    private final Class<?> owner;
    private AnnotatedElement a;
    private Member m;
    private PropertyType type;

    public Property(Method method) {
        this.name = Property.propertyName(method);
        this.owner = method.getDeclaringClass();
        this.a = method;
        this.m = method;
        this.type = new PropertyType(method.getReturnType(), method.getGenericReturnType());
    }

    public Property(Field field) {
        this.name = field.getName();
        this.owner = field.getDeclaringClass();
        this.a = field;
        this.m = field;
        this.type = new PropertyType(field.getType(), field.getGenericType());
    }

    public String getName() {
        return this.name;
    }

    private static boolean isGetterName(Method method) {
        String name = method.getName();
        return name.startsWith("get") && name.length() > 3 && Property.isReallyGetterName(method, name) || name.startsWith("is") && name.length() > 2 && method.getReturnType().equals(Boolean.TYPE);
    }

    private static boolean isReallyGetterName(Method method, String name) {
        return !"getClass".equals(name) && (!"getDeclaringClass".equals(name) || !Enum.class.equals(method.getDeclaringClass()));
    }

    private static String propertyName(Method getterMethod) {
        JsonProperty jsonProperty = getterMethod.getAnnotation(JsonProperty.class);
        if (jsonProperty != null && !jsonProperty.value().isEmpty()) {
            return jsonProperty.value();
        }
        String name = getterMethod.getName();
        if (name.startsWith("get") && name.length() > 3) {
            return name.substring(3, 4).toLowerCase(Locale.ENGLISH) + name.substring(4);
        }
        if (name.startsWith("is") && name.length() > 2 && getterMethod.getReturnType().equals(Boolean.TYPE)) {
            return name.substring(2, 3).toLowerCase(Locale.ENGLISH) + name.substring(3);
        }
        return null;
    }

    static Map<String, Property> properties(ApiVersion crApiVersion, Class<?> crdClass) {
        TreeMap<String, Property> unordered = new TreeMap<String, Property>();
        for (Method method : crdClass.getMethods()) {
            Property property;
            Property existing;
            boolean isNotIgnored;
            Class<?> returnType = method.getReturnType();
            boolean isGetter = Property.isGetterName(method) && method.getParameterCount() == 0 && !returnType.equals(Void.TYPE);
            boolean isNotInherited = (!Property.hasMethod(CustomResource.class, method) || method.getName().equals("getSpec") || method.getName().equals("getStatus")) && !Property.hasMethod(HasMetadata.class, method) && !method.isBridge();
            boolean bl = isNotIgnored = !Property.hasJsonIgnore(method) && !Property.hasAnyGetter(method) && Property.isPresentInVersion(crApiVersion, method);
            if (!isGetter || !isNotInherited || !isNotIgnored || (existing = unordered.put((property = new Property(method)).getName(), property)) == null) continue;
            throw new RuntimeException("Duplicate property " + method.getName());
        }
        for (AccessibleObject accessibleObject : crdClass.getFields()) {
            Property property;
            Property existing;
            boolean isNotIgnored;
            boolean isProperty = !Modifier.isStatic(((Field)accessibleObject).getModifiers());
            boolean bl = isNotIgnored = !accessibleObject.isAnnotationPresent(JsonIgnore.class) && Property.isPresentInVersion(crApiVersion, accessibleObject);
            if (!isProperty || !isNotIgnored || (existing = unordered.put((property = new Property((Field)accessibleObject)).getName(), property)) == null) continue;
            throw new RuntimeException("Duplicate property " + ((Field)accessibleObject).getName());
        }
        JsonPropertyOrder order = crdClass.getAnnotation(JsonPropertyOrder.class);
        return Property.sortedProperties(order != null ? order.value() : null, unordered);
    }

    private static boolean isPresentInVersion(ApiVersion crApiVersion, AnnotatedElement method) {
        PresentInVersions annotation = method.getAnnotation(PresentInVersions.class);
        if (annotation == null) {
            return true;
        }
        return ApiVersion.parseRange(annotation.value()).contains(crApiVersion);
    }

    private static boolean hasAnyGetter(Method method) {
        JsonAnyGetter annotation = Property.findAnnotation(JsonAnyGetter.class, method, method.getDeclaringClass());
        return annotation != null && annotation.enabled();
    }

    private static boolean hasAnySetter(Method method) {
        JsonAnySetter annotation = Property.findAnnotation(JsonAnySetter.class, method, method.getDeclaringClass());
        return annotation != null && annotation.enabled();
    }

    private static boolean hasJsonIgnore(Method method) {
        JsonIgnore annotation = Property.findAnnotation(JsonIgnore.class, method, method.getDeclaringClass());
        return annotation != null && annotation.value();
    }

    private static <A extends Annotation> A findAnnotation(Class<A> annotationClass, Method method, Class<?> c) {
        do {
            A a;
            if ((a = Property.methodAnnotation(annotationClass, method, c)) != null) {
                return a;
            }
            for (Class<?> iface : c.getInterfaces()) {
                a = Property.findAnnotation(annotationClass, method, iface);
                if (a == null) continue;
                return a;
            }
        } while ((c = c.getSuperclass()) != null);
        return null;
    }

    private static <A extends Annotation> A methodAnnotation(Class<A> annotationClass, Method method, Class<?> lookupClass) {
        try {
            Method m = lookupClass.getMethod(method.getName(), method.getParameterTypes());
            A a = m.getAnnotation(annotationClass);
            if (a != null) {
                return a;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isAnySetter(Method method) {
        return method.getParameterCount() == 2 && method.getReturnType().equals(Void.TYPE) && method.getParameterTypes()[0].equals(String.class) && method.getParameterTypes()[1].equals(Object.class) && !Modifier.isStatic(method.getModifiers());
    }

    private static boolean isAnyGetter(Method method) {
        return method.getParameterCount() == 0 && !method.getReturnType().equals(Void.TYPE) && !Modifier.isStatic(method.getModifiers());
    }

    static Map<String, Property> sortedProperties(String[] order, TreeMap<String, Property> unordered) {
        AbstractMap result;
        if (order != null) {
            LinkedHashMap<String, Property> ordered = new LinkedHashMap<String, Property>(unordered.size());
            if (order.length > 0) {
                for (String propertyName : order) {
                    Property property = unordered.remove(propertyName);
                    if (property == null) continue;
                    ordered.put(propertyName, property);
                }
            }
            ordered.putAll(unordered);
            result = ordered;
        } else {
            result = unordered;
        }
        return Collections.unmodifiableMap(result);
    }

    static boolean hasAnyGetterAndAnySetter(Class<?> crdClass) {
        boolean anyGetter = false;
        boolean anySetter = false;
        for (Method method : crdClass.getMethods()) {
            if (Property.isAnySetter(method) && Property.hasAnySetter(method)) {
                anySetter = true;
            }
            if (Property.isAnyGetter(method) && Property.hasAnyGetter(method)) {
                anyGetter = true;
            }
            if (anyGetter && anySetter) break;
        }
        return anyGetter && anySetter;
    }

    private static boolean hasMethod(Class<?> c, Method m) {
        try {
            if (!c.isAssignableFrom(m.getDeclaringClass())) {
                return false;
            }
            c.getDeclaredMethod(m.getName(), m.getParameterTypes());
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static boolean isPolymorphic(Class<?> cls) {
        return cls.isAnnotationPresent(JsonSubTypes.class);
    }

    static Map<Class<?>, String> subtypeMap(Class<?> crdClass) {
        JsonSubTypes subtypes = crdClass.getAnnotation(JsonSubTypes.class);
        if (subtypes != null) {
            LinkedHashMap result = new LinkedHashMap(subtypes.value().length);
            for (JsonSubTypes.Type type : subtypes.value()) {
                result.put(type.value(), type.name());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    static List<Class<?>> subtypes(Class<?> crdClass) {
        JsonSubTypes subtypes = crdClass.getAnnotation(JsonSubTypes.class);
        if (subtypes != null) {
            ArrayList result = new ArrayList(subtypes.value().length);
            for (JsonSubTypes.Type type : subtypes.value()) {
                result.add(type.value());
            }
            return result;
        }
        return Collections.emptyList();
    }

    static List<String> subtypeNames(Class<?> crdClass) {
        JsonSubTypes subtypes = crdClass.getAnnotation(JsonSubTypes.class);
        if (subtypes != null) {
            ArrayList<String> result = new ArrayList<String>(subtypes.value().length);
            for (JsonSubTypes.Type type : subtypes.value()) {
                result.add(type.name());
            }
            return result;
        }
        return Collections.emptyList();
    }

    static String discriminator(Class<?> returnType) {
        JsonTypeInfo annotation;
        if (returnType != null && (annotation = returnType.getAnnotation(JsonTypeInfo.class)) != null) {
            return annotation.property();
        }
        return null;
    }

    boolean isDiscriminator() {
        return this.getName().equals(Property.discriminator(this.m.getDeclaringClass()));
    }

    List<Property> getAlternatives(ApiVersion crApiVersion, VersionRange<KubeVersion> kubeVersions) {
        List<Property> alternatives = Property.properties(crApiVersion, this.getType().getType()).values().stream().filter(p -> {
            Alternative annotation = p.getAnnotation(Alternative.class);
            return crApiVersion == null || annotation != null && ApiVersion.parseRange(annotation.apiVersion()).contains(crApiVersion);
        }).collect(Collectors.toList());
        return alternatives;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.a.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.a.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.a.getDeclaredAnnotations();
    }

    public Class<?> getDeclaringClass() {
        return this.m.getDeclaringClass();
    }

    public PropertyType getType() {
        return this.type;
    }

    public String toString() {
        return this.owner.getName() + "." + this.name;
    }
}

