/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvVarConfigProvider
implements ConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EnvVarConfigProvider.class);
    private final Map<String, String> envVars;

    public EnvVarConfigProvider() {
        this.envVars = System.getenv();
    }

    EnvVarConfigProvider(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    public void configure(Map<String, ?> map) {
        LOG.info("Configuring EnvVar config provider: {}", map);
    }

    public ConfigData get(String path) {
        return new ConfigData(this.envVars);
    }

    public ConfigData get(String path, Set<String> keys) {
        HashMap<String, String> vars = new HashMap<String, String>(this.envVars);
        vars.keySet().retainAll(keys);
        return new ConfigData(vars);
    }

    public void close() {
        LOG.info("Closing EnvVar config provider");
    }
}

