/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.client;

import io.strimzi.kafka.oauth.client.ClientConfig;
import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigUtil;
import io.strimzi.kafka.oauth.common.JSONUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.OAuthAuthenticator;
import io.strimzi.kafka.oauth.common.TokenInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasClientOauthLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private static Logger log = LoggerFactory.getLogger(JaasClientOauthLoginCallbackHandler.class);
    private ClientConfig config = new ClientConfig();
    private String token;
    private String refreshToken;
    private String clientId;
    private String clientSecret;
    private URI tokenEndpoint;
    private String usernameClaim;
    private SSLSocketFactory socketFactory;
    private HostnameVerifier hostnameVerifier;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException("Unexpected SASL mechanism: " + saslMechanism);
        }
        for (AppConfigurationEntry e : jaasConfigEntries) {
            Properties p = new Properties();
            p.putAll(e.getOptions());
            this.config = new ClientConfig(p);
        }
        this.token = this.config.getValue("oauth.access.token");
        if (this.token == null) {
            String endpoint = this.config.getValue("oauth.token.endpoint.uri");
            if (endpoint == null) {
                throw new RuntimeException("Access Token not specified ('oauth.access.token'). OAuth2 Token Endpoint ('oauth.token.endpoint.uri') should then be set.");
            }
            try {
                this.tokenEndpoint = new URI(endpoint);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Specified token endpoint uri is invalid: " + endpoint);
            }
            this.refreshToken = this.config.getValue("oauth.refresh.token");
            this.clientId = this.config.getValue("oauth.client.id");
            this.clientSecret = this.config.getValue("oauth.client.secret");
            if (this.clientId == null) {
                throw new RuntimeException("No client id specified ('oauth.client.id')");
            }
            if (this.refreshToken == null && this.clientSecret == null) {
                throw new RuntimeException("No access token, refresh token, nor client secret specified");
            }
            this.socketFactory = ConfigUtil.createSSLFactory((Config)this.config);
            this.hostnameVerifier = ConfigUtil.createHostnameVerifier((Config)this.config);
        }
        this.usernameClaim = this.config.getValue("oauth.username.claim", "sub");
        if ("sub".equals(this.usernameClaim)) {
            this.usernameClaim = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Configured JaasClientOauthLoginCallbackHandler:\n    token: " + LogUtil.mask((String)this.token) + "\n    refreshToken: " + LogUtil.mask((String)this.refreshToken) + "\n    tokenEndpointUri: " + this.tokenEndpoint + "\n    clientId: " + this.clientId + "\n    clientSecret: " + LogUtil.mask((String)this.clientSecret) + "\n    usernameClaim: " + this.usernameClaim);
        }
    }

    public void close() {
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof OAuthBearerTokenCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            this.handleCallback((OAuthBearerTokenCallback)callback);
        }
    }

    private void handleCallback(OAuthBearerTokenCallback callback) throws IOException {
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had a token already");
        }
        TokenInfo result = null;
        if (this.token != null) {
            result = OAuthAuthenticator.loginWithAccessToken((String)this.token);
        } else if (this.refreshToken != null) {
            result = OAuthAuthenticator.loginWithRefreshToken((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.refreshToken, (String)this.clientId, (String)this.clientSecret);
        } else if (this.clientSecret != null) {
            result = OAuthAuthenticator.loginWithClientSecret((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.clientId, (String)this.clientSecret);
        } else {
            throw new IllegalStateException("Invalid oauth client configuration - no credentials");
        }
        final TokenInfo finalResult = result;
        callback.token(new OAuthBearerToken(){

            public String value() {
                return finalResult.token();
            }

            public Set<String> scope() {
                return finalResult.scope();
            }

            public long lifetimeMs() {
                return finalResult.expiresAtMs();
            }

            public String principalName() {
                return JaasClientOauthLoginCallbackHandler.this.usernameClaim != null ? JSONUtil.getClaimFromJWT((String)JaasClientOauthLoginCallbackHandler.this.usernameClaim, (Object)finalResult.payload()) : finalResult.subject();
            }

            public Long startTimeMs() {
                return finalResult.issuedAtMs();
            }
        });
    }
}

