/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.client;

import io.strimzi.kafka.oauth.client.ClientConfig;
import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigUtil;
import io.strimzi.kafka.oauth.common.DeprecationUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.OAuthAuthenticator;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.TokenInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasClientOauthLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private static Logger log = LoggerFactory.getLogger(JaasClientOauthLoginCallbackHandler.class);
    private ClientConfig config = new ClientConfig();
    private String token;
    private String refreshToken;
    private String clientId;
    private String clientSecret;
    private String scope;
    private String audience;
    private URI tokenEndpoint;
    private boolean isJwt;
    private int maxTokenExpirySeconds;
    private PrincipalExtractor principalExtractor;
    private SSLSocketFactory socketFactory;
    private HostnameVerifier hostnameVerifier;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException("Unexpected SASL mechanism: " + saslMechanism);
        }
        for (AppConfigurationEntry e : jaasConfigEntries) {
            Properties p = new Properties();
            p.putAll(e.getOptions());
            this.config = new ClientConfig(p);
        }
        this.token = this.config.getValue("oauth.access.token");
        if (this.token == null) {
            String endpoint = this.config.getValue("oauth.token.endpoint.uri");
            if (endpoint == null) {
                throw new RuntimeException("Access Token not specified (OAUTH_ACCESS_TOKEN). OAuth2 Token Endpoint (OAUTH_TOKEN_ENDPOINT_URI) should then be set.");
            }
            try {
                this.tokenEndpoint = new URI(endpoint);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Specified token endpoint uri is invalid: " + endpoint);
            }
            this.refreshToken = this.config.getValue("oauth.refresh.token");
            this.clientId = this.config.getValue("oauth.client.id");
            this.clientSecret = this.config.getValue("oauth.client.secret");
            if (this.clientId == null) {
                throw new RuntimeException("No client id specified (OAUTH_CLIENT_ID)");
            }
            if (this.refreshToken == null && this.clientSecret == null) {
                throw new RuntimeException("No access token, refresh token, nor client secret specified");
            }
            this.scope = this.config.getValue("oauth.scope");
            this.audience = this.config.getValue("oauth.audience");
            this.socketFactory = ConfigUtil.createSSLFactory((Config)this.config);
            this.hostnameVerifier = ConfigUtil.createHostnameVerifier((Config)this.config);
        }
        this.principalExtractor = new PrincipalExtractor(this.config.getValue("oauth.username.claim"), this.config.getValue("oauth.fallback.username.claim"), this.config.getValue("oauth.fallback.username.prefix"));
        this.isJwt = DeprecationUtil.isAccessTokenJwt((Config)this.config, (Logger)log, null);
        if (!this.isJwt && this.principalExtractor.isConfigured()) {
            log.warn("Token is not JWT (OAUTH_ACCESS_TOKEN_IS_JWT=false) - custom username claim configuration will be ignored (OAUTH_USERNAME_CLAIM, OAUTH_FALLBACK_USERNAME_CLAIM, OAUTH_FALLBACK_USERNAME_PREFIX)");
        }
        this.maxTokenExpirySeconds = this.config.getValueAsInt("oauth.max.token.expiry.seconds", -1);
        if (this.maxTokenExpirySeconds > 0 && this.maxTokenExpirySeconds < 60) {
            throw new RuntimeException("Invalid value configured for OAUTH_MAX_TOKEN_EXPIRY_SECONDS: " + this.maxTokenExpirySeconds + " (should be at least 60)");
        }
        if (log.isDebugEnabled()) {
            log.debug("Configured JaasClientOauthLoginCallbackHandler:\n    token: " + LogUtil.mask((String)this.token) + "\n    refreshToken: " + LogUtil.mask((String)this.refreshToken) + "\n    tokenEndpointUri: " + this.tokenEndpoint + "\n    clientId: " + this.clientId + "\n    clientSecret: " + LogUtil.mask((String)this.clientSecret) + "\n    scope: " + this.scope + "\n    audience: " + this.audience + "\n    isJwt: " + this.isJwt + "\n    maxTokenExpirySeconds: " + this.maxTokenExpirySeconds + "\n    principalExtractor: " + this.principalExtractor);
        }
    }

    public void close() {
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof OAuthBearerTokenCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            this.handleCallback((OAuthBearerTokenCallback)callback);
        }
    }

    private void handleCallback(OAuthBearerTokenCallback callback) throws IOException {
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had a token already");
        }
        TokenInfo result = null;
        if (this.token != null) {
            result = OAuthAuthenticator.loginWithAccessToken((String)this.token, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor);
        } else if (this.refreshToken != null) {
            result = OAuthAuthenticator.loginWithRefreshToken((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.refreshToken, (String)this.clientId, (String)this.clientSecret, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor, (String)this.scope, (String)this.audience);
        } else if (this.clientSecret != null) {
            result = OAuthAuthenticator.loginWithClientSecret((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.clientId, (String)this.clientSecret, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor, (String)this.scope, (String)this.audience);
        } else {
            throw new IllegalStateException("Invalid oauth client configuration - no credentials");
        }
        final TokenInfo finalResult = result;
        callback.token(new OAuthBearerToken(){

            public String value() {
                return finalResult.token();
            }

            public Set<String> scope() {
                return finalResult.scope();
            }

            public long lifetimeMs() {
                long maxExpiresAt = finalResult.issuedAtMs() + (long)JaasClientOauthLoginCallbackHandler.this.maxTokenExpirySeconds * 1000L;
                if (JaasClientOauthLoginCallbackHandler.this.maxTokenExpirySeconds > 0 && finalResult.expiresAtMs() > maxExpiresAt) {
                    return maxExpiresAt;
                }
                return finalResult.expiresAtMs();
            }

            public String principalName() {
                return finalResult.principal();
            }

            public Long startTimeMs() {
                return finalResult.issuedAtMs();
            }
        });
    }
}

