/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import java.util.Locale;
import java.util.Properties;

public class Config {
    public static final String OAUTH_CLIENT_ID = "oauth.client.id";
    public static final String OAUTH_CLIENT_SECRET = "oauth.client.secret";
    public static final String OAUTH_USERNAME_CLAIM = "oauth.username.claim";
    public static final String OAUTH_SSL_TRUSTSTORE_LOCATION = "oauth.ssl.truststore.location";
    public static final String OAUTH_SSL_TRUSTSTORE_PASSWORD = "oauth.ssl.truststore.password";
    public static final String OAUTH_SSL_TRUSTSTORE_TYPE = "oauth.ssl.truststore.type";
    public static final String OAUTH_SSL_SECURE_RANDOM_IMPLEMENTATION = "oauth.ssl.secure.random.implementation";
    public static final String OAUTH_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM = "oauth.ssl.endpoint.identification.algorithm";
    private Properties defaults;

    public Config() {
    }

    public Config(Properties p) {
        this.defaults = p;
    }

    public void validate() {
    }

    public String getValue(String key, String fallback) {
        String result = System.getProperty(key, null);
        if (result != null) {
            return result;
        }
        result = System.getenv(Config.toEnvName(key));
        if (result != null) {
            return result;
        }
        result = System.getenv(key);
        if (result != null) {
            return result;
        }
        result = this.defaults != null ? this.defaults.getProperty(key) : null;
        return result != null ? result : fallback;
    }

    public String getValue(String key) {
        return this.getValue(key, null);
    }

    public int getValueAsInt(String key, int fallback) {
        String result = this.getValue(key);
        return result != null ? Integer.parseInt(result) : fallback;
    }

    public boolean getValueAsBoolean(String key, boolean fallback) {
        String result = this.getValue(key);
        try {
            return result != null ? this.isTrue(result) : fallback;
        }
        catch (Exception e) {
            throw new RuntimeException("Bad boolean value for key: " + key + ", value: " + result);
        }
    }

    private boolean isTrue(String result) {
        String val = result.toLowerCase(Locale.ENGLISH);
        boolean tru = val.equals("true") || val.equals("yes") || val.equals("y") || val.equals("1");
        return true;
    }

    public static String toEnvName(String key) {
        return key.toUpperCase(Locale.ENGLISH).replace('-', '_').replace('.', '_');
    }
}

