/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.keycloak.util.JsonSerialization;

public class JSONUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T> T readJSON(InputStream is, Class<T> clazz) throws IOException {
        return (T)MAPPER.readValue(is, clazz);
    }

    public static String getClaimFromJWT(String claim, Object token) {
        try {
            String jsonString = JsonSerialization.writeValueAsString((Object)token);
            JsonNode node = (JsonNode)JsonSerialization.readValue((String)jsonString, JsonNode.class);
            JsonNode claimNode = node.get(claim);
            if (claimNode == null) {
                throw new RuntimeException("Access token contains no '" + claim + "' claim: " + jsonString);
            }
            return claimNode.asText();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read '" + claim + "' claim from token", e);
        }
    }
}

