/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.representations.AccessToken;

public class TokenInfo {
    private String token;
    private Set<String> scopes = new HashSet<String>();
    private long expiresAt;
    private String subject;
    private long issuedAt;
    private AccessToken payload;

    public TokenInfo(AccessToken payload, String token) {
        this(token, payload.getScope(), payload.getSubject(), (long)payload.getIssuedAt() * 1000L, (long)payload.getExpiration() * 1000L);
        this.payload = payload;
    }

    public TokenInfo(String token, String scope, String subject, long issuedAtMs, long expiresAtMs) {
        String[] parsedScopes;
        this.token = token;
        this.subject = subject;
        this.issuedAt = issuedAtMs;
        this.expiresAt = expiresAtMs;
        for (String s : parsedScopes = scope != null ? scope.split(" ") : new String[]{}) {
            this.scopes.add(s);
        }
        this.scopes = Collections.unmodifiableSet(this.scopes);
    }

    public String token() {
        return this.token;
    }

    public Set<String> scope() {
        return this.scopes;
    }

    public long expiresAtMs() {
        return this.expiresAt;
    }

    public String subject() {
        return this.subject;
    }

    public long issuedAtMs() {
        return this.issuedAt;
    }

    public AccessToken payload() {
        return this.payload;
    }
}

