/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TokenInfo {
    public static final String SCOPE = "scope";
    public static final String IAT = "iat";
    public static final String EXP = "exp";
    public static final String ISS = "iss";
    public static final String TYP = "typ";
    public static final String TOKEN_TYPE = "token_type";
    public static final String AUD = "aud";
    private String token;
    private Set<String> scopes = new HashSet<String>();
    private long expiresAt;
    private String principal;
    private Set<String> groups;
    private long issuedAt;
    private ObjectNode payload;

    public TokenInfo(JsonNode payload, String token, String principal) {
        this(payload, token, principal, null);
    }

    public TokenInfo(JsonNode payload, String token, String principal, Set<String> groups) {
        this(token, payload.has(SCOPE) ? payload.get(SCOPE).asText() : null, principal, groups, payload.has(IAT) ? (long)payload.get(IAT).asInt(0) * 1000L : 0L, (long)payload.get(EXP).asInt(0) * 1000L);
        if (!(payload instanceof ObjectNode)) {
            throw new IllegalArgumentException("Unexpected JSON Node type (not ObjectNode): " + payload.getClass());
        }
        this.payload = (ObjectNode)payload;
    }

    public TokenInfo(String token, String scope, String principal, Set<String> groups, long issuedAtMs, long expiresAtMs) {
        String[] parsedScopes;
        this.token = token;
        this.principal = principal;
        this.groups = groups != null ? Collections.unmodifiableSet(groups) : null;
        this.issuedAt = issuedAtMs;
        this.expiresAt = expiresAtMs;
        for (String s : parsedScopes = scope != null ? scope.split(" ") : new String[]{}) {
            this.scopes.add(s);
        }
        this.scopes = Collections.unmodifiableSet(this.scopes);
    }

    public String token() {
        return this.token;
    }

    public Set<String> scope() {
        return this.scopes;
    }

    public long expiresAtMs() {
        return this.expiresAt;
    }

    public String principal() {
        return this.principal;
    }

    public Set<String> groups() {
        return this.groups;
    }

    public long issuedAtMs() {
        return this.issuedAt;
    }

    public ObjectNode payload() {
        return this.payload;
    }
}

