/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.validator;

import com.fasterxml.jackson.databind.JsonNode;
import io.strimzi.kafka.oauth.common.HttpUtil;
import io.strimzi.kafka.oauth.common.JSONUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.OAuthAuthenticator;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.TimeUtil;
import io.strimzi.kafka.oauth.common.TokenInfo;
import io.strimzi.kafka.oauth.jsonpath.JsonPathFilterQuery;
import io.strimzi.kafka.oauth.jsonpath.JsonPathQuery;
import io.strimzi.kafka.oauth.validator.TokenExpiredException;
import io.strimzi.kafka.oauth.validator.TokenValidationException;
import io.strimzi.kafka.oauth.validator.TokenValidator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthIntrospectionValidator
implements TokenValidator {
    private static final Logger log = LoggerFactory.getLogger(OAuthIntrospectionValidator.class);
    private final URI introspectionURI;
    private final String validIssuerURI;
    private final URI userInfoURI;
    private final String validTokenType;
    private final String clientId;
    private final String clientSecret;
    private final String audience;
    private final JsonPathFilterQuery customClaimMatcher;
    private final SSLSocketFactory socketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final PrincipalExtractor principalExtractor;
    private final JsonPathQuery groupsMatcher;
    private final String groupsDelimiter;
    private final int connectTimeoutSeconds;
    private final int readTimeoutSeconds;

    public OAuthIntrospectionValidator(String introspectionEndpointUri, SSLSocketFactory socketFactory, HostnameVerifier verifier, PrincipalExtractor principalExtractor, String groupsClaimQuery, String groupsClaimDelimiter, String issuerUri, String userInfoUri, String validTokenType, String clientId, String clientSecret, String audience, String customClaimCheck, int connectTimeoutSeconds, int readTimeoutSeconds) {
        if (introspectionEndpointUri == null) {
            throw new IllegalArgumentException("introspectionEndpointUri == null");
        }
        try {
            this.introspectionURI = new URI(introspectionEndpointUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid introspection endpoint uri: " + introspectionEndpointUri, e);
        }
        if (socketFactory != null && !"https".equals(this.introspectionURI.getScheme())) {
            throw new IllegalArgumentException("SSL socket factory set but introspectionEndpointUri not 'https'");
        }
        this.socketFactory = socketFactory;
        if (verifier != null && !"https".equals(this.introspectionURI.getScheme())) {
            throw new IllegalArgumentException("Certificate hostname verifier set but keysEndpointUri not 'https'");
        }
        this.hostnameVerifier = verifier;
        this.principalExtractor = principalExtractor != null ? principalExtractor : new PrincipalExtractor();
        this.groupsMatcher = this.parseGroupsQuery(groupsClaimQuery);
        this.groupsDelimiter = this.parseGroupsDelimiter(groupsClaimDelimiter);
        if (issuerUri != null) {
            try {
                new URI(issuerUri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid issuer uri: " + issuerUri, e);
            }
        }
        this.validIssuerURI = issuerUri;
        if (userInfoUri != null) {
            try {
                this.userInfoURI = new URI(userInfoUri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid userInfo uri: " + userInfoUri, e);
            }
        } else {
            this.userInfoURI = null;
        }
        this.validTokenType = validTokenType;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.audience = audience;
        this.customClaimMatcher = this.parseCustomClaimCheck(customClaimCheck);
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        this.readTimeoutSeconds = readTimeoutSeconds;
        if (log.isDebugEnabled()) {
            log.debug("Configured OAuthIntrospectionValidator:\n    introspectionEndpointUri: " + this.introspectionURI + "\n    sslSocketFactory: " + socketFactory + "\n    hostnameVerifier: " + this.hostnameVerifier + "\n    principalExtractor: " + principalExtractor + "\n    groupsClaimQuery: " + groupsClaimQuery + "\n    groupsClaimDelimiter: " + groupsClaimDelimiter + "\n    validIssuerUri: " + this.validIssuerURI + "\n    userInfoUri: " + this.userInfoURI + "\n    validTokenType: " + validTokenType + "\n    clientId: " + clientId + "\n    clientSecret: " + LogUtil.mask(clientSecret) + "\n    audience: " + audience + "\n    customClaimCheck: " + customClaimCheck + "\n    connectTimeoutSeconds: " + connectTimeoutSeconds + "\n    readTimeoutSeconds: " + readTimeoutSeconds);
        }
    }

    private JsonPathFilterQuery parseCustomClaimCheck(String customClaimCheck) {
        if (customClaimCheck != null) {
            String query = customClaimCheck.trim();
            if (query.length() == 0) {
                throw new IllegalArgumentException("Value of customClaimCheck is empty");
            }
            return JsonPathFilterQuery.parse(query);
        }
        return null;
    }

    private JsonPathQuery parseGroupsQuery(String groupsQuery) {
        if (groupsQuery != null) {
            String query = groupsQuery.trim();
            if (query.length() == 0) {
                throw new IllegalArgumentException("Value of groupsClaimQuery is empty");
            }
            return JsonPathQuery.parse(query);
        }
        return null;
    }

    private String parseGroupsDelimiter(String groupsDelimiter) {
        if (groupsDelimiter != null && groupsDelimiter.length() == 0) {
            throw new IllegalArgumentException("Value of groupsClaimDelimiter is empty");
        }
        return ",";
    }

    @Override
    public TokenInfo validate(String token) {
        boolean active;
        JsonNode response;
        String authorization = this.clientSecret != null ? "Basic " + OAuthAuthenticator.base64encode(this.clientId + ':' + this.clientSecret) : null;
        StringBuilder body = new StringBuilder("token=").append(token);
        try {
            response = HttpUtil.post(this.introspectionURI, this.socketFactory, this.hostnameVerifier, authorization, "application/x-www-form-urlencoded", body.toString(), JsonNode.class, this.connectTimeoutSeconds, this.readTimeoutSeconds);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to introspect token - send, fetch or parse failed: ", e);
        }
        try {
            active = response.get("active").asBoolean();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to introspect token - invalid response: \"active\" attribute is missing or not a boolean (" + response.get("active") + ")");
        }
        if (!active) {
            throw new TokenValidationException("Token validation failed: Token not active");
        }
        JsonNode value = response.get("exp");
        if (value == null) {
            throw new IllegalStateException("Introspection response contains no expires information (\"exp\"): " + response);
        }
        long expiresMillis = 1000L * value.asLong();
        if (Time.SYSTEM.milliseconds() > expiresMillis) {
            throw new TokenExpiredException("The token expired at: " + expiresMillis + " (" + TimeUtil.formatIsoDateTimeUTC(expiresMillis) + ")");
        }
        value = response.get("iat");
        long iat = value == null ? 0L : 1000L * value.asLong();
        String principal = this.principalExtractor.getPrincipal(response);
        JsonNode fallbackResponse = null;
        if (principal == null) {
            if (this.userInfoURI != null) {
                fallbackResponse = this.getUserInfoEndpointResponse(token);
                principal = this.getPrincipalFromUserInfoEndpoint(fallbackResponse);
            }
            if (principal == null && !this.principalExtractor.isConfigured()) {
                principal = this.principalExtractor.getSub(response);
            }
            if (principal == null) {
                throw new RuntimeException("Failed to extract principal - check usernameClaim, fallbackUsernameClaim configuration");
            }
        }
        this.performOptionalChecks(response);
        Set<String> groups = null;
        if (this.groupsMatcher != null && (groups = this.extractGroupsFromResponse(response)) == null && fallbackResponse != null) {
            groups = this.extractGroupsFromResponse(fallbackResponse);
        }
        String scopes = (value = response.get("scope")) != null ? String.join((CharSequence)" ", JSONUtil.asListOfString(value)) : null;
        return new TokenInfo(token, scopes, principal, groups, iat, expiresMillis);
    }

    private Set<String> extractGroupsFromResponse(JsonNode userInfoJson) {
        JsonNode result = this.groupsMatcher.apply(userInfoJson);
        if (result == null) {
            return null;
        }
        List<String> groups = JSONUtil.asListOfString(result, this.groupsDelimiter != null ? this.groupsDelimiter : ",");
        return groups.stream().map(String::trim).filter(v -> !v.isEmpty()).collect(Collectors.toSet());
    }

    private JsonNode getUserInfoEndpointResponse(String token) {
        String authorization = "Bearer " + token;
        try {
            return HttpUtil.get(this.userInfoURI, this.socketFactory, this.hostnameVerifier, authorization, JsonNode.class, this.connectTimeoutSeconds, this.readTimeoutSeconds);
        }
        catch (IOException e) {
            throw new RuntimeException("Request to User Info Endpoint failed: ", e);
        }
    }

    private String getPrincipalFromUserInfoEndpoint(JsonNode userInfoJson) {
        String principal = this.principalExtractor.getPrincipal(userInfoJson);
        if (principal == null && !this.principalExtractor.isConfigured()) {
            principal = this.principalExtractor.getSub(userInfoJson);
        }
        return principal;
    }

    private void performOptionalChecks(JsonNode response) {
        JsonNode value;
        if (!(this.validIssuerURI == null || (value = response.get("iss")) != null && this.validIssuerURI.equals(value.asText()))) {
            throw new TokenValidationException("Token check failed - Invalid issuer: " + value).status(TokenValidationException.Status.INVALID_TOKEN);
        }
        if (!(this.validTokenType == null || (value = response.get("token_type")) != null && this.validTokenType.equals(value.asText()))) {
            throw new TokenValidationException("Token check failed - Invalid token type: " + value + " (should be '" + this.validTokenType + "')" + (value == null ? ". Consider not setting OAUTH_VALID_TOKEN_TYPE." : "")).status(TokenValidationException.Status.UNSUPPORTED_TOKEN_TYPE);
        }
        if (this.audience != null) {
            List<Object> audienceList;
            value = response.get("aud");
            List<Object> list = audienceList = value != null ? JSONUtil.asListOfString(value) : Collections.emptyList();
            if (!audienceList.contains(this.audience)) {
                throw new TokenValidationException("Token check failed - Invalid audience: " + value).status(TokenValidationException.Status.INVALID_TOKEN);
            }
        }
        if (this.customClaimMatcher != null && !this.customClaimMatcher.matches(response)) {
            throw new TokenValidationException("Token check failed - Custom claim check failed.").status(TokenValidationException.Status.INVALID_TOKEN);
        }
    }
}

