/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.strimzi.kafka.oauth.common.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JSONUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static ObjectNode newObjectNode() {
        return new ObjectNode(MAPPER.getNodeFactory());
    }

    public static <T> T readJSON(InputStream is, Class<T> clazz) throws IOException {
        if (clazz == String.class) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtil.copy(is, baos);
            return clazz.cast(new String(baos.toByteArray(), StandardCharsets.UTF_8));
        }
        return (T)MAPPER.readValue(is, clazz);
    }

    public static <T> T readJSON(String jsonString, Class<T> clazz) throws IOException {
        return (T)MAPPER.readValue(jsonString, clazz);
    }

    public static JsonNode asJson(Object value) {
        if (value instanceof JsonNode) {
            return (JsonNode)value;
        }
        try {
            return (JsonNode)MAPPER.convertValue(value, JsonNode.class);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Failed to convert value to JSON (" + value + ")", e);
        }
    }

    public static String getClaimFromJWT(String claim, Object token) {
        JsonNode node = JSONUtil.asJson(token);
        return JSONUtil.getClaimFromJWT(node, claim.split("\\."));
    }

    public static String getClaimFromJWT(JsonNode node, String ... path) {
        for (String p : path) {
            if ((node = node.get(p)) != null) continue;
            return null;
        }
        return node.asText();
    }

    public static List<String> asListOfString(JsonNode arrayOrString) {
        return JSONUtil.asListOfString(arrayOrString, " ");
    }

    public static List<String> asListOfString(JsonNode arrayOrString, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        if (arrayOrString.isTextual()) {
            result.addAll(Arrays.stream(arrayOrString.asText().split(Pattern.quote(delimiter))).map(String::trim).collect(Collectors.toList()));
        } else {
            if (!arrayOrString.isArray()) {
                throw new IllegalArgumentException("JsonNode not a text node, nor an array node: " + arrayOrString);
            }
            for (JsonNode n : arrayOrString) {
                if (n.isTextual()) {
                    result.add(n.asText());
                    continue;
                }
                result.add(n.toString());
            }
        }
        return result;
    }
}

