/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.PayloadTransformer;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.NimbusPayloadTransformer;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.TokenInfo;
import io.strimzi.kafka.oauth.validator.ValidationException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;

public class TokenIntrospection {
    private static final NimbusPayloadTransformer TRANSFORMER = new NimbusPayloadTransformer();

    public static TokenInfo introspectAccessToken(String token, PrincipalExtractor principalExtractor) {
        JWSObject jws;
        try {
            jws = JWSObject.parse((String)token);
        }
        catch (Exception e) {
            throw new ValidationException("Failed to parse JWT token", e);
        }
        try {
            String principal;
            JsonNode parsed = (JsonNode)jws.getPayload().toType((PayloadTransformer)TRANSFORMER);
            if (principalExtractor == null) {
                principalExtractor = new PrincipalExtractor();
            }
            if ((principal = principalExtractor.getPrincipal(parsed)) == null) {
                principal = principalExtractor.getSub(parsed);
            }
            return new TokenInfo(parsed, token, principal);
        }
        catch (Exception e) {
            throw new ValidationException("Failed to read payload from JWT access token", e);
        }
    }

    public static void debugLogJWT(Logger log, String token) {
        JWSObject jws;
        try {
            jws = JWSObject.parse((String)token);
            log.debug("Token: {}", (Object)jws.getPayload());
        }
        catch (Exception e) {
            log.debug("[IGNORED] Token doesn't seem to be JWT token: " + LogUtil.mask(token), (Throwable)e);
            return;
        }
        try {
            JsonNode parsed = (JsonNode)jws.getPayload().toType((PayloadTransformer)TRANSFORMER);
            JsonNode expires = parsed.get("exp");
            if (expires == null) {
                log.debug("Access token has no expiry set.");
            } else {
                log.debug("Access token expires at (UTC): " + (expires.isNumber() ? LocalDateTime.ofEpochSecond(expires.asInt(), 0, ZoneOffset.UTC).format(DateTimeFormatter.ISO_DATE_TIME) : "invalid value: [" + expires.asText() + "]"));
            }
        }
        catch (Exception e) {
            log.debug("[IGNORED] Failed to parse JWT token's payload", (Throwable)e);
        }
    }
}

