/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.services;

import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.services.SessionFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Sessions {
    private static final Object NONE = new Object();
    private final Map<BearerTokenWithPayload, Object> activeSessions = Collections.synchronizedMap(new WeakHashMap());

    public void put(BearerTokenWithPayload token) {
        this.activeSessions.put(token, NONE);
    }

    public void remove(BearerTokenWithPayload token) {
        this.activeSessions.remove(token);
    }

    public List<SessionFuture<?>> executeTask(ExecutorService executor, Predicate<BearerTokenWithPayload> filter, Consumer<BearerTokenWithPayload> task) {
        this.cleanupExpired();
        ArrayList<BearerTokenWithPayload> values = new ArrayList<BearerTokenWithPayload>(this.activeSessions.keySet());
        ArrayList results = new ArrayList(values.size());
        for (BearerTokenWithPayload token : values) {
            if (!filter.test(token)) continue;
            SessionFuture current = new SessionFuture(token, executor.submit(() -> task.accept(token)));
            results.add(current);
        }
        return results;
    }

    public void cleanupExpired() {
        ArrayList<BearerTokenWithPayload> values = new ArrayList<BearerTokenWithPayload>(this.activeSessions.keySet());
        long now = System.currentTimeMillis();
        for (BearerTokenWithPayload token : values) {
            if (token.lifetimeMs() > now) continue;
            this.activeSessions.remove(token);
        }
    }

    public BearerTokenWithPayload findFirst(Predicate<BearerTokenWithPayload> filter) {
        ArrayList<BearerTokenWithPayload> values = new ArrayList<BearerTokenWithPayload>(this.activeSessions.keySet());
        for (BearerTokenWithPayload token : values) {
            if (!filter.test(token)) continue;
            return token;
        }
        return null;
    }
}

