/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.metrics;

import io.strimzi.kafka.oauth.metrics.AbstractSensorKeyProducer;
import io.strimzi.kafka.oauth.metrics.MetricsUtil;
import io.strimzi.kafka.oauth.metrics.SensorKey;
import java.net.URI;
import java.util.Map;

public class IntrospectValidationSensorKeyProducer
extends AbstractSensorKeyProducer {
    private final String saslMechanism;

    public IntrospectValidationSensorKeyProducer(String contextId, String saslMechanism, URI uri) {
        super(contextId, uri);
        if (saslMechanism == null) {
            throw new IllegalArgumentException("saslMechanism == null");
        }
        this.saslMechanism = saslMechanism;
    }

    @Override
    public SensorKey successKey() {
        Map<String, String> attrs = MetricsUtil.getSensorKeyAttrs(this.contextId, this.saslMechanism, this.uri, "introspect");
        attrs.put("outcome", "success");
        return SensorKey.of("validation_requests", attrs);
    }

    @Override
    public SensorKey errorKey(Throwable e) {
        Map<String, String> attrs = MetricsUtil.getSensorKeyAttrs(this.contextId, this.saslMechanism, this.uri, "introspect");
        attrs.put("outcome", "error");
        attrs.put("error_type", "other");
        return SensorKey.of("validation_requests", attrs);
    }
}

