/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.services;

import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.metrics.SensorKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthMetrics {
    private static final Logger log = LoggerFactory.getLogger(OAuthMetrics.class);
    private final Map<String, ?> configMap;
    private final Config config;
    private final Metrics metrics;
    private final Map<SensorKey, Sensor> sensorMap = new ConcurrentHashMap<SensorKey, Sensor>();

    OAuthMetrics(Map<String, ?> configMap) {
        this.config = new Config(configMap);
        configMap.put("strimzi.oauth.metric.reporters", this.config.getValue("strimzi.oauth.metric.reporters"));
        this.configMap = configMap;
        this.metrics = this.initKafkaMetrics();
    }

    public void addTime(SensorKey key, long timeMs) {
        Sensor registeredSensor = this.sensorMap.computeIfAbsent(key, k -> {
            Sensor sensor = this.metrics.sensor(key.getId());
            this.addMetricsToSensor(this.metrics, sensor, key);
            return sensor;
        });
        registeredSensor.record((double)timeMs);
    }

    private Metrics initKafkaMetrics() {
        List<MetricsReporter> reporters = this.initReporters();
        KafkaMetricsContext ctx = this.createKafkaMetricsContext();
        MetricConfig metricConfig = this.getMetricConfig();
        return this.createMetrics(metricConfig, ctx, reporters);
    }

    private List<MetricsReporter> initReporters() {
        AbstractConfig kafkaConfig = this.initKafkaConfig();
        if (this.configMap.get("strimzi.oauth.metric.reporters") != null) {
            return kafkaConfig.getConfiguredInstances("strimzi.oauth.metric.reporters", MetricsReporter.class);
        }
        JmxReporter reporter = new JmxReporter();
        reporter.configure(this.configMap);
        return Collections.singletonList(reporter);
    }

    private AbstractConfig initKafkaConfig() {
        ConfigDef configDef = this.addMetricReporterToConfigDef(new ConfigDef(), "strimzi.oauth.metric.reporters");
        return new AbstractConfig(configDef, this.toMapOfStringValues(this.configMap));
    }

    private ConfigDef addMetricReporterToConfigDef(ConfigDef configDef, String name) {
        return configDef.define(name, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)new ConfigDef.NonNullValidator(), ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.");
    }

    private Map<String, String> toMapOfStringValues(Map<String, ?> configMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ?> ent : configMap.entrySet()) {
            Object val = ent.getValue();
            if (val == null) continue;
            if (val instanceof Class) {
                result.put(ent.getKey(), ((Class)val).getCanonicalName());
                continue;
            }
            if (val instanceof List) {
                String stringVal = ((List)val).stream().map(String::valueOf).collect(Collectors.joining(","));
                if (stringVal.isEmpty()) continue;
                result.put(ent.getKey(), stringVal);
                continue;
            }
            result.put(ent.getKey(), String.valueOf(ent.getValue()));
        }
        return result;
    }

    private KafkaMetricsContext createKafkaMetricsContext() {
        String clientId;
        HashMap<String, String> contextLabels = new HashMap<String, String>();
        String processRoles = this.config.getValue("process.roles");
        if (processRoles == null || "[]".equals(processRoles)) {
            String brokerId = this.config.getValue("broker.id");
            if (brokerId != null) {
                contextLabels.put("kafka.broker.id", brokerId);
            }
        } else {
            String nodeId = this.config.getValue("node.id");
            if (nodeId != null) {
                contextLabels.put("kafka.node.id", nodeId);
            }
        }
        if (this.config.getValue("client.id") != null && (clientId = this.config.getValue("client.id")) != null) {
            contextLabels.put("client.id", clientId);
        }
        this.addConfiguredContextLabels(contextLabels);
        return new KafkaMetricsContext("strimzi.oauth", contextLabels);
    }

    private void addConfiguredContextLabels(HashMap<String, String> contextLabels) {
        String prefix = "metrics.context.";
        for (Map.Entry<String, ?> entry : this.configMap.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            contextLabels.put(entry.getKey().substring(prefix.length()), String.valueOf(entry.getValue()));
        }
    }

    private MetricConfig getMetricConfig() {
        int numSamples = this.config.getValueAsInt("metrics.num.samples", 2);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.forName((String)this.config.getValue("metrics.recording.level", "INFO"));
        long sampleWindowMs = this.config.getValueAsLong("metrics.sample.window.ms", 30000L);
        return new MetricConfig().samples(numSamples).recordLevel(recordingLevel).timeWindow(sampleWindowMs, TimeUnit.MILLISECONDS);
    }

    private Metrics createMetrics(MetricConfig metricConfig, KafkaMetricsContext ctx, List<MetricsReporter> reporters) {
        log.debug("Creating Metrics: \n    metricConfig: {samples: " + metricConfig.samples() + ", recordingLevel: " + metricConfig.recordLevel() + ", timeWindowMs: " + metricConfig.timeWindowMs() + "}\n    kafkaMetricsContext: " + ctx.contextLabels() + "\n    reporters: " + reporters);
        return new Metrics(metricConfig, reporters, Time.SYSTEM, (MetricsContext)ctx);
    }

    private void addMetricsToSensor(Metrics metrics, Sensor sensor, SensorKey key) {
        MetricName metricName = new MetricName("count", key.getName(), "Total request count", key.getAttributes());
        sensor.add(metricName, (MeasurableStat)new CumulativeCount());
        metricName = new MetricName("totalTimeMs", key.getName(), "Total time spent in requests in ms", key.getAttributes());
        sensor.add(metricName, (MeasurableStat)new CumulativeSum());
        metricName = new MetricName("avgTimeMs", key.getName(), "Average request time in ms", key.getAttributes());
        sensor.add(metricName, (MeasurableStat)new Avg());
        metricName = new MetricName("maxTimeMs", key.getName(), "Max request time in ms", key.getAttributes());
        sensor.add(metricName, (MeasurableStat)new Max());
        metricName = metrics.metricName("minTimeMs", key.getName(), "Min request time in ms", key.getAttributes());
        sensor.add(metricName, (MeasurableStat)new Min());
    }
}

