/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.services;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.strimzi.kafka.oauth.common.ConfigException;
import io.strimzi.kafka.oauth.services.ConfigurationKey;
import io.strimzi.kafka.oauth.validator.TokenValidator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class Validators {
    private final ConcurrentHashMap<ConfigurationKey, ValidatorEntry> registry = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITOR"})
    public TokenValidator get(ConfigurationKey key, Supplier<TokenValidator> factory) {
        ConcurrentHashMap<ConfigurationKey, ValidatorEntry> concurrentHashMap = this.registry;
        synchronized (concurrentHashMap) {
            ValidatorEntry previous = this.registry.get(key);
            if (previous != null) {
                if (!key.getValidatorKey().equals(previous.key.getValidatorKey())) {
                    throw new ConfigException("Configuration id '" + key.getConfigId() + "' with different configuration has already been assigned (" + String.valueOf(previous.key) + "\n\tversus:\n\t" + String.valueOf(key) + ")");
                }
                return previous.validator;
            }
            ValidatorEntry newEntry = new ValidatorEntry(key, factory.get());
            this.registry.put(key, newEntry);
            return newEntry.validator;
        }
    }

    private static class ValidatorEntry {
        final ConfigurationKey key;
        final TokenValidator validator;

        private ValidatorEntry(ConfigurationKey key, TokenValidator validator) {
            this.key = key;
            this.validator = validator;
        }
    }
}

