/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.strimzi.kafka.oauth.common.HttpException;
import io.strimzi.kafka.oauth.common.IOUtil;
import io.strimzi.kafka.oauth.common.JSONUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static <T> T get(URI uri, String authorization, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, null, null, authorization, null, null, responseType);
    }

    public static <T> T get(URI uri, SSLSocketFactory socketFactory, String authorization, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, socketFactory, null, authorization, null, null, responseType);
    }

    public static <T> T get(URI uri, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String authorization, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, socketFactory, hostnameVerifier, authorization, null, null, responseType);
    }

    public static <T> T post(URI uri, String authorization, String contentType, String body, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, null, null, authorization, contentType, body, responseType);
    }

    public static <T> T post(URI uri, SSLSocketFactory socketFactory, String authorization, String contentType, String body, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, socketFactory, null, authorization, contentType, body, responseType);
    }

    public static <T> T post(URI uri, SSLSocketFactory socketFactory, HostnameVerifier verifier, String authorization, String contentType, String body, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, socketFactory, verifier, authorization, contentType, body, responseType);
    }

    public static void put(URI uri, String authorization, String contentType, String body) throws IOException {
        HttpUtil.request(uri, null, null, authorization, contentType, body, null);
    }

    public static void put(URI uri, SSLSocketFactory socketFactory, String authorization, String contentType, String body) throws IOException {
        HttpUtil.request(uri, socketFactory, null, authorization, contentType, body, null);
    }

    public static void put(URI uri, SSLSocketFactory socketFactory, HostnameVerifier verifier, String authorization, String contentType, String body) throws IOException {
        HttpUtil.request(uri, socketFactory, verifier, authorization, contentType, body, null);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public static <T> T request(URI uri, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String authorization, String contentType, String body, Class<T> responseType) throws IOException {
        HttpURLConnection con;
        try {
            con = (HttpURLConnection)uri.toURL().openConnection();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed token endpoint url: " + uri);
        }
        if (con instanceof HttpsURLConnection) {
            HttpsURLConnection scon = (HttpsURLConnection)con;
            if (socketFactory != null) {
                scon.setSSLSocketFactory(socketFactory);
            }
            if (hostnameVerifier != null) {
                scon.setHostnameVerifier(hostnameVerifier);
            }
        } else if (socketFactory != null) {
            log.warn("SSL socket factory set but url scheme not https ({})", (Object)uri);
        }
        con.setUseCaches(false);
        if (body != null) {
            con.setDoOutput(true);
        }
        String method = body == null ? "GET" : (responseType != null ? "POST" : "PUT");
        con.setRequestMethod(method);
        if (authorization != null) {
            con.setRequestProperty("Authorization", authorization);
        }
        con.setRequestProperty("Accept", "application/json");
        if (body != null && body.length() > 0) {
            if (contentType == null) {
                throw new IllegalArgumentException("contentType must be set when body is not null");
            }
            con.setRequestProperty("Content-Type", contentType);
        }
        try {
            con.connect();
        }
        catch (ConnectException e) {
            throw new IOException("Failed to connect to: " + uri, e);
        }
        if (body != null && body.length() > 0) {
            try (OutputStream out = con.getOutputStream();){
                out.write(body.getBytes(StandardCharsets.UTF_8));
            }
        }
        return HttpUtil.handleResponse(con, method, uri, responseType);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private static <T> T handleResponse(HttpURLConnection con, String method, URI uri, Class<T> responseType) throws IOException {
        int code = con.getResponseCode();
        if (code != 200 && code != 201 && code != 204) {
            InputStream err = con.getErrorStream();
            if (err != null) {
                ByteArrayOutputStream errbuf = new ByteArrayOutputStream(4096);
                try {
                    IOUtil.copy(err, errbuf);
                }
                catch (Exception e) {
                    log.warn("[IGNORED] Failed to read response body", (Throwable)e);
                }
                throw new HttpException(method, uri, code, errbuf.toString(StandardCharsets.UTF_8.name()));
            }
            throw new HttpException(method, uri, code, con.getResponseMessage());
        }
        try (InputStream response = con.getInputStream();){
            if (responseType == null) {
                response.close();
                T e = null;
                return e;
            }
            InputStream is = response;
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                IOUtil.copy(response, buffer);
                log.trace("Response body for " + method + " " + uri + ": " + buffer.toString("utf-8"));
                is = new ByteArrayInputStream(buffer.toByteArray());
            }
            T t = JSONUtil.readJSON(is, responseType);
            return t;
        }
    }
}

