/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.validator;

import io.strimzi.kafka.oauth.services.CurrentTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackOffTaskScheduler {
    private static final Logger log = LoggerFactory.getLogger(BackOffTaskScheduler.class);
    private final ScheduledExecutorService service;
    private final Runnable task;
    private final int minPauseSeconds;
    private final int cutoffIntervalSeconds;
    private final AtomicBoolean taskScheduled = new AtomicBoolean(false);
    private long lastExecutionAttempt;

    public BackOffTaskScheduler(ScheduledExecutorService executor, int minPauseSeconds, int cutoffIntervalSeconds, Runnable task) {
        this.service = executor;
        this.task = task;
        this.minPauseSeconds = minPauseSeconds;
        this.cutoffIntervalSeconds = cutoffIntervalSeconds;
        if (minPauseSeconds < 0) {
            throw new IllegalArgumentException("'minPauseSeconds' can't be < 0");
        }
        if (cutoffIntervalSeconds < 0) {
            throw new IllegalArgumentException("'cutoffIntervaSeconds' can't be < 0");
        }
    }

    public int getMinPauseSeconds() {
        return this.minPauseSeconds;
    }

    public int getCutoffIntervalSeconds() {
        return this.cutoffIntervalSeconds;
    }

    public boolean scheduleTask() {
        if (!this.taskScheduled.getAndSet(true)) {
            long boundaryTime;
            log.debug("Acquired taskSchedule lock");
            long delay = 0L;
            long now = CurrentTime.currentTime();
            long l = boundaryTime = this.minPauseSeconds > 0 ? this.lastExecutionAttempt + (long)this.minPauseSeconds * 1000L : now;
            if (boundaryTime > now) {
                delay = boundaryTime - now;
            }
            this.scheduleServiceTask(new RunnableTask(), delay);
            if (log.isDebugEnabled()) {
                log.debug("Task scheduled for execution in {} milliseconds", (Object)delay);
            }
            return true;
        }
        return false;
    }

    private void scheduleServiceTask(Runnable task, long delay) {
        try {
            this.service.schedule(task, delay, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            this.releaseTaskScheduleLock();
            throw new RuntimeException("Failed to re-schedule the task", e);
        }
    }

    private void releaseTaskScheduleLock() {
        this.taskScheduled.set(false);
        log.debug("Released taskSchedule lock");
    }

    class RunnableTask
    implements Runnable {
        private int repeatCount = 0;

        RunnableTask() {
        }

        @Override
        public void run() {
            try {
                BackOffTaskScheduler.this.lastExecutionAttempt = CurrentTime.currentTime();
                ++this.repeatCount;
                BackOffTaskScheduler.this.task.run();
                BackOffTaskScheduler.this.releaseTaskScheduleLock();
            }
            catch (Throwable t) {
                log.error("Scheduled task execution failed:", t);
                if (this.repeatCount > 14) {
                    log.debug("Task schedule lock held for too many repetitions");
                    BackOffTaskScheduler.this.releaseTaskScheduleLock();
                    return;
                }
                long delay = 1L << this.repeatCount;
                if (BackOffTaskScheduler.this.minPauseSeconds > 0 && delay < (long)BackOffTaskScheduler.this.minPauseSeconds) {
                    delay = BackOffTaskScheduler.this.minPauseSeconds;
                }
                if (BackOffTaskScheduler.this.cutoffIntervalSeconds <= 0 || delay < (long)BackOffTaskScheduler.this.cutoffIntervalSeconds) {
                    BackOffTaskScheduler.this.scheduleServiceTask(this, 1000L * delay);
                    if (log.isDebugEnabled()) {
                        log.debug("Task rescheduled in {} seconds", (Object)delay);
                    }
                }
                BackOffTaskScheduler.this.releaseTaskScheduleLock();
            }
        }
    }
}

