/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.keycloak.util.JsonSerialization;

public class JSONUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static ObjectNode newObjectNode() {
        return new ObjectNode(MAPPER.getNodeFactory());
    }

    public static <T> T readJSON(InputStream is, Class<T> clazz) throws IOException {
        return (T)MAPPER.readValue(is, clazz);
    }

    public static JsonNode asJson(Object value) {
        if (value instanceof JsonNode) {
            return (JsonNode)value;
        }
        try {
            String jsonString = JsonSerialization.writeValueAsString((Object)value);
            return (JsonNode)JsonSerialization.readValue((String)jsonString, JsonNode.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert value to JSON (" + value + ")", e);
        }
    }

    public static String getClaimFromJWT(String claim, Object token) {
        JsonNode node = JSONUtil.asJson(token);
        return JSONUtil.getClaimFromJWT(node, claim.split("\\."));
    }

    public static String getClaimFromJWT(JsonNode node, String ... path) {
        for (String p : path) {
            if ((node = node.get(p)) != null) continue;
            return null;
        }
        return node.asText();
    }

    public static List<String> asListOfString(JsonNode arrayNode) {
        ArrayList<String> result = new ArrayList<String>();
        if (arrayNode.isTextual()) {
            result.addAll(Arrays.asList(arrayNode.asText().split(" ")));
        } else {
            if (!arrayNode.isArray()) {
                throw new IllegalArgumentException("JsonNode not a text node, nor an array node: " + arrayNode);
            }
            for (JsonNode n : arrayNode) {
                if (n.isTextual()) {
                    result.add(n.asText());
                    continue;
                }
                result.add(n.toString());
            }
        }
        return result;
    }
}

