/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import io.strimzi.kafka.oauth.common.JSONUtil;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;

public class PrincipalExtractor {
    private String usernameClaim;
    private String fallbackUsernameClaim;
    private String fallbackUsernamePrefix;

    public PrincipalExtractor() {
    }

    public PrincipalExtractor(String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix) {
        this.usernameClaim = usernameClaim;
        this.fallbackUsernameClaim = fallbackUsernameClaim;
        this.fallbackUsernamePrefix = fallbackUsernamePrefix;
    }

    public String getPrincipal(AccessToken token, JWSInput jws) {
        if (this.usernameClaim != null) {
            try {
                return this.getPrincipal((JsonNode)jws.readJsonContent(JsonNode.class));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse access token", e);
            }
        }
        return null;
    }

    public String getPrincipal(JsonNode json) {
        if (this.usernameClaim != null) {
            String result = JSONUtil.getClaimFromJWT(json, this.usernameClaim);
            if (result != null) {
                return result;
            }
            if (this.fallbackUsernameClaim != null && (result = JSONUtil.getClaimFromJWT(json, this.fallbackUsernameClaim)) != null) {
                return this.fallbackUsernamePrefix == null ? result : this.fallbackUsernamePrefix + result;
            }
        }
        return null;
    }

    public String getSub(AccessToken token) {
        return token.getSubject();
    }

    public String getSub(JsonNode json) {
        return JSONUtil.getClaimFromJWT(json, "sub");
    }

    public String toString() {
        return "PrincipalExtractor {usernameClaim: " + this.usernameClaim + ", fallbackUsernameClaim: " + this.fallbackUsernameClaim + ", fallbackUsernamePrefix: " + this.fallbackUsernamePrefix + "}";
    }

    public boolean isConfigured() {
        return this.usernameClaim != null || this.fallbackUsernameClaim != null || this.fallbackUsernamePrefix != null;
    }
}

