/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.services;

import java.util.Objects;

public class ValidatorKey {
    private final String validIssuerUri;
    private final String audience;
    private final String customClaimCheck;
    private final String usernameClaim;
    private final String fallbackUsernameClaim;
    private final String fallbackUsernamePrefix;
    private final String sslTruststore;
    private final String sslStorePassword;
    private final String sslStoreType;
    private final String sslRandom;
    private final boolean hasHostnameVerifier;

    ValidatorKey(String validIssuerUri, String audience, String customClaimCheck, String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix, String sslTruststore, String sslStorePassword, String sslStoreType, String sslRandom, boolean hasHostnameVerifier) {
        this.validIssuerUri = validIssuerUri;
        this.audience = audience;
        this.customClaimCheck = customClaimCheck;
        this.usernameClaim = usernameClaim;
        this.fallbackUsernameClaim = fallbackUsernameClaim;
        this.fallbackUsernamePrefix = fallbackUsernamePrefix;
        this.sslTruststore = sslTruststore;
        this.sslStorePassword = sslStorePassword;
        this.sslStoreType = sslStoreType;
        this.sslRandom = sslRandom;
        this.hasHostnameVerifier = hasHostnameVerifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidatorKey)) {
            return false;
        }
        ValidatorKey that = (ValidatorKey)o;
        return this.hasHostnameVerifier == that.hasHostnameVerifier && Objects.equals(this.validIssuerUri, that.validIssuerUri) && Objects.equals(this.audience, that.audience) && Objects.equals(this.customClaimCheck, that.customClaimCheck) && Objects.equals(this.usernameClaim, that.usernameClaim) && Objects.equals(this.fallbackUsernameClaim, that.fallbackUsernameClaim) && Objects.equals(this.fallbackUsernamePrefix, that.fallbackUsernamePrefix) && Objects.equals(this.sslTruststore, that.sslTruststore) && Objects.equals(this.sslStorePassword, that.sslStorePassword) && Objects.equals(this.sslStoreType, that.sslStoreType) && Objects.equals(this.sslRandom, that.sslRandom);
    }

    public int hashCode() {
        return Objects.hash(this.validIssuerUri, this.audience, this.customClaimCheck, this.usernameClaim, this.fallbackUsernameClaim, this.fallbackUsernamePrefix, this.sslTruststore, this.sslStorePassword, this.sslStoreType, this.sslRandom, this.hasHostnameVerifier);
    }

    public static class IntrospectionValidatorKey
    extends ValidatorKey {
        private final String introspectionEndpoint;
        private final String userInfoEndpoint;
        private final String validTokenType;
        private final String clientId;
        private final String clientSecret;

        public IntrospectionValidatorKey(String validIssuerUri, String audience, String customClaimCheck, String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix, String sslTruststore, String sslStorePassword, String sslStoreType, String sslRandom, boolean hasHostnameVerifier, String introspectionEndpoint, String userInfoEndpoint, String validTokenType, String clientId, String clientSecret) {
            super(validIssuerUri, audience, customClaimCheck, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, sslTruststore, sslStorePassword, sslStoreType, sslRandom, hasHostnameVerifier);
            this.introspectionEndpoint = introspectionEndpoint;
            this.userInfoEndpoint = userInfoEndpoint;
            this.validTokenType = validTokenType;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IntrospectionValidatorKey that = (IntrospectionValidatorKey)o;
            return Objects.equals(this.introspectionEndpoint, that.introspectionEndpoint) && Objects.equals(this.userInfoEndpoint, that.userInfoEndpoint) && Objects.equals(this.validTokenType, that.validTokenType) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientSecret, that.clientSecret);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.introspectionEndpoint, this.userInfoEndpoint, this.validTokenType, this.clientId, this.clientSecret);
        }
    }

    public static class JwtValidatorKey
    extends ValidatorKey {
        private final String jwksEndpointUri;
        private final int jwksRefreshSeconds;
        private final int jwksExpirySeconds;
        private final int jwksRefreshMinPauseSeconds;
        private final boolean checkAccessTokenType;
        private final boolean enableBouncy;
        private final int bouncyPosition;

        public JwtValidatorKey(String validIssuerUri, String audience, String customClaimCheck, String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix, String sslTruststore, String sslStorePassword, String sslStoreType, String sslRandom, boolean hasHostnameVerifier, String jwksEndpointUri, int jwksRefreshSeconds, int jwksExpirySeconds, int jwksRefreshMinPauseSeconds, boolean checkAccessTokenType, boolean enableBouncy, int bouncyPosition) {
            super(validIssuerUri, audience, customClaimCheck, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, sslTruststore, sslStorePassword, sslStoreType, sslRandom, hasHostnameVerifier);
            this.jwksEndpointUri = jwksEndpointUri;
            this.jwksRefreshSeconds = jwksRefreshSeconds;
            this.jwksExpirySeconds = jwksExpirySeconds;
            this.jwksRefreshMinPauseSeconds = jwksRefreshMinPauseSeconds;
            this.checkAccessTokenType = checkAccessTokenType;
            this.enableBouncy = enableBouncy;
            this.bouncyPosition = bouncyPosition;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            JwtValidatorKey that = (JwtValidatorKey)o;
            return this.jwksRefreshSeconds == that.jwksRefreshSeconds && this.jwksExpirySeconds == that.jwksExpirySeconds && this.jwksRefreshMinPauseSeconds == that.jwksRefreshMinPauseSeconds && this.checkAccessTokenType == that.checkAccessTokenType && this.enableBouncy == that.enableBouncy && this.bouncyPosition == that.bouncyPosition && Objects.equals(this.jwksEndpointUri, that.jwksEndpointUri);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.jwksEndpointUri, this.jwksRefreshSeconds, this.jwksExpirySeconds, this.jwksRefreshMinPauseSeconds, this.checkAccessTokenType, this.enableBouncy, this.bouncyPosition);
        }
    }
}

