/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.validator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.AsymmetricSignatureVerifierContext;
import org.keycloak.crypto.KeyWrapper;

public class ECDSASignatureVerifierContext
extends AsymmetricSignatureVerifierContext {
    public ECDSASignatureVerifierContext(KeyWrapper key) {
        super(key);
    }

    public boolean verify(byte[] data, byte[] signature) throws VerificationException {
        int expectedSize = ECDSA.valueOf(this.getAlgorithm()).getSignatureLength();
        byte[] derSignature = expectedSize != signature.length && signature[0] == 48 ? signature : ECDSASignatureVerifierContext.concatenatedRSToASN1DER(signature, expectedSize);
        return super.verify(data, derSignature);
    }

    static byte[] concatenatedRSToASN1DER(byte[] signature, int signLength) {
        int len = signLength / 2;
        int arraySize = len + 1;
        byte[] r = new byte[arraySize];
        byte[] s = new byte[arraySize];
        System.arraycopy(signature, 0, r, 1, len);
        System.arraycopy(signature, len, s, 1, len);
        BigInteger rBigInteger = new BigInteger(r);
        BigInteger sBigInteger = new BigInteger(s);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            DERSequenceGenerator seqGen = new DERSequenceGenerator((OutputStream)bos);
            seqGen.addObject((ASN1Encodable)new ASN1Integer(rBigInteger.toByteArray()));
            seqGen.addObject((ASN1Encodable)new ASN1Integer(sBigInteger.toByteArray()));
            seqGen.close();
            bos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate ASN.1 DER signature", e);
        }
        return bos.toByteArray();
    }

    static enum ECDSA {
        ES256(64),
        ES384(96),
        ES512(132);

        private final int signatureLength;

        private ECDSA(int signatureLength) {
            this.signatureLength = signatureLength;
        }

        public int getSignatureLength() {
            return this.signatureLength;
        }
    }
}

