/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.TokenInfo;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;

public class TokenIntrospection {
    public static TokenInfo introspectAccessToken(String token, PrincipalExtractor principalExtractor) {
        JWSInput jws;
        try {
            jws = new JWSInput(token);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse JWT token", e);
        }
        try {
            String principal;
            AccessToken parsed = (AccessToken)jws.readJsonContent(AccessToken.class);
            if (principalExtractor == null) {
                principalExtractor = new PrincipalExtractor();
            }
            if ((principal = principalExtractor.getPrincipal(parsed, jws)) == null) {
                principal = principalExtractor.getSub(parsed);
            }
            return new TokenInfo(parsed, token, principal);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read payload from JWT access token", e);
        }
    }
}

