/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.representations.AccessToken;

public class TokenInfo {
    private String token;
    private Set<String> scopes = new HashSet<String>();
    private long expiresAt;
    private String principal;
    private long issuedAt;
    private AccessToken payload;

    public TokenInfo(AccessToken payload, String token, String principal) {
        this(token, payload.getScope(), principal, payload.getIat() == null ? 0L : payload.getIat() * 1000L, payload.getExp() == null ? 0L : payload.getExp() * 1000L);
        this.payload = payload;
    }

    public TokenInfo(String token, String scope, String principal, long issuedAtMs, long expiresAtMs) {
        String[] parsedScopes;
        this.token = token;
        this.principal = principal;
        this.issuedAt = issuedAtMs;
        this.expiresAt = expiresAtMs;
        for (String s : parsedScopes = scope != null ? scope.split(" ") : new String[]{}) {
            this.scopes.add(s);
        }
        this.scopes = Collections.unmodifiableSet(this.scopes);
    }

    public String token() {
        return this.token;
    }

    public Set<String> scope() {
        return this.scopes;
    }

    public long expiresAtMs() {
        return this.expiresAt;
    }

    public String principal() {
        return this.principal;
    }

    public long issuedAtMs() {
        return this.issuedAt;
    }

    public AccessToken payload() {
        return this.payload;
    }
}

