/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.SSLUtil;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class ConfigUtil {
    public static SSLSocketFactory createSSLFactory(Config config) {
        String truststore = config.getValue("oauth.ssl.truststore.location");
        String truststoreData = config.getValue("oauth.ssl.truststore.certificates");
        String password = config.getValue("oauth.ssl.truststore.password");
        String type = config.getValue("oauth.ssl.truststore.type");
        String rnd = config.getValue("oauth.ssl.secure.random.implementation");
        return SSLUtil.createSSLFactory(truststore, truststoreData, password, type, rnd);
    }

    public static HostnameVerifier createHostnameVerifier(Config config) {
        String hostCheck = config.getValue("oauth.ssl.endpoint.identification.algorithm", "HTTPS");
        return "".equals(hostCheck) ? SSLUtil.createAnyHostHostnameVerifier() : null;
    }

    public static void putIfNotNull(Properties p, String key, Object value) {
        if (value != null) {
            p.put(key, value);
        }
    }

    public static String getConfigWithFallbackLookup(Config c, String key, String fallbackKey) {
        String result = c.getValue(key);
        if (result == null) {
            result = c.getValue(fallbackKey);
        }
        return result;
    }
}

