/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import io.strimzi.kafka.oauth.common.HttpUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.TokenInfo;
import io.strimzi.kafka.oauth.common.TokenIntrospection;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(OAuthAuthenticator.class);

    public static TokenInfo loginWithAccessToken(String token, boolean isJwt, PrincipalExtractor principalExtractor) {
        if (log.isDebugEnabled()) {
            log.debug("loginWithAccessToken() - pass-through access_token: {}", (Object)LogUtil.mask(token));
        }
        if (isJwt) {
            try {
                return TokenIntrospection.introspectAccessToken(token, principalExtractor);
            }
            catch (Exception e) {
                log.debug("[IGNORED] Could not parse token as JWT access token. Could not extract scope, subject, and expiry.", (Throwable)e);
            }
        }
        return new TokenInfo(token, "undefined", "undefined", System.currentTimeMillis(), System.currentTimeMillis() + 1471228928L);
    }

    public static TokenInfo loginWithClientSecret(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope) throws IOException {
        return OAuthAuthenticator.loginWithClientSecret(tokenEndpointUrl, socketFactory, hostnameVerifier, clientId, clientSecret, isJwt, principalExtractor, scope, null);
    }

    public static TokenInfo loginWithClientSecret(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("loginWithClientSecret() - tokenEndpointUrl: {}, clientId: {}, clientSecret: {}, scope: {}, audience: {}", new Object[]{tokenEndpointUrl, clientId, LogUtil.mask(clientSecret), scope, audience});
        }
        String authorization = "Basic " + OAuthAuthenticator.base64encode(clientId + ':' + clientSecret);
        StringBuilder body = new StringBuilder("grant_type=client_credentials");
        if (scope != null) {
            body.append("&scope=").append(OAuthAuthenticator.urlencode(scope));
        }
        if (audience != null) {
            body.append("&audience=").append(OAuthAuthenticator.urlencode(audience));
        }
        return OAuthAuthenticator.post(tokenEndpointUrl, socketFactory, hostnameVerifier, authorization, body.toString(), isJwt, principalExtractor);
    }

    public static TokenInfo loginWithRefreshToken(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String refreshToken, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope) throws IOException {
        return OAuthAuthenticator.loginWithRefreshToken(tokenEndpointUrl, socketFactory, hostnameVerifier, refreshToken, clientId, clientSecret, isJwt, principalExtractor, scope, null);
    }

    public static TokenInfo loginWithRefreshToken(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String refreshToken, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("loginWithRefreshToken() - tokenEndpointUrl: {}, refreshToken: {}, clientId: {}, clientSecret: {}, scope: {}, audience: {}", new Object[]{tokenEndpointUrl, refreshToken, clientId, LogUtil.mask(clientSecret), scope, audience});
        }
        String authorization = clientSecret != null ? "Basic " + OAuthAuthenticator.base64encode(clientId + ':' + clientSecret) : null;
        StringBuilder body = new StringBuilder("grant_type=refresh_token").append("&refresh_token=").append(OAuthAuthenticator.urlencode(refreshToken)).append("&client_id=").append(OAuthAuthenticator.urlencode(clientId));
        if (scope != null) {
            body.append("&scope=").append(OAuthAuthenticator.urlencode(scope));
        }
        if (audience != null) {
            body.append("&audience=").append(OAuthAuthenticator.urlencode(audience));
        }
        return OAuthAuthenticator.post(tokenEndpointUrl, socketFactory, hostnameVerifier, authorization, body.toString(), isJwt, principalExtractor);
    }

    private static TokenInfo post(URI tokenEndpointUri, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String authorization, String body, boolean isJwt, PrincipalExtractor principalExtractor) throws IOException {
        long now = System.currentTimeMillis();
        JsonNode result = HttpUtil.post(tokenEndpointUri, socketFactory, hostnameVerifier, authorization, "application/x-www-form-urlencoded", body, JsonNode.class);
        JsonNode token = result.get("access_token");
        if (token == null) {
            throw new IllegalStateException("Invalid response from authorization server: no access_token");
        }
        JsonNode expiresIn = result.get("expires_in");
        if (expiresIn == null) {
            throw new IllegalStateException("Invalid response from authorization server: no expires_in");
        }
        JsonNode scope = result.get("scope");
        if (isJwt) {
            try {
                return TokenIntrospection.introspectAccessToken(token.asText(), principalExtractor);
            }
            catch (Exception e) {
                log.debug("[IGNORED] Could not parse token as JWT access token. Could not extract subject.", (Throwable)e);
            }
        }
        return new TokenInfo(token.asText(), scope != null ? scope.asText() : null, "undefined", now, now + expiresIn.asLong() * 1000L);
    }

    public static String base64encode(String value) {
        return Base64.getUrlEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
    }

    public static String urlencode(String value) {
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected: Encoding utf-8 not supported");
        }
    }
}

