/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TokenInfo {
    public static final String SCOPE = "scope";
    public static final String IAT = "iat";
    public static final String EXP = "exp";
    public static final String ISS = "iss";
    public static final String TYP = "typ";
    public static final String AUD = "aud";
    private String token;
    private Set<String> scopes = new HashSet<String>();
    private long expiresAt;
    private String principal;
    private long issuedAt;
    private JsonNode payload;

    public TokenInfo(JsonNode payload, String token, String principal) {
        this(token, payload.has(SCOPE) ? payload.get(SCOPE).asText() : null, principal, payload.has(IAT) ? (long)payload.get(IAT).asInt(0) * 1000L : 0L, (long)payload.get(EXP).asInt(0) * 1000L);
        this.payload = payload;
    }

    public TokenInfo(String token, String scope, String principal, long issuedAtMs, long expiresAtMs) {
        String[] parsedScopes;
        this.token = token;
        this.principal = principal;
        this.issuedAt = issuedAtMs;
        this.expiresAt = expiresAtMs;
        for (String s : parsedScopes = scope != null ? scope.split(" ") : new String[]{}) {
            this.scopes.add(s);
        }
        this.scopes = Collections.unmodifiableSet(this.scopes);
    }

    public String token() {
        return this.token;
    }

    public Set<String> scope() {
        return this.scopes;
    }

    public long expiresAtMs() {
        return this.expiresAt;
    }

    public String principal() {
        return this.principal;
    }

    public long issuedAtMs() {
        return this.issuedAt;
    }

    public JsonNode payload() {
        return this.payload;
    }
}

