/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server.authorizer;

import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigException;
import io.strimzi.kafka.oauth.common.ConfigUtil;
import io.strimzi.kafka.oauth.server.OAuthKafkaPrincipalBuilder;
import io.strimzi.kafka.oauth.server.authorizer.AuthzConfig;
import io.strimzi.kafka.oauth.server.authorizer.JwtKafkaPrincipalBuilder;
import io.strimzi.kafka.oauth.server.authorizer.UserSpec;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private static final String PRINCIPAL_BUILDER_CLASS = OAuthKafkaPrincipalBuilder.class.getName();
    private static final String DEPRECATED_PRINCIPAL_BUILDER_CLASS = JwtKafkaPrincipalBuilder.class.getName();
    private final Map<String, ?> configMap;
    private final List<Log> logs = new LinkedList<Log>();
    private final boolean reuseGrants;
    private final String clientId;
    private final String clusterName;
    private final boolean delegateToKafkaACL;
    private final int grantsRefreshPeriodSeconds;
    private final int grantsMaxIdleTimeSeconds;
    private final int grantsRefreshPoolSize;
    private final int gcPeriodSeconds;
    private boolean isKRaft;
    private String truststore;
    private String truststoreData;
    private String truststorePassword;
    private String truststoreType;
    private String prng;
    private String certificateHostCheckAlgorithm;
    private List<UserSpec> superUsers = Collections.emptyList();
    private int httpRetries;
    private boolean enableMetrics;
    private URI tokenEndpointUrl;
    private int connectTimeoutSeconds;
    private int readTimeoutSeconds;
    private boolean includeAcceptHeader;

    Configuration(Map<String, ?> configs) {
        this.configMap = configs;
        AuthzConfig authzConfig = this.convertToAuthzConfig(configs);
        String pbclass = (String)this.configMap.get("principal.builder.class");
        if (!PRINCIPAL_BUILDER_CLASS.equals(pbclass) && !DEPRECATED_PRINCIPAL_BUILDER_CLASS.equals(pbclass)) {
            throw new ConfigException("This authorizer requires " + PRINCIPAL_BUILDER_CLASS + " as 'principal.builder.class'");
        }
        if (DEPRECATED_PRINCIPAL_BUILDER_CLASS.equals(pbclass)) {
            this.logs.add(new Log(Log.Level.WARNING, "The '" + DEPRECATED_PRINCIPAL_BUILDER_CLASS + "' class has been deprecated, and may be removed in the future. Please use '" + PRINCIPAL_BUILDER_CLASS + "' as 'principal.builder.class' instead."));
        }
        this.configureTokenEndpoint(authzConfig);
        this.clientId = ConfigUtil.getConfigWithFallbackLookup((Config)authzConfig, (String)"strimzi.authorization.client.id", (String)"oauth.client.id");
        if (this.clientId == null) {
            throw new ConfigException("OAuth client id ('strimzi.authorization.client.id') not set.");
        }
        this.configureSSLFactory(authzConfig);
        this.configureHostnameVerifier(authzConfig);
        this.configureHttpTimeouts(authzConfig);
        String clusterName = authzConfig.getValue("strimzi.authorization.kafka.cluster.name");
        if (clusterName == null) {
            clusterName = "kafka-cluster";
        }
        this.clusterName = clusterName;
        this.delegateToKafkaACL = authzConfig.getValueAsBoolean("strimzi.authorization.delegate.to.kafka.acl", false);
        this.configureSuperUsers(configs);
        this.grantsRefreshPoolSize = authzConfig.getValueAsInt("strimzi.authorization.grants.refresh.pool.size", 5);
        if (this.grantsRefreshPoolSize < 1) {
            throw new ConfigException("Invalid value of 'strimzi.authorization.grants.refresh.pool.size': " + this.grantsRefreshPoolSize + ". Has to be >= 1.");
        }
        this.grantsRefreshPeriodSeconds = authzConfig.getValueAsInt("strimzi.authorization.grants.refresh.period.seconds", 60);
        this.grantsMaxIdleTimeSeconds = this.configureGrantsMaxIdleTimeSeconds(authzConfig);
        this.gcPeriodSeconds = this.configureGcPeriodSeconds(authzConfig);
        this.reuseGrants = authzConfig.getValueAsBoolean("strimzi.authorization.reuse.grants", true);
        this.includeAcceptHeader = ConfigUtil.getDefaultBooleanConfigWithFallbackLookup((Config)authzConfig, (String)"strimzi.authorization.include.accept.header", (String)"oauth.include.accept.header", (boolean)true);
        this.configureHttpRetries(authzConfig);
        this.configureMetrics(authzConfig);
    }

    public void printLogs() {
        for (Log line : this.logs) {
            if (line.level == Log.Level.WARNING) {
                log.warn(line.message);
                continue;
            }
            log.debug(line.message);
        }
    }

    private int configureGrantsMaxIdleTimeSeconds(AuthzConfig config) {
        int grantsMaxIdleTimeSeconds = config.getValueAsInt("strimzi.authorization.grants.max.idle.time.seconds", 300);
        if (grantsMaxIdleTimeSeconds <= 0) {
            this.logs.add(new Log(Log.Level.WARNING, "'strimzi.authorization.grants.max.idle.time.seconds' set to invalid value: " + grantsMaxIdleTimeSeconds + " (should be a positive number), using the default value: 300 seconds"));
            grantsMaxIdleTimeSeconds = 300;
        }
        return grantsMaxIdleTimeSeconds;
    }

    private int configureGcPeriodSeconds(AuthzConfig config) {
        int gcPeriodSeconds = config.getValueAsInt("strimzi.authorization.grants.gc.period.seconds", 300);
        if (gcPeriodSeconds <= 0) {
            this.logs.add(new Log(Log.Level.WARNING, "'strimzi.authorization.grants.gc.period.seconds' set to invalid value: " + gcPeriodSeconds + ", using the default value: 300 seconds"));
            gcPeriodSeconds = 300;
        }
        return gcPeriodSeconds;
    }

    private void configureSuperUsers(Map<String, ?> configs) {
        String users = (String)configs.get("super.users");
        if (users != null) {
            this.superUsers = Arrays.stream(users.split(";")).map(UserSpec::of).collect(Collectors.toList());
        }
    }

    private void configureSSLFactory(AuthzConfig config) {
        this.truststore = ConfigUtil.getConfigWithFallbackLookup((Config)config, (String)"strimzi.authorization.ssl.truststore.location", (String)"oauth.ssl.truststore.location");
        this.truststoreData = ConfigUtil.getConfigWithFallbackLookup((Config)config, (String)"strimzi.authorization.ssl.truststore.certificates", (String)"oauth.ssl.truststore.certificates");
        this.truststorePassword = ConfigUtil.getConfigWithFallbackLookup((Config)config, (String)"strimzi.authorization.ssl.truststore.password", (String)"oauth.ssl.truststore.password");
        this.truststoreType = ConfigUtil.getConfigWithFallbackLookup((Config)config, (String)"strimzi.authorization.ssl.truststore.type", (String)"oauth.ssl.truststore.type");
        this.prng = ConfigUtil.getConfigWithFallbackLookup((Config)config, (String)"strimzi.authorization.ssl.secure.random.implementation", (String)"oauth.ssl.secure.random.implementation");
    }

    private void configureHostnameVerifier(AuthzConfig config) {
        String hostCheck = ConfigUtil.getConfigWithFallbackLookup((Config)config, (String)"strimzi.authorization.ssl.endpoint.identification.algorithm", (String)"oauth.ssl.endpoint.identification.algorithm");
        if (hostCheck == null) {
            hostCheck = "HTTPS";
        }
        this.certificateHostCheckAlgorithm = hostCheck;
    }

    private void configureHttpRetries(AuthzConfig config) {
        this.httpRetries = config.getValueAsInt("strimzi.authorization.http.retries", 0);
        if (this.httpRetries < 0) {
            throw new ConfigException("Invalid value of 'strimzi.authorization.http.retries': " + this.httpRetries + ". Has to be >= 0.");
        }
    }

    private void configureMetrics(AuthzConfig config) {
        String enableMetricsString = ConfigUtil.getConfigWithFallbackLookup((Config)config, (String)"strimzi.authorization.enable.metrics", (String)"oauth.enable.metrics");
        try {
            this.enableMetrics = enableMetricsString != null && Config.isTrue((String)enableMetricsString);
        }
        catch (Exception e) {
            throw new ConfigException("Bad boolean value for key: strimzi.authorization.enable.metrics, value: " + enableMetricsString);
        }
    }

    private void configureTokenEndpoint(AuthzConfig config) {
        String endpoint = ConfigUtil.getConfigWithFallbackLookup((Config)config, (String)"strimzi.authorization.token.endpoint.uri", (String)"oauth.token.endpoint.uri");
        if (endpoint == null) {
            throw new ConfigException("OAuth2 Token Endpoint ('strimzi.authorization.token.endpoint.uri') not set.");
        }
        try {
            this.tokenEndpointUrl = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Specified token endpoint uri is invalid: " + endpoint);
        }
    }

    private void configureHttpTimeouts(AuthzConfig config) {
        LinkedList warnings = new LinkedList();
        this.connectTimeoutSeconds = ConfigUtil.getTimeoutConfigWithFallbackLookup((Config)config, (String)"strimzi.authorization.connect.timeout.seconds", (String)"oauth.connect.timeout.seconds", warnings);
        this.readTimeoutSeconds = ConfigUtil.getTimeoutConfigWithFallbackLookup((Config)config, (String)"strimzi.authorization.read.timeout.seconds", (String)"oauth.read.timeout.seconds", warnings);
        for (String message : warnings) {
            this.logs.add(new Log(Log.Level.WARNING, message));
        }
    }

    static AuthzConfig convertToCommonConfig(Map<String, ?> configs) {
        String[] keys;
        Properties p = new Properties();
        for (String key : keys = new String[]{"strimzi.authorization.grants.refresh.period.seconds", "strimzi.authorization.grants.refresh.pool.size", "strimzi.authorization.grants.max.idle.time.seconds", "strimzi.authorization.grants.gc.period.seconds", "strimzi.authorization.http.retries", "strimzi.authorization.reuse.grants", "strimzi.authorization.delegate.to.kafka.acl", "strimzi.authorization.kafka.cluster.name", "strimzi.authorization.client.id", "oauth.client.id", "strimzi.authorization.token.endpoint.uri", "oauth.token.endpoint.uri", "strimzi.authorization.ssl.truststore.location", "oauth.ssl.truststore.location", "strimzi.authorization.ssl.truststore.certificates", "oauth.ssl.truststore.certificates", "strimzi.authorization.ssl.truststore.password", "oauth.ssl.truststore.password", "strimzi.authorization.ssl.truststore.type", "oauth.ssl.truststore.type", "strimzi.authorization.ssl.secure.random.implementation", "oauth.ssl.secure.random.implementation", "strimzi.authorization.ssl.endpoint.identification.algorithm", "oauth.ssl.endpoint.identification.algorithm", "strimzi.authorization.connect.timeout.seconds", "oauth.connect.timeout.seconds", "strimzi.authorization.read.timeout.seconds", "oauth.read.timeout.seconds", "strimzi.authorization.enable.metrics", "oauth.enable.metrics", "strimzi.authorization.include.accept.header", "oauth.include.accept.header"}) {
            ConfigUtil.putIfNotNull((Properties)p, (String)key, configs.get(key));
        }
        return new AuthzConfig(p);
    }

    AuthzConfig convertToAuthzConfig(Map<String, ?> configs) {
        AuthzConfig config = Configuration.convertToCommonConfig(configs);
        this.isKRaft = this.detectKRaft(configs);
        if (this.isKRaft) {
            this.logs.add(new Log(Log.Level.DEBUG, "Detected KRaft mode ('process.roles' configured)"));
        }
        return config;
    }

    private boolean detectKRaft(Map<String, ?> configs) {
        Object prop = configs.get("process.roles");
        String processRoles = prop != null ? String.valueOf(prop) : null;
        return processRoles != null && processRoles.length() > 0;
    }

    boolean isKRaft() {
        return this.isKRaft;
    }

    String getTruststore() {
        return this.truststore;
    }

    String getTruststoreData() {
        return this.truststoreData;
    }

    String getTruststorePassword() {
        return this.truststorePassword;
    }

    String getTruststoreType() {
        return this.truststoreType;
    }

    String getPrng() {
        return this.prng;
    }

    String getCertificateHostCheckAlgorithm() {
        return this.certificateHostCheckAlgorithm;
    }

    boolean isDelegateToKafkaACL() {
        return this.delegateToKafkaACL;
    }

    URI getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    String getClientId() {
        return this.clientId;
    }

    boolean isReuseGrants() {
        return this.reuseGrants;
    }

    String getClusterName() {
        return this.clusterName;
    }

    int getGrantsRefreshPeriodSeconds() {
        return this.grantsRefreshPeriodSeconds;
    }

    int getGrantsMaxIdleTimeSeconds() {
        return this.grantsMaxIdleTimeSeconds;
    }

    int getGrantsRefreshPoolSize() {
        return this.grantsRefreshPoolSize;
    }

    int getGcPeriodSeconds() {
        return this.gcPeriodSeconds;
    }

    List<UserSpec> getSuperUsers() {
        return this.superUsers;
    }

    int getHttpRetries() {
        return this.httpRetries;
    }

    boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    Map<String, ?> getConfigMap() {
        return this.configMap;
    }

    boolean getIncludeAcceptHeader() {
        return this.includeAcceptHeader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.reuseGrants == that.reuseGrants && this.delegateToKafkaACL == that.delegateToKafkaACL && this.grantsRefreshPeriodSeconds == that.grantsRefreshPeriodSeconds && this.grantsMaxIdleTimeSeconds == that.grantsMaxIdleTimeSeconds && this.grantsRefreshPoolSize == that.grantsRefreshPoolSize && this.gcPeriodSeconds == that.gcPeriodSeconds && this.isKRaft == that.isKRaft && this.httpRetries == that.httpRetries && this.enableMetrics == that.enableMetrics && this.connectTimeoutSeconds == that.connectTimeoutSeconds && this.readTimeoutSeconds == that.readTimeoutSeconds && this.includeAcceptHeader == that.includeAcceptHeader && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.truststore, that.truststore) && Objects.equals(this.truststoreData, that.truststoreData) && Objects.equals(this.truststorePassword, that.truststorePassword) && Objects.equals(this.truststoreType, that.truststoreType) && Objects.equals(this.prng, that.prng) && Objects.equals(this.certificateHostCheckAlgorithm, that.certificateHostCheckAlgorithm) && Objects.equals(this.superUsers, that.superUsers) && Objects.equals(this.tokenEndpointUrl, that.tokenEndpointUrl);
    }

    public int hashCode() {
        return Objects.hash(this.reuseGrants, this.clientId, this.clusterName, this.delegateToKafkaACL, this.grantsRefreshPeriodSeconds, this.grantsMaxIdleTimeSeconds, this.grantsRefreshPoolSize, this.gcPeriodSeconds, this.isKRaft, this.truststore, this.truststoreData, this.truststorePassword, this.truststoreType, this.prng, this.certificateHostCheckAlgorithm, this.superUsers, this.httpRetries, this.enableMetrics, this.tokenEndpointUrl, this.connectTimeoutSeconds, this.readTimeoutSeconds, this.includeAcceptHeader);
    }

    private static class Log {
        Level level;
        String message;

        Log(Level level, String message) {
            if (level == null) {
                throw new IllegalArgumentException("level is null");
            }
            this.level = level;
            this.message = message;
        }

        static enum Level {
            WARNING,
            DEBUG;

        }
    }
}

