/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server.authorizer;

import io.strimzi.kafka.oauth.common.ConfigException;
import io.strimzi.kafka.oauth.server.authorizer.Configuration;
import io.strimzi.kafka.oauth.server.authorizer.KeycloakAuthorizerService;
import io.strimzi.kafka.oauth.server.authorizer.KeycloakRBACAuthorizer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakAuthorizer
implements ClusterMetadataAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(KeycloakAuthorizer.class);
    private static final AtomicInteger INSTANCE_NUMBER_COUNTER = new AtomicInteger(1);
    private final int instanceNumber = INSTANCE_NUMBER_COUNTER.getAndIncrement();
    private StandardAuthorizer delegate;
    private KeycloakRBACAuthorizer singleton;

    public void configure(Map<String, ?> configs) {
        Configuration configuration = new Configuration(configs);
        this.singleton = KeycloakAuthorizerService.getInstance();
        if (this.singleton == null) {
            this.singleton = new KeycloakRBACAuthorizer((Authorizer)this);
            this.singleton.configure(configs);
            KeycloakAuthorizerService.setInstance(this.singleton);
        } else if (!configuration.equals(this.singleton.getConfiguration())) {
            throw new ConfigException("Only one authorizer configuration per JVM is supported");
        }
        if (configuration.isDelegateToKafkaACL() && configuration.isKRaft()) {
            this.delegate = this.instantiateStandardAuthorizer();
            this.delegate.configure(configs);
        }
        if (log.isDebugEnabled()) {
            log.debug("Configured " + this + " using " + this.singleton);
        }
    }

    private StandardAuthorizer instantiateStandardAuthorizer() {
        try {
            log.debug("Using StandardAuthorizer (KRaft based) as a delegate");
            return new StandardAuthorizer();
        }
        catch (Exception e) {
            throw new ConfigException("KRaft mode detected ('process.roles' configured), but failed to instantiate org.apache.kafka.metadata.authorizer.StandardAuthorizer", (Throwable)e);
        }
    }

    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        if (this.delegate != null) {
            return this.delegate.start(serverInfo);
        }
        return this.singleton.start(serverInfo);
    }

    public void setAclMutator(AclMutator aclMutator) {
        if (this.delegate != null) {
            this.delegate.setAclMutator(aclMutator);
        }
    }

    public AclMutator aclMutatorOrException() {
        if (this.delegate != null) {
            return this.delegate.aclMutatorOrException();
        }
        throw new IllegalStateException("KeycloakAuthorizer has not been properly configured");
    }

    public void completeInitialLoad() {
        if (this.delegate != null) {
            this.delegate.completeInitialLoad();
        }
    }

    public void completeInitialLoad(Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
        if (this.delegate != null) {
            this.delegate.completeInitialLoad(e);
        }
    }

    public void loadSnapshot(Map<Uuid, StandardAcl> acls) {
        if (this.delegate != null) {
            this.delegate.loadSnapshot(acls);
        }
    }

    public void addAcl(Uuid id, StandardAcl acl) {
        if (this.delegate == null) {
            throw new UnsupportedOperationException("ACL delegation not enabled");
        }
        this.delegate.addAcl(id, acl);
    }

    public void removeAcl(Uuid id) {
        if (this.delegate == null) {
            throw new UnsupportedOperationException("ACL delegation not enabled");
        }
        this.delegate.removeAcl(id);
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        if (this.delegate != null) {
            return this.delegate.acls(filter);
        }
        if (this.singleton != null) {
            return this.singleton.acls(filter);
        }
        throw new UnsupportedOperationException("ACL delegation not enabled");
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        if (this.delegate != null) {
            return this.delegate.createAcls(requestContext, aclBindings);
        }
        if (this.singleton != null) {
            return this.singleton.createAcls(requestContext, aclBindings);
        }
        throw new UnsupportedOperationException("ACL delegation not enabled");
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        if (this.delegate != null) {
            return this.delegate.deleteAcls(requestContext, aclBindingFilters);
        }
        if (this.singleton != null) {
            return this.singleton.deleteAcls(requestContext, aclBindingFilters);
        }
        throw new UnsupportedOperationException("ACL delegation not enabled");
    }

    public int aclCount() {
        if (this.delegate != null) {
            return this.delegate.aclCount();
        }
        if (this.singleton != null) {
            return this.singleton.aclCount();
        }
        throw new UnsupportedOperationException("ACL delegation not enabled");
    }

    public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        if (this.delegate != null) {
            return this.delegate.authorizeByResourceType(requestContext, op, resourceType);
        }
        if (this.singleton != null) {
            return this.singleton.authorizeByResourceType(requestContext, op, resourceType);
        }
        throw new UnsupportedOperationException("ACL delegation not enabled");
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        if (this.delegate != null) {
            return this.singleton.authorize((Authorizer)this.delegate, requestContext, actions);
        }
        return this.singleton.authorize(requestContext, actions);
    }

    public void close() throws IOException {
        if (this.singleton != null) {
            this.singleton.close();
        }
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public String toString() {
        return KeycloakAuthorizer.class.getSimpleName() + "@" + this.instanceNumber;
    }
}

