/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.server.authorizer;

import com.fasterxml.jackson.databind.JsonNode;
import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.common.HttpException;
import io.strimzi.kafka.oauth.common.HttpUtil;
import io.strimzi.kafka.oauth.common.JSONUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.OAuthAuthenticator;
import io.strimzi.kafka.oauth.common.SSLUtil;
import io.strimzi.kafka.oauth.common.TimeUtil;
import io.strimzi.kafka.oauth.metrics.SensorKeyProducer;
import io.strimzi.kafka.oauth.server.OAuthKafkaPrincipal;
import io.strimzi.kafka.oauth.server.authorizer.Configuration;
import io.strimzi.kafka.oauth.server.authorizer.GrantsHandler;
import io.strimzi.kafka.oauth.server.authorizer.KeycloakAuthorizer;
import io.strimzi.kafka.oauth.server.authorizer.ResourceSpec;
import io.strimzi.kafka.oauth.server.authorizer.ScopesSpec;
import io.strimzi.kafka.oauth.server.authorizer.UserSpec;
import io.strimzi.kafka.oauth.server.authorizer.metrics.GrantsHttpSensorKeyProducer;
import io.strimzi.kafka.oauth.server.authorizer.metrics.KeycloakAuthorizationSensorKeyProducer;
import io.strimzi.kafka.oauth.services.OAuthMetrics;
import io.strimzi.kafka.oauth.services.ServiceException;
import io.strimzi.kafka.oauth.services.Services;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kafka.security.authorizer.AclAuthorizer;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class KeycloakRBACAuthorizer
implements Authorizer {
    static final Logger log = LoggerFactory.getLogger(KeycloakRBACAuthorizer.class);
    static final Logger GRANT_LOG = LoggerFactory.getLogger((String)(KeycloakRBACAuthorizer.class.getName() + ".grant"));
    static final Logger DENY_LOG = LoggerFactory.getLogger((String)(KeycloakRBACAuthorizer.class.getName() + ".deny"));
    private static final AtomicInteger INSTANCE_NUMBER_COUNTER = new AtomicInteger(1);
    private final int instanceNumber = INSTANCE_NUMBER_COUNTER.getAndIncrement();
    private final Authorizer delegator;
    private SSLSocketFactory socketFactory;
    private HostnameVerifier hostnameVerifier;
    private final boolean denyWhenTokenInvalid = true;
    private OAuthMetrics metrics;
    private SensorKeyProducer authzSensorKeyProducer;
    private SensorKeyProducer grantsSensorKeyProducer;
    private Authorizer delegate;
    private GrantsHandler grantsHandler;
    private Configuration configuration;

    public KeycloakRBACAuthorizer() {
        log.warn("KeycloakRBACAuthorizer has been deprecated, please use '{}' instead.", (Object)KeycloakAuthorizer.class.getName());
        this.delegator = null;
    }

    KeycloakRBACAuthorizer(Authorizer delegator) {
        this.delegator = delegator;
    }

    public void configure(Map<String, ?> configs) {
        this.configuration = new Configuration(configs);
        this.configuration.printLogs();
        this.assignFields(this.configuration);
        if (log.isDebugEnabled()) {
            log.debug("Configured " + this + (this.delegator != null ? " (via " + this.delegator + ")" : "") + ":\n    tokenEndpointUri: " + this.configuration.getTokenEndpointUrl() + "\n    sslSocketFactory: " + this.socketFactory + "\n    hostnameVerifier: " + this.hostnameVerifier + "\n    clientId: " + this.configuration.getClientId() + "\n    clusterName: " + this.configuration.getClusterName() + "\n    delegateToKafkaACL: " + this.configuration.isDelegateToKafkaACL() + "\n    superUsers: " + this.configuration.getSuperUsers().stream().map(u -> "'" + u.getType() + ":" + u.getName() + "'").collect(Collectors.toList()) + "\n    grantsRefreshPeriodSeconds: " + this.configuration.getGrantsRefreshPeriodSeconds() + "\n    grantsRefreshPoolSize: " + this.configuration.getGrantsRefreshPoolSize() + "\n    grantsMaxIdleTimeSeconds: " + this.configuration.getGrantsMaxIdleTimeSeconds() + "\n    httpRetries: " + this.configuration.getHttpRetries() + "\n    reuseGrants: " + this.configuration.isReuseGrants() + "\n    connectTimeoutSeconds: " + this.configuration.getConnectTimeoutSeconds() + "\n    readTimeoutSeconds: " + this.configuration.getReadTimeoutSeconds() + "\n    enableMetrics: " + this.configuration.isEnableMetrics() + "\n    gcPeriodSeconds: " + this.configuration.getGcPeriodSeconds() + "\n    includeAcceptHeader: " + this.configuration.getIncludeAcceptHeader());
        }
    }

    private void assignFields(Configuration configuration) {
        this.socketFactory = KeycloakRBACAuthorizer.createSSLFactory(configuration);
        this.hostnameVerifier = KeycloakRBACAuthorizer.createHostnameVerifier(configuration);
        if (configuration.isDelegateToKafkaACL()) {
            this.setupDelegateAuthorizer();
        }
        if (!Services.isAvailable()) {
            Services.configure(configuration.getConfigMap());
        }
        if (configuration.isEnableMetrics()) {
            this.metrics = Services.getInstance().getMetrics();
        }
        this.authzSensorKeyProducer = new KeycloakAuthorizationSensorKeyProducer("keycloak-authorizer", configuration.getTokenEndpointUrl());
        this.grantsSensorKeyProducer = new GrantsHttpSensorKeyProducer("keycloak-authorizer", configuration.getTokenEndpointUrl());
        this.grantsHandler = new GrantsHandler(configuration.getGrantsRefreshPeriodSeconds(), configuration.getGrantsRefreshPoolSize(), configuration.getGrantsMaxIdleTimeSeconds(), this::fetchAuthorizationGrantsOnce, configuration.getHttpRetries(), configuration.getGcPeriodSeconds());
        if (this.delegate != null) {
            this.delegate.configure(configuration.getConfigMap());
        }
    }

    void setupDelegateAuthorizer() {
        if (this.delegate == null && !this.configuration.isKRaft()) {
            log.debug("Using AclAuthorizer (ZooKeeper based) as a delegate");
            this.delegate = new AclAuthorizer();
        }
    }

    static SSLSocketFactory createSSLFactory(Configuration config) {
        return SSLUtil.createSSLFactory((String)config.getTruststore(), (String)config.getTruststoreData(), (String)config.getTruststorePassword(), (String)config.getTruststoreType(), (String)config.getPrng());
    }

    static HostnameVerifier createHostnameVerifier(Configuration config) {
        return "".equals(config.getCertificateHostCheckAlgorithm()) ? SSLUtil.createAnyHostHostnameVerifier() : null;
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        return this.authorize(this.delegate, requestContext, actions);
    }

    List<AuthorizationResult> authorize(Authorizer delegate, AuthorizableRequestContext requestContext, List<Action> actions) {
        JsonNode grants = null;
        long startTime = System.currentTimeMillis();
        try {
            boolean mustReload;
            KafkaPrincipal principal = requestContext.principal();
            for (UserSpec u : this.configuration.getSuperUsers()) {
                if (!principal.getPrincipalType().equals(u.getType()) || !principal.getName().equals(u.getName())) continue;
                for (Action action : actions) {
                    if (!GRANT_LOG.isDebugEnabled() || !action.logIfAllowed()) continue;
                    GRANT_LOG.debug("Authorization GRANTED - user is a superuser: " + requestContext.principal() + ", cluster: " + this.configuration.getClusterName() + ", operation: " + action.operation() + ", resource: " + this.fromResourcePattern(action.resourcePattern()));
                }
                this.addAuthzMetricSuccessTime(startTime);
                return Collections.nCopies(actions.size(), AuthorizationResult.ALLOWED);
            }
            if (!(principal instanceof OAuthKafkaPrincipal)) {
                List<AuthorizationResult> result = this.delegateIfRequested(delegate, requestContext, actions, null);
                this.addAuthzMetricSuccessTime(startTime);
                return result;
            }
            BearerTokenWithPayload token = ((OAuthKafkaPrincipal)principal).getJwt();
            if (this.denyIfTokenInvalid(token)) {
                this.addAuthzMetricSuccessTime(startTime);
                return Collections.nCopies(actions.size(), AuthorizationResult.DENIED);
            }
            if (this.grantsHandler == null) {
                throw new IllegalStateException("Authorizer has not been configured - configure() not called");
            }
            GrantsHandler.Info grantsInfo = this.grantsHandler.getGrantsInfoFromCache(token);
            log.trace("Got grantsInfo: {}", (Object)grantsInfo);
            grants = grantsInfo.getGrants();
            boolean newSession = token.getPayload() == null;
            boolean bl = mustReload = !this.configuration.isReuseGrants() && newSession;
            if (grants == null || mustReload) {
                if (grants == null) {
                    log.debug("No grants yet for user: {}", (Object)principal);
                } else {
                    log.debug("Grants available but new session and reuseGrants is `false`");
                }
                grants = this.grantsHandler.fetchGrantsForUserOrWaitForDelivery(principal.getName(), grantsInfo);
                if (mustReload) {
                    token.setPayload((JsonNode)JSONUtil.newObjectNode());
                }
            }
            log.debug("Got grants for '{}': {}", (Object)principal, (Object)grants);
            List<AuthorizationResult> result = grants != null ? this.allowOrDenyBasedOnGrants(delegate, requestContext, actions, grants) : this.delegateIfRequested(delegate, requestContext, actions, null);
            this.addAuthzMetricSuccessTime(startTime);
            return result;
        }
        catch (Throwable t) {
            log.error("An unexpected exception has occurred: ", t);
            if (DENY_LOG.isDebugEnabled()) {
                DENY_LOG.debug("Authorization DENIED due to error - user: " + requestContext.principal() + ", cluster: " + this.configuration.getClusterName() + ", actions: " + actions + ",\n permissions: " + grants);
            }
            this.addAuthzMetricErrorTime(t, startTime);
            return Collections.nCopies(actions.size(), AuthorizationResult.DENIED);
        }
    }

    private String fromResourcePattern(ResourcePattern pattern) {
        return pattern.resourceType() + ":" + pattern.name();
    }

    private List<AuthorizationResult> allowOrDenyBasedOnGrants(Authorizer delegate, AuthorizableRequestContext requestContext, List<Action> actions, JsonNode grants) {
        ArrayList<AuthorizationResult> results = new ArrayList<AuthorizationResult>(actions.size());
        block0: for (Action action : actions) {
            for (JsonNode permission : grants) {
                ScopesSpec grantedScopes;
                String name = permission.get("rsname").asText();
                ResourceSpec resourceSpec = ResourceSpec.of(name);
                if (!resourceSpec.match(this.configuration.getClusterName(), action.resourcePattern().resourceType().name(), action.resourcePattern().name())) continue;
                JsonNode scopes = permission.get("scopes");
                ScopesSpec scopesSpec = grantedScopes = scopes == null ? null : ScopesSpec.of(KeycloakRBACAuthorizer.validateScopes(JSONUtil.asListOfString((JsonNode)scopes)));
                if (scopes != null && !grantedScopes.isGranted(action.operation().name())) continue;
                if (GRANT_LOG.isDebugEnabled() && action.logIfAllowed()) {
                    GRANT_LOG.debug("Authorization GRANTED - cluster: " + this.configuration.getClusterName() + ", user: " + requestContext.principal() + ", operation: " + action.operation() + ", resource: " + this.fromResourcePattern(action.resourcePattern()) + "\nGranted scopes for resource (" + resourceSpec + "): " + (grantedScopes == null ? "ALL" : grantedScopes));
                }
                results.add(AuthorizationResult.ALLOWED);
                continue block0;
            }
            results.addAll(this.delegateIfRequested(delegate, requestContext, Collections.singletonList(action), grants));
        }
        return results;
    }

    private boolean denyIfTokenInvalid(BearerTokenWithPayload token) {
        if (token.lifetimeMs() <= System.currentTimeMillis()) {
            if (DENY_LOG.isDebugEnabled()) {
                DENY_LOG.debug("Authorization DENIED due to token expiry - The token expired at: " + token.lifetimeMs() + " (" + TimeUtil.formatIsoDateTimeUTC((long)token.lifetimeMs()) + " UTC), for token: " + LogUtil.mask((String)token.value()));
            }
            return true;
        }
        return false;
    }

    static List<ScopesSpec.AuthzScope> validateScopes(List<String> scopes) {
        ArrayList<ScopesSpec.AuthzScope> enumScopes = new ArrayList<ScopesSpec.AuthzScope>(scopes.size());
        for (String name : scopes) {
            try {
                enumScopes.add(ScopesSpec.AuthzScope.of(name));
            }
            catch (Exception e) {
                log.warn("[IGNORED] Invalid scope detected in authorization scopes list: " + name);
            }
        }
        return enumScopes;
    }

    private List<AuthorizationResult> delegateIfRequested(Authorizer delegate, AuthorizableRequestContext context, List<Action> actions, JsonNode authz) {
        block10: {
            String nonAuthMessageFragment;
            block9: {
                String string = nonAuthMessageFragment = context.principal() instanceof OAuthKafkaPrincipal ? "" : " non-oauth";
                if (delegate != null) {
                    List results = delegate.authorize(context, actions);
                    int i = 0;
                    for (AuthorizationResult result : results) {
                        boolean denyLogOn;
                        Action action = actions.get(i);
                        boolean grantLogOn = result == AuthorizationResult.ALLOWED && GRANT_LOG.isDebugEnabled() && action.logIfAllowed();
                        boolean bl = denyLogOn = result == AuthorizationResult.DENIED && DENY_LOG.isDebugEnabled() && action.logIfDenied();
                        if (grantLogOn || denyLogOn) {
                            String status = result == AuthorizationResult.ALLOWED ? "GRANTED" : "DENIED";
                            String message = this.getACLMessage(context, nonAuthMessageFragment, action, status);
                            if (grantLogOn) {
                                GRANT_LOG.debug(message);
                            } else {
                                DENY_LOG.debug(message);
                            }
                        } else if (result == AuthorizationResult.DENIED && log.isDebugEnabled()) {
                            log.debug(this.getACLMessage(context, nonAuthMessageFragment, action, "DENIED"));
                        }
                        ++i;
                    }
                    return results;
                }
                if (!DENY_LOG.isDebugEnabled()) break block9;
                for (Action action : actions) {
                    if (!action.logIfDenied()) continue;
                    this.logDenied(DENY_LOG, context, authz, nonAuthMessageFragment, action);
                }
                break block10;
            }
            if (!log.isDebugEnabled()) break block10;
            for (Action action : actions) {
                this.logDenied(log, context, authz, nonAuthMessageFragment, action);
            }
        }
        return Collections.nCopies(actions.size(), AuthorizationResult.DENIED);
    }

    private String getACLMessage(AuthorizableRequestContext context, String nonAuthMessageFragment, Action action, String status) {
        return "Authorization " + status + " by ACL -" + nonAuthMessageFragment + " user: " + context.principal() + ", operation: " + action.operation() + ", resource: " + this.fromResourcePattern(action.resourcePattern());
    }

    private void logDenied(Logger logger, AuthorizableRequestContext context, JsonNode authz, String nonAuthMessageFragment, Action action) {
        logger.debug("Authorization DENIED -" + nonAuthMessageFragment + " user: " + context.principal() + ", cluster: " + this.configuration.getClusterName() + ", operation: " + action.operation() + ", resource: " + this.fromResourcePattern(action.resourcePattern()) + ",\n permissions: " + authz);
    }

    private JsonNode fetchAuthorizationGrantsOnce(String token) {
        JsonNode response;
        String authorization = "Bearer " + token;
        StringBuilder body = new StringBuilder("audience=").append(OAuthAuthenticator.urlencode((String)this.configuration.getClientId())).append("&grant_type=").append(OAuthAuthenticator.urlencode((String)"urn:ietf:params:oauth:grant-type:uma-ticket")).append("&response_mode=permissions");
        long startTime = System.currentTimeMillis();
        try {
            response = (JsonNode)HttpUtil.post((URI)this.configuration.getTokenEndpointUrl(), (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)authorization, (String)"application/x-www-form-urlencoded", (String)body.toString(), JsonNode.class, (int)this.configuration.getConnectTimeoutSeconds(), (int)this.configuration.getReadTimeoutSeconds(), (boolean)this.configuration.getIncludeAcceptHeader());
            this.addGrantsHttpMetricSuccessTime(startTime);
        }
        catch (HttpException e) {
            this.addGrantsHttpMetricErrorTime(e, startTime);
            throw e;
        }
        catch (Exception e) {
            this.addGrantsHttpMetricErrorTime(e, startTime);
            throw new ServiceException("Failed to fetch authorization data from authorization server: ", (Throwable)e);
        }
        return response;
    }

    public void close() {
        if (this.grantsHandler != null) {
            try {
                this.grantsHandler.close();
            }
            catch (Exception e) {
                log.error("Failed to shutdown the worker pool", (Throwable)e);
            }
        }
        if (this.delegate != null) {
            try {
                this.delegate.close();
            }
            catch (Exception e) {
                log.error("Failed to close the delegate authorizer", (Throwable)e);
            }
        }
    }

    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        if (this.delegate == null) {
            return serverInfo.endpoints().stream().collect(Collectors.toMap(Function.identity(), e -> future));
        }
        return this.delegate.start(serverInfo);
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        if (this.delegate == null) {
            throw new UnsupportedOperationException("Simple ACL delegation not enabled");
        }
        return this.delegate.createAcls(requestContext, aclBindings);
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        if (this.delegate == null) {
            throw new UnsupportedOperationException("Simple ACL delegation not enabled");
        }
        return this.delegate.deleteAcls(requestContext, aclBindingFilters);
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        if (this.delegate == null) {
            throw new UnsupportedOperationException("Simple ACL delegation not enabled");
        }
        return this.delegate.acls(filter);
    }

    private void addAuthzMetricSuccessTime(long startTimeMs) {
        if (this.configuration.isEnableMetrics()) {
            this.metrics.addTime(this.authzSensorKeyProducer.successKey(), System.currentTimeMillis() - startTimeMs);
        }
    }

    private void addAuthzMetricErrorTime(Throwable e, long startTimeMs) {
        if (this.configuration.isEnableMetrics()) {
            this.metrics.addTime(this.authzSensorKeyProducer.errorKey(e), System.currentTimeMillis() - startTimeMs);
        }
    }

    private void addGrantsHttpMetricSuccessTime(long startTimeMs) {
        if (this.configuration.isEnableMetrics()) {
            this.metrics.addTime(this.grantsSensorKeyProducer.successKey(), System.currentTimeMillis() - startTimeMs);
        }
    }

    private void addGrantsHttpMetricErrorTime(Throwable e, long startTimeMs) {
        if (this.configuration.isEnableMetrics()) {
            this.metrics.addTime(this.grantsSensorKeyProducer.errorKey(e), System.currentTimeMillis() - startTimeMs);
        }
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return KeycloakRBACAuthorizer.class.getSimpleName() + "@" + this.instanceNumber;
    }
}

